/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docBuf.h"
#   include	"docEvalField.h"

/************************************************************************/
/*									*/
/*  Format the value of a 'chftn' field.				*/
/*									*/
/*  I.E. the text of the reference to the note in the body of the text,	*/
/*	or the identical sign at the begnning of the note.		*/
/*									*/
/************************************************************************/

static int docFormatChftnField( unsigned char *			target,
				int				targetSize,
				const DocumentField *		df,
				const DocumentProperties *	dp,
				int				noteNumber,
				int				extItKind )
    {
    const NotesProperties *	np;

    switch( extItKind )
	{
	case DOCinFOOTNOTE:
	    np= &(dp->dpFootnoteProperties);
	    break;

	case DOCinENDNOTE:
	    np= &(dp->dpEndnoteProperties);
	    break;

	default:
	    SDEB(docExternalKindStr(extItKind)); return -1;
	}

    if  ( np->npRestart == DPftnRST_CONTINUOUS )
	{ noteNumber += np->npStartNumber- 1;	}

    switch( np->npNumberStyle )
	{
	case DPftnNAR:
	    sprintf( (char *)target, "%d", noteNumber+ 1 );
	    break;

	case DPftnNALC:
	    if  ( noteNumber >= 0 && noteNumber <= 26 )
		{ target[0]= 'a'+ noteNumber; target[1]= '\0';	}
	    else{ sprintf( (char *)target, "lcltr:%d", noteNumber+ 1 );	}
	    break;

	case DPftnNAUC:
	    if  ( noteNumber >= 0 && noteNumber <= 26 )
		{ target[0]= 'A'+ noteNumber; target[1]= '\0';	}
	    else{ sprintf( (char *)target, "lcltr:%d", noteNumber+ 1 );	}
	    break;

	case DPftnNRLC:
	    if  ( appRomanString( (char *)target, targetSize,
							noteNumber+ 1, 0 ) )
		{ sprintf( (char *)target, "NRLC:%d", noteNumber+ 1 );	}
	    break;

	case DPftnNRUC:
	    if  ( appRomanString( (char *)target, targetSize,
							noteNumber+ 1, 1 ) )
		{ sprintf( (char *)target, "NRUC:%d", noteNumber+ 1 );	}
	    break;

	case DPftnNCHI:
	default:
	    LDEB(np->npNumberStyle);
	    sprintf( (char *)target, "(%d)", noteNumber+ 1 );
	    break;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Evaluate Footnote number fields.					*/
/*									*/
/************************************************************************/

int docCalculateChftnFieldString(	int *			pCalculated,
					int *			pNewSize,
					unsigned char *		target,
					int			targetSize,
					BufferDocument *	bd,
					const BufferItem *	paraBi,
					int			part,
					int			partCount,
					const DocumentField *	dfChftn )
    {
    DocumentNote *	dn;
    TextParticule *	tp;

    if  ( paraBi->biInExternalItem == DOCinBODY			&&
	  part+ 1+ partCount+ 1 < paraBi->biParaParticuleCount	)
	{
	tp= paraBi->biParaParticules+ part+ 1+ partCount+ 1;

	if  ( tp->tpKind != DOCkindNOTE )
	    {
	    SDEB(docKindStr(tp->tpKind));
	    *pCalculated= 0;
	    return 0;
	    }

	if  ( docGetNote( &dn, bd, paraBi, tp->tpStroff ) < 0 )
	    { LDEB(tp->tpStroff); *pCalculated= 0; return 0; }

	if  ( docFormatChftnField( target, targetSize,
					    dfChftn, &(bd->bdProperties),
					    dn->dnNoteNumber,
					    dn->dnExternalItemKind ) )
	    { LDEB(dn->dnExternalItemKind); *pCalculated= 0; return 0; }

	*pNewSize= strlen( (char *)target );
	*pCalculated= 1;
	return 0;
	}

    if  ( paraBi->biInExternalItem == DOCinFOOTNOTE	||
	  paraBi->biInExternalItem == DOCinENDNOTE	)
	{
	tp= paraBi->biParaParticules;

	if  ( docGetNote( &dn, bd, paraBi, tp->tpStroff ) < 0 )
	    { LDEB(tp->tpStroff); *pCalculated= 0; return 0; }

	if  ( docFormatChftnField( target, targetSize,
					    dfChftn, &(bd->bdProperties),
					    dn->dnNoteNumber,
					    dn->dnExternalItemKind ) )
	    { LDEB(dn->dnExternalItemKind); *pCalculated= 0; return 0; }

	*pNewSize= strlen( (char *)target );
	*pCalculated= 1;
	return 0;
	}

    LLDEB(paraBi->biInExternalItem,part);
    *pCalculated= 0; return 0;
    }

/************************************************************************/
/*									*/
/*  Evaluate Footnote number fields.					*/
/*									*/
/************************************************************************/

int docRecalculateParaChftnTextParticules(
				int *				pCalculated,
				BufferDocument *		bd,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			bi,
				int				part,
				int				partCount,
				DocumentField *			df,
				void *				voidadd,
				DOC_CLOSE_OBJECT		closeObject )
    {
    int		ret;

    ret= docRecalculateParaStringTextParticules( pCalculated, bd,
			    pPartShift, pStroffShift, bi, part, partCount,
			    df, voidadd, closeObject );

    if  ( ret )
	{ LDEB(ret); return ret;	}

    if  ( *pCalculated )
	{
	TextParticule *		tp;
	int			i;

	tp= bi->biParaParticules+ part+ 1;
	for ( i= 0; i < partCount+ *pPartShift; tp++, i++ )
	    {
	    if  ( tp->tpTextAttribute.taSuperSub != DOCfontSUPERSCRIPT )
		{
		tp->tpTextAttribute.taSuperSub= DOCfontSUPERSCRIPT;
		tp->tpPhysicalFont= -1;
		}
	    }
	}

    return ret;
    }
