/*
 * synaptiks -- a touchpad control tool
 *
 *
 * Copyright (C) 2009, 2010 Sebastian Wiesner <basti.wiesner@gmx.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QXINPUT2_H
#define QXINPUT2_H

/**
 * @file
 *
 * This file exports functions from version 2 of the X11 XInput extension.
 * These functions work just like their counterparts from the XLib headers,
 * except that they implicitly use QX11Info::display().
 *
 * Read the XLib manpages for detailled information about these functions.
 */

#include "config-synaptiks.h"
#ifndef HAVE_XINPUT2
#error "XInput2 not enabled, do NOT use this file"
#endif

#include <QtGui/QX11Info>
extern "C" {
#include <X11/extensions/XInput2.h>
}
#include "qxlib.h"

namespace QX11 {

    namespace XI {

        inline int QueryVersion(int *major_version_out,
                                int *minor_version_out) {
            return XIQueryVersion(QX11Info::display(), major_version_out,
                                  minor_version_out);
        }

        inline XIDeviceInfo *QueryDevice(int deviceid,
                                         int *ndevices_return) {
            return XIQueryDevice(QX11Info::display(), deviceid,
                                 ndevices_return);
        }

        inline Atom *ListProperties(int deviceid, int *nprops_return) {
            return XIListProperties(QX11Info::display(), deviceid,
                                    nprops_return);
        }

        inline int GetProperty(int deviceid, Atom property,
                               long offset, long length,
                               bool delete_property, Atom type,
                               Atom *type_return, int *format_return,
                               unsigned long *num_items_return,
                               unsigned long *bytes_after_return,
                               unsigned char **data) {
            return XIGetProperty(QX11Info::display(), deviceid, property,
                                 offset, length, delete_property, type,
                                 type_return, format_return,
                                 num_items_return, bytes_after_return,
                                 data);
        }

        inline void ChangeProperty(int deviceid, Atom property, Atom type,
                                   int format, int mode,
                                   unsigned char *data, int num_items) {
            return XIChangeProperty(QX11Info::display(), deviceid,
                                    property, type, format, mode, data,
                                    num_items);
        }

    }
}

#endif /* QXINPUT2_H */
