/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Foobar is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Foobar is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "global.hh"
#include <iostream>
#include <gtkmm/aboutdialog.h>




TWindow1::TWindow1() {
	Gtk::TreeViewColumn *column;

	//=== Sounds List ===
	store_sounds = Gtk::ListStore::create(ListView);
	treeview1->set_model(store_sounds);
	treeview1->set_reorderable(false);
	
	//--Column for icon
	Gtk::CellRendererPixbuf* my_render = new Gtk::CellRendererPixbuf;
	my_render->set_property("stock_id", Gtk::StockID(Gtk::Stock::ABOUT));

	treeview1->append_column("", *my_render);
	if (column = treeview1->get_column(0)) {
		column->set_sizing(Gtk::TREE_VIEW_COLUMN_FIXED);
		column->set_fixed_width(32);
	}

	//--Other columns
	SOUNDS_LIST_INIT;


	store_index = Gtk::ListStore::create(ListBox);
	treeview2->set_model(store_index);
	treeview2->set_headers_visible(false);
	treeview2->append_column("", ListBox.caption);

	//=== Languages ===
	store_lang = Gtk::ListStore::create(ListExt);
	combobox1->set_model(store_lang);
	combobox1->pack_start(ListExt.caption);
	combobox1->pack_start(ListExt.value);


	//=== Fields for index ===
	store_fields = Gtk::ListStore::create(ListExt);
	combobox2->set_model(store_fields);
	combobox2->pack_start(ListExt.caption);
	

	SELECT_FIELD_INIT;
	combobox2->signal_changed().connect(sigc::mem_fun(*this, &TWindow1::on_combobox2_changed) );


	//=== Sound Info =======
	store_info = Gtk::TreeStore::create(ListSoundInfo);
	treeview3->set_model(store_info);
	treeview3->set_headers_visible(false);

	//--Col 1
	Gtk::CellRendererText* my_render_col1 = new Gtk::CellRendererText;

	treeview3->append_column("Field", *my_render_col1);
	if (column = treeview3->get_column(0))  {
		column->add_attribute(my_render_col1->property_text(), ListSoundInfo.caption);
		column->add_attribute(my_render_col1->property_weight(), ListSoundInfo.weight);
	}

	
	//--Col 2
	Gtk::CellRendererText* my_render_col2 = new Gtk::CellRendererText;
	my_render_col2->set_property("wrap_mode", Pango::WRAP_WORD);
	my_render_col2->set_property("wrap_width", 450);
	my_render_col2->set_property("foreground_gdk", Gdk::Color("#606060"));
	my_render_col2->set_property("editable", true);

	treeview3->append_column("Value", *my_render_col2);
	if (column = treeview3->get_column(1)) 
		column->add_attribute(my_render_col2->property_text(), ListSoundInfo.value);


	SOUND_INFO_INIT;
	treeview3->expand_all();
}


void TWindow1::init() {  
	show_lang();
	
	if (Gtk::TreeModel::Row row = store_lang->children()[0])
		combobox1->set_active(row);	

	statusbar1->push("Welcome to SWAC Explorer!");
}



static int show_lang_callback(void *NotUsed, int argc, char **argv, char **azColName){
	if (argc == 2) {
		Gtk::TreeRow row = *(Window1->store_lang->append());
		row[Window1->ListExt.value] = argv[0];
		row[Window1->ListExt.caption] = argv[1];
	}
	return 0;
}

void TWindow1::show_lang() { 
	store_lang->clear();
	db->exec("SELECT SWAC_LANG, languages.title FROM sounds INNER JOIN languages ON SWAC_LANG=languages.iso_639_3 GROUP BY SWAC_LANG ORDER BY SWAC_LANG;", show_lang_callback, NULL);
}


static int show_sound_info_callback(void *NotUsed, int argc, char **argv, char **azColName){
	SOUND_INFO_SET;	
	return 0;
}

void TWindow1::show_sound_info(std::string idx) { 
	std::string fields(SOUND_INFO_FIELDS); 
	std::string query("SELECT " + fields + " FROM sounds INNER JOIN packages ON sounds.packages_idx=packages.idx WHERE sounds.idx=" + sql_str(idx) + ";");
	db->exec(query.c_str(), show_sound_info_callback, NULL);
}



void TWindow1::on_treeview1_cursor_changed() {
	if (Gtk::TreeModel::iterator iter = treeview1->get_selection()->get_selected()) {
  		Gtk::TreeModel::Row row = *iter;
		show_sound_info(row[ListView.idx] + "");
	}
}



static int show_sounds_callback(void *NotUsed, int argc, char **argv, char **azColName){
	SOUNDS_LIST_SET;
	return 0;
}

void TWindow1::show_sounds(std::string filter) { 
	store_sounds->clear();
	std::string fields(SOUNDS_LIST_FIELDS);
	std::string query("SELECT " + fields + " FROM sounds INNER JOIN packages ON sounds.packages_idx=packages.idx");
	if (filter != "") query += " WHERE " + filter;
	query += " ORDER BY SWAC_LANG, SWAC_TEXT;";	
	db->exec(query.c_str(), show_sounds_callback, NULL);
}



static int show_index_callback(void *NotUsed, int argc, char **argv, char **azColName){
	if (argc == 1) {
		Gtk::TreeRow row = *(Window1->store_index->append());
		row[Window1->ListBox.caption] = argv[0];
	}
	return 0;
}


void TWindow1::show_index_alphaidx(std::string filter) { 
	store_index->clear();
	std::string query("SELECT str FROM alphaidx, sounds");
	if (filter != "") query += " WHERE alphaidx.sounds_idx=sounds.idx AND " + filter;
	query += " GROUP BY str ORDER BY str;";	
	db->exec(query.c_str(), show_index_callback, NULL);
}



void TWindow1::show_index_else(std::string filter, std::string field) { 
	store_index->clear();
	std::string query ("SELECT `" + field + "` FROM sounds");
	if (filter != "") query += " WHERE " + filter;
	query += " GROUP BY `" + field + "` ORDER BY `" + field + "`;";
	db->exec(query.c_str(), show_index_callback, NULL);
}


void TWindow1::select_index(std::string filter, std::string field,  std::string str) {
	std::string _filter("`" + field + "` = " + sql_str(str));
	if (filter != "") _filter += " AND " + filter;
	show_sounds(_filter.c_str());
	
}

void TWindow1::select_index_alphaidx(std::string filter, std::string str) {
	store_sounds->clear();
	std::string fields(SOUNDS_LIST_FIELDS);
	std::string query("SELECT " + fields + " FROM sounds, alphaidx INNER JOIN packages ON sounds.packages_idx=packages.idx WHERE alphaidx.str=" + sql_str(str) + " AND alphaidx.sounds_idx=sounds.idx");
	if (filter != "") query += " AND " + filter;
	query += " ORDER BY SWAC_LANG,SWAC_TEXT;";	
	db->exec(query.c_str(), show_sounds_callback, NULL);
}

void TWindow1::on_treeview2_cursor_changed() {
	if (Gtk::TreeModel::iterator iter = treeview2->get_selection()->get_selected()) {
  		Gtk::TreeModel::Row row = *iter;
		if (user_index_field == "SWAC_ALPHAIDX")
			select_index_alphaidx(user_filter, std::string(row[ListBox.caption] + ""));
		else
			select_index(user_filter, user_index_field, std::string(row[ListBox.caption] + ""));

		treeview1->set_cursor(Gtk::TreePath(1));
	}
}



void TWindow1::show_index() {
	if (user_index_field == "SWAC_ALPHAIDX")
		show_index_alphaidx(user_filter.c_str());
	else
		show_index_else(user_filter, user_index_field);
}

void TWindow1::on_refresh_clicked() {
	user_filter = entry1->get_text();
	
	show_index();
}


void TWindow1::on_combobox1_changed() {
	if (Gtk::TreeModel::iterator iter = combobox1->get_active()) {
		Gtk::TreeModel::Row row = *iter;

		user_filter = "`SWAC_LANG` = '" + row[ListExt.value] + "'";
		entry1->set_text(user_filter);
		show_index();
	}
}

void TWindow1::on_combobox2_changed() {
	if (Gtk::TreeModel::iterator iter = combobox2->get_active()) {
		Gtk::TreeModel::Row row = *iter;

		user_index_field = row[ListExt.value] + "";
		show_index();
	}
}

void TWindow1::on_search_clicked() {
	std::string filter("`SWAC_TEXT` LIKE " + sql_str("%" + entry3->get_text() + "%"));
	if (user_filter != "") filter += " AND " + user_filter;
	show_sounds(filter);	
}


void TWindow1::on_play_clicked() {  
	if (Gtk::TreeModel::iterator iter = treeview1->get_selection()->get_selected()) {
  		Gtk::TreeModel::Row row = *iter;
		statusbar1->push("Playing " + row[ListView.filename]);
		std::string path(row[ListView.path] + row[ListView.filename]);
		gst->play_url(path.c_str());
	}
}


void TWindow1::on_about1_activate() {  
}

void TWindow1::on_quitter1_activate() {  
	Gtk::Main::quit();
}


void launch_browser(Gtk::AboutDialog& dialog, const Glib::ustring& url) {
	std::string command ("xdg-open '");
	command += url;
	command += "'";
	system(command.c_str());
}

void TWindow1::on_about() {  
	Gtk::AboutDialog about;
	about.set_name( "SWAC Explore" );
	about.set_version( VERSION );
	about.set_logo(Gtk::Widget::render_icon(Gtk::StockID(Gtk::Stock::ABOUT), Gtk::IconSize(2)));
	about.set_website_label("Shtooka Project Home Page");
	about.set_url_hook(&launch_browser);
	about.set_website("http://shtooka.net/");
	about.set_license(
"This program is free software; you can redistribute it and/or modify\n\
it under the terms of the GNU General Public License as published by\n\
the Free Software Foundation; either version 2 of the License, or\n\
(at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA"
);
	
	//std::list<Glib::ustring> list_authors;
	//list_authors.push_back("Vion Nicolas");
	//about.set_authors(list_authors);
	about.set_copyright("Vion Nicolas");
	about.set_comments("Audio Collection of Words (SWAC) Explorer");
	about.run();
}


