/*--------------------------------------------------------------*
 *                                                              *
 *           = array  - Suffix Array Υƥȸ =       *
 *                                                              *
 *  array-show.c - show ޥɥϥɥ                        *
 *                 ߤϰϤ                         *
 *                                                              *
 *--------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "sufary.h"
#include "array.h"

#include <assert.h>

#define MAX_SHOW_BUFFER_SIZE 400000
static char buffer[MAX_SHOW_BUFFER_SIZE]; /* ѥХåե */

static void show_sort(long show_from, long show_to);
static void output(long);
static void output_kwic(long);
static void output_simple(long);
static int long_cmp(const void *, const void *);

SUFARY *cur_ary;

/**********************************************
 *            eresult com_show(char *cmd);
 *
 * purpose
 *   ̤ɽ
 *
 * parameters
 *   cmd : 
 *
 * return value
 *   ץ³⡼
 *
 * description
 *   ߤΥȥ⡼ɤ˽äʬ
 **********************************************/
eresult com_show(char *cmd)
{
  int i;
  char *s, *t;
  long show_from, show_to;

  s = strtok(cmd, ct); /* 1ܤΰ */
  if (s == NULL) show_from = -1;
  else show_from = atol(s);
  t = strtok(NULL, ct); /* 2ܤΰ */
  if (t == NULL) show_to = -1;
  else show_to = atol(t);

  if (arrays == 0){
    printf ("specify target files first.\n");
    return CONT;
  }

  for (i = 0; i < arrays; i++){
    cur_ary = sufary[i];
    show_sort(show_from, show_to);
  }

  return CONT;
}


/**********************************************
 *          void output(long idx);
 *
 * purpose
 *   ǥ 1 Ǥ򤤤ʥեޥåȤǽ
 *
 * parameters
 *   idx : ǥ
 *
 **********************************************/
static void output(long idx)
{
  char *s;
  switch (display_mode){
  case DISP_KWIC:    output_kwic(idx);      break;
  case DISP_INDEX:
    printf("%s:%ld\n", keyword,idx);
    break;
  case DISP_LINE:
    s = sa_getline(cur_ary,idx);
    printf("%s\n",s);
    free(s);
    break;
  case DISP_SIMPLE:
  default:           output_simple(idx);    break;
  }
}


/**********************************************
 * int long_cmp(const void *data1, const void *data2);
 *
 * purpose
 *   ʸ
 *
 * parameters
 *   data1 : ʸ1
 *   data2 : ʸ2
 *
 * return value
 *   -1 ʲ : *data1 < *data2
 *    0      : *data1 == *data2
 *    1 ʾ : *data1 > *data2
 *
 * description
 *   sort ѤӥХåؿ
 **********************************************/
static int long_cmp(const void *data1, const void *data2)
{
  long *l1, *l2;
  long ret;

  l1 = (long*) data1;
  l2 = (long*) data2;
  ret = *l1 - *l2;
  return (ret>0)? 1: (ret<0)? -1: 0;
}


/**********************************************
 *      int suffix_compare(long *a, long *b)
 *
 * purpose
 *   ƥȤ򥳡ɽ˥
 *
 * parameters
 *   ƥΥǥ
 *
 * return value
 *   strcmpƱ
 *
 * description
 *   show_sortqsortƤФ롣
 *   (near 黻νϤǥեȤindexˤʤ뤿)
 **********************************************/
static int suffix_compare(long *a, long *b)
{
  return strcmp(cur_ary->txtmap + *a, cur_ary->txtmap + *b);
}


/**********************************************
 *      void show_sort(long show_from, long show_to)
 *
 * purpose
 *   ɽ礫ǥå˥Ȥ줿
 *
 * parameters
 *   showޥɤǻꤷɽϰ
 *
 * description
 *   show() ƤФ롣̤Ф output() Ƥ
 **********************************************/
static void show_sort(long show_from, long show_to)
{
  unsigned char *mapptr;
  static long now;
  long l, bottom, top, tmp, from, to, size;
  long *buf;

  bottom = sa_bottom(cur_ary);
  top    = sa_top(cur_ary);
  size = top - bottom + 1; /* 980327 for NEW sa_sel */

  if(show_from == -1) show_from = 1; /* show άν */
  if(show_to == -1) show_to = size; /* show άν */
  printf("from %ld to %ld (%ld)\n", show_from, show_to, size);

  from = bottom + show_from - 1; to = bottom + show_to;

  /* nearѤǥǥåˤʤäƤꤷʤ */
  if (cur_ary->arymap == cur_ary->aryorig){
    /*** ̤θ ***/
    if(sort_mode == 1){ /* 祽 */
      for (tmp = from; tmp < to ; tmp++){
	l = sa_arraytotext(cur_ary, tmp);
	output(l);
      }
    }else{ /* ǥå祽  󥽡ȤƤޤΤԷк */
      buf = (long *)malloc(size * sizeof(long));
      for (tmp = 0; tmp < size ; tmp++)
	buf[tmp] = sa_arraytotext(cur_ary, tmp + bottom);
      qsort(buf, size, sizeof(long), (int(*)(const void*,const void*))(long_cmp)); 
      for (tmp = from; tmp < to; tmp++)	output(buf[tmp-(bottom)]);
      free(buf);
    }
  } else {
    /*** near ***/
    if(sort_mode == 1){ /* 祽  󥽡ȤƤޤΤԷк */
      buf = (long *)malloc(size * sizeof(long));
      for (tmp = 0; tmp < size ; tmp++)
	buf[tmp] = sa_arraytotext(cur_ary, tmp);
      qsort(buf, size, sizeof(long), (int(*)(const void*,const void*))(suffix_compare));
      for (tmp = from; tmp < to; tmp++)	output(buf[tmp-bottom]);
      free(buf);
    }else{ /* ǥå祽 */
      for (tmp = from; tmp < to ; tmp++){
	l = sa_arraytotext(cur_ary,tmp);
	output(l);
      }
    }
  }
}


/**********************************************
 * void output_simple(long idx);
 *
 * purpose
 *   index Ȥ60ʸ
 *
 * parameters
 *   idx : ǥ
 *
 **********************************************/
static void output_simple(long idx)
{
  strncpy(buffer,cur_ary->txtmap+idx,60);
  if(mojibake_proc_flag){ /* ʸɻ߽ */
    sa_mojibakebousi(buffer);
    sa_ctrl_code_tubusi(buffer);
  }
  printf("%ld : %s\n", idx, buffer);
}


/****************************************************
 * output_kwic: ̤ Key Word in Context ɽ
 * 
 * parameters
 *   idx --- ɤؤΥǥå
 *  970126
 *  ޤǤKWIC˥Ĺ(Ⱦʬ)ޤƤϤᡣ
 *****************************************************/
static void output_kwic(long idx)
{
  long kwic_from,kwic_to;
  char *pos;
  char kwicpre[1500],kwicpost[1500];
  long kwlen = strlen(keyword); /* ɤʸĹ */

  if (cur_ary->arymap != cur_ary->aryorig) kwlen = 0; /* nearΤȤ */

  /* ɤʬФ */
/*  kwic_from = idx - kwic_width + kwlen/2;*/
  kwic_from = idx - kwic_width;
  if(kwic_from < 0) kwic_from = 0;

  strncpy(kwicpre,cur_ary->txtmap+kwic_from,idx-kwic_from);
  kwicpre[idx-kwic_from] = '\0';

  /* ɤʬФ */  
  kwic_to = idx + kwic_width + kwlen;
  if(kwic_to > (long)cur_ary->txtsz) kwic_to = (long)cur_ary->txtsz;

  strncpy(kwicpost,cur_ary->txtmap+idx+kwlen,kwic_to-idx);  
  kwicpost[kwic_to-(idx+kwlen)] = '\0';

  if (cur_ary->arymap == cur_ary->aryorig){
    /*** ̤θ ***/
    /* Ĥ */
    sprintf(buffer,"%s<SUFARYKEY>%s</SUFARYKEY>%s",kwicpre,keyword,kwicpost);
  }else{
    /*** near ***/

    sprintf(buffer,"%s<SUFARYKEY>%s",kwicpre,kwicpost);
/*    kwic_from = idx - kwic_width;
    if(kwic_width % 2 == 1) kwic_from++;
    if(kwic_from < 0) kwic_from = 0;
    kwic_to = idx + kwic_width;
    if(kwic_to > (long)cur_ary->txtsz) kwic_to = (long)cur_ary->txtsz;

    strncpy(buffer, cur_ary->txtmap+kwic_from, kwic_to-kwic_from);

    buffer[kwic_to-kwic_from] = '\0';
*/
  }
  
  if(mojibake_proc_flag){ /* ʸɻ߽ */
    sa_mojibakebousi(buffer);
    sa_ctrl_code_tubusi(buffer);
  }

  printf("%s\t%ld\n",buffer,idx); /*  */
}


/**********************************************
 * com_line(char *cmd);
 **********************************************/
eresult com_line(char *cmd){
  long pos;
  char *s;

  pos = atol(cmd);
  s = sa_getline(sufary[0],pos);
  printf("%s\n",s);
/*  if(s[strlen(s)-1] != '\n') printf("\n");*/
  free(s);
  return CONT;
}


/**********************************************
 * com_get(char *cmd);
 **********************************************/
eresult com_get(char *cmd)
{
  long pos;
  char *s,d1[100],d2[100];

  if(sscanf(cmd,"%ld %s %s",&pos,d1,d2) < 3) return ERROR;
  s = sa_getblock(sufary[0],pos,d1,d2);
  printf("%s",s);
  if(s[strlen(s)-1] != '\n') printf("\n");
  free(s);
  return CONT;
}


/**********************************************
 * com_get_str(char *cmd);
 **********************************************/
eresult com_get_str(char *cmd)
{
  long idx;
  int num;
  char buf[1000];
  if(sscanf(cmd,"%ld %d",&idx,&num) < 2) return ERROR;
  strncpy(buf,(sufary[0]->txtmap+idx),num);
  buf[num] = '\0';
  printf("%s\n",buf);
  return CONT;
}
