 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_FIND_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_FIND_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AbndmAlgo

struct AbndmAlgo;       	// "projects/library/seqan/find/find_abndm.h"(77)

//____________________________________________________________________________
// AlignTextBanded

struct AlignTextBanded;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(56)

//____________________________________________________________________________
// BFAM

template <typename TSpec > struct BFAM;       	// "projects/library/seqan/find/find_bom.h"(71)

//____________________________________________________________________________
// DPSearch

template <typename TScore, typename TSpec , typename TFindBeginPatternSpec > struct DPSearch;       	// "projects/library/seqan/find/find_score.h"(33)
template <typename TScore, typename TSpec, typename TFindBeginPatternSpec> struct DPSearch;       	// "projects/library/seqan/find/find_begin.h"(35)

//____________________________________________________________________________
// DefaultFindBeginPatternSpec

template <typename TScore > struct DefaultFindBeginPatternSpec;       	// "projects/library/seqan/find/find_begin.h"(46)

//____________________________________________________________________________
// DefaultFinder

template <typename TObject > struct DefaultFinder;       	// "projects/library/seqan/find/find_base.h"(47)

//____________________________________________________________________________
// DefaultPattern

template <typename TObject > struct DefaultPattern;       	// "projects/library/seqan/find/find_base.h"(61)

//____________________________________________________________________________
// FileReader

template <typename TFormat, typename TFile, typename TSpec> struct FileReader;       	// "projects/library/seqan/find/find_horspool.h"(292)

//____________________________________________________________________________
// FindBeginPattern

template <typename TPattern> struct FindBeginPattern;       	// "projects/library/seqan/find/find_begin.h"(70)

//____________________________________________________________________________
// FindBeginPatternSpec

template <typename TPattern> struct FindBeginPatternSpec;       	// "projects/library/seqan/find/find_begin.h"(61)

//____________________________________________________________________________
// FindInfix

struct FindInfix;       	// "projects/library/seqan/find/find_base.h"(32)

//____________________________________________________________________________
// FindPrefix

struct FindPrefix;       	// "projects/library/seqan/find/find_base.h"(33)

//____________________________________________________________________________
// Finder

template <typename THaystack, typename TSpec > class Finder;       	// "projects/library/seqan/find/find_base.h"(155)

//____________________________________________________________________________
// Haystack

template <typename TFinder> struct Haystack;       	// "projects/library/seqan/find/find_base.h"(77)

//____________________________________________________________________________
// Hierarchical

struct Hierarchical;       	// "projects/library/seqan/find/find_pex.h"(30)

//____________________________________________________________________________
// Index

template <typename TObject, typename TSpec > class Index;       	// "projects/library/seqan/find/find_swift.h"(34)

//____________________________________________________________________________
// MultiBFAM

template <typename TSpec > struct MultiBFAM;       	// "projects/library/seqan/find/find_multiple_bfam.h"(59)

//____________________________________________________________________________
// Myers

template <typename TSpec , typename TFindBeginPatternSpec > struct Myers;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(53)

//____________________________________________________________________________
// Needle

template <typename TPattern> struct Needle;       	// "projects/library/seqan/find/find_base.h"(93)

//____________________________________________________________________________
// NonHierarchical

struct NonHierarchical;       	// "projects/library/seqan/find/find_pex.h"(31)

//____________________________________________________________________________
// Oracle

struct Oracle;       	// "projects/library/seqan/find/find_bom.h"(67)

//____________________________________________________________________________
// Pattern

template <typename TNeedle, typename TSpec > class Pattern;       	// "projects/library/seqan/find/find_pattern_base.h"(46)

//____________________________________________________________________________
// Pex

template <typename TVerification, typename TMultiFinder > struct Pex;       	// "projects/library/seqan/find/find_pex.h"(35)

//____________________________________________________________________________
// PexMultiFinder

template <typename T> struct PexMultiFinder;       	// "projects/library/seqan/find/find_pex.h"(62)

//____________________________________________________________________________
// Pipe

template <typename TInput, typename TSpec > struct Pipe;       	// "projects/library/seqan/find/find_swift.h"(243)

//____________________________________________________________________________
// ScoringScheme

template <typename TNeedle> struct ScoringScheme;       	// "projects/library/seqan/find/find_pattern_base.h"(130)

//____________________________________________________________________________
// Swift

template <typename TSpec > struct Swift;       	// "projects/library/seqan/find/find_swift.h"(47)

//____________________________________________________________________________
// SwiftParameters

struct SwiftParameters;       	// "projects/library/seqan/find/find_swift.h"(73)

//____________________________________________________________________________
// Trie

struct Trie;       	// "projects/library/seqan/find/find_bom.h"(68)

//____________________________________________________________________________
// _AhoCorasick

struct _AhoCorasick;       	// "projects/library/seqan/find/find_ahocorasick.h"(46)

//____________________________________________________________________________
// _BndmAlgo

struct _BndmAlgo;       	// "projects/library/seqan/find/find_bndm.h"(44)

//____________________________________________________________________________
// _FindBegin

template <typename TPattern, typename TFindBeginPatternSpec > struct _FindBegin;       	// "projects/library/seqan/find/find_begin.h"(82)

//____________________________________________________________________________
// _FindBegin_Impl

template <typename TFindBeginPatternSpec> struct _FindBegin_Impl;       	// "projects/library/seqan/find/find_begin.h"(102)

//____________________________________________________________________________
// _HammingHorspool

struct _HammingHorspool;       	// "projects/library/seqan/find/find_hamming_horspool.h"(45)

//____________________________________________________________________________
// _Horspool

struct _Horspool;       	// "projects/library/seqan/find/find_horspool.h"(43)

//____________________________________________________________________________
// _MultipatternFinder

struct _MultipatternFinder;       	// "projects/library/seqan/find/find_multi.h"(29)

//____________________________________________________________________________
// _MultipleShiftAnd

struct _MultipleShiftAnd;       	// "projects/library/seqan/find/find_multiple_shiftand.h"(44)

//____________________________________________________________________________
// _MyersLargePattern

struct _MyersLargePattern;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(107)

//____________________________________________________________________________
// _MyersUkkonenHP0

template <typename T> struct _MyersUkkonenHP0;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(71)

//____________________________________________________________________________
// _PexRange

template <typename TPosition,typename TScore,typename TVerifier,typename TNeedle> struct _PexRange;       	// "projects/library/seqan/find/find_pex.h"(73)

//____________________________________________________________________________
// _Quasar

struct _Quasar;       	// "projects/library/seqan/find/find_quasar.h"(33)

//____________________________________________________________________________
// _SetHorspool

struct _SetHorspool;       	// "projects/library/seqan/find/find_set_horspool.h"(44)

//____________________________________________________________________________
// _ShiftAnd

struct _ShiftAnd;       	// "projects/library/seqan/find/find_shiftand.h"(44)

//____________________________________________________________________________
// _ShiftOr

struct _ShiftOr;       	// "projects/library/seqan/find/find_shiftor.h"(44)

//____________________________________________________________________________
// _SwiftBucket

template <typename TSpec, typename _TSize, typename _TShortSize > struct _SwiftBucket;       	// "projects/library/seqan/find/find_swift.h"(88)

//____________________________________________________________________________
// _SwiftBucketParams

template <typename TSpec, typename _TSize, typename _TShortSize > struct _SwiftBucketParams;       	// "projects/library/seqan/find/find_swift.h"(117)

//____________________________________________________________________________
// _SwiftHit

template <typename THstkPos> struct _SwiftHit;       	// "projects/library/seqan/find/find_swift.h"(136)

//____________________________________________________________________________
// _SwiftLocal

struct _SwiftLocal;       	// "projects/library/seqan/find/find_swift.h"(36)

//____________________________________________________________________________
// _SwiftSemiGlobal

struct _SwiftSemiGlobal;       	// "projects/library/seqan/find/find_swift.h"(39)

//____________________________________________________________________________
// _SwiftSemiGlobalHamming

struct _SwiftSemiGlobalHamming;       	// "projects/library/seqan/find/find_swift.h"(42)

//____________________________________________________________________________
// _WildShiftAnd

struct _WildShiftAnd;       	// "projects/library/seqan/find/find_wild_shiftand.h"(51)

//____________________________________________________________________________
// _WuManber

struct _WuManber;       	// "projects/library/seqan/find/find_wumanber.h"(43)

//____________________________________________________________________________
// _WuManber_Hash

template <typename TNeedle, int Q> struct _WuManber_Hash;       	// "projects/library/seqan/find/find_wumanber.h"(102)

//____________________________________________________________________________
// _WuManber_Imp

template <typename TNeedle, int Q> struct _WuManber_Imp;       	// "projects/library/seqan/find/find_wumanber.h"(110)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AhoCorasick

typedef Tag<_AhoCorasick> AhoCorasick;       	// "projects/library/seqan/find/find_ahocorasick.h"(47)

//____________________________________________________________________________
// BndmAlgo

typedef Tag<_BndmAlgo> BndmAlgo;       	// "projects/library/seqan/find/find_bndm.h"(45)

//____________________________________________________________________________
// BomAlgo

typedef BFAM<Oracle> BomAlgo;       	// "projects/library/seqan/find/find_bom.h"(73)

//____________________________________________________________________________
// HammingHorspool

typedef Tag<_HammingHorspool> HammingHorspool;       	// "projects/library/seqan/find/find_hamming_horspool.h"(46)

//____________________________________________________________________________
// Horspool

typedef Tag<_Horspool> Horspool;       	// "projects/library/seqan/find/find_horspool.h"(44)

//____________________________________________________________________________
// MultipatternFinder

typedef Tag<_MultipatternFinder> MultipatternFinder;       	// "projects/library/seqan/find/find_multi.h"(30)

//____________________________________________________________________________
// MultipleShiftAnd

typedef Tag<_MultipleShiftAnd> MultipleShiftAnd;       	// "projects/library/seqan/find/find_multiple_shiftand.h"(45)

//____________________________________________________________________________
// MyersUkkonen

typedef Myers<FindInfix, void> MyersUkkonen;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(59)

//____________________________________________________________________________
// MyersUkkonenBanded

typedef Myers<AlignTextBanded, void> MyersUkkonenBanded;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(61)

//____________________________________________________________________________
// MyersUkkonenGlobal

typedef Myers<FindPrefix, void> MyersUkkonenGlobal;       	// "projects/library/seqan/find/find_myers_ukkonen.h"(60)

//____________________________________________________________________________
// PexHierarchical

typedef Pex<Hierarchical,AhoCorasick>   PexHierarchical;       	// "projects/library/seqan/find/find_pex.h"(37)

//____________________________________________________________________________
// PexNonHierarchical

typedef Pex<NonHierarchical,AhoCorasick>  PexNonHierarchical;       	// "projects/library/seqan/find/find_pex.h"(38)

//____________________________________________________________________________
// Quasar

typedef Tag<_Quasar> Quasar;       	// "projects/library/seqan/find/find_quasar.h"(34)

//____________________________________________________________________________
// SBomAlgo

typedef MultiBFAM<Oracle> SBomAlgo;       	// "projects/library/seqan/find/find_multiple_bfam.h"(61)

//____________________________________________________________________________
// SetHorspool

typedef Tag<_SetHorspool> SetHorspool;       	// "projects/library/seqan/find/find_set_horspool.h"(45)

//____________________________________________________________________________
// ShiftAnd

typedef Tag<_ShiftAnd> ShiftAnd;       	// "projects/library/seqan/find/find_shiftand.h"(45)

//____________________________________________________________________________
// ShiftOr

typedef Tag<_ShiftOr> ShiftOr;       	// "projects/library/seqan/find/find_shiftor.h"(45)

//____________________________________________________________________________
// SwiftLocal

typedef Tag<_SwiftLocal> SwiftLocal;       	// "projects/library/seqan/find/find_swift.h"(37)

//____________________________________________________________________________
// SwiftSemiGlobal

typedef Tag<_SwiftSemiGlobal> SwiftSemiGlobal;       	// "projects/library/seqan/find/find_swift.h"(40)

//____________________________________________________________________________
// SwiftSemiGlobalHamming

typedef Tag<_SwiftSemiGlobalHamming> SwiftSemiGlobalHamming;       	// "projects/library/seqan/find/find_swift.h"(43)

//____________________________________________________________________________
// WildShiftAnd

typedef Tag<_WildShiftAnd> WildShiftAnd;       	// "projects/library/seqan/find/find_wild_shiftand.h"(52)

//____________________________________________________________________________
// WuManber

typedef Tag<_WuManber> WuManber;       	// "projects/library/seqan/find/find_wumanber.h"(44)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _buildAutomaton_MultiBFAM

template <typename TNeedle, typename TStrs> inline void _buildAutomaton_MultiBFAM(Pattern<TNeedle, MultiBFAM<Oracle> > & me, TStrs const & strs);       	// "projects/library/seqan/find/find_multiple_bfam.h"(121)
template <typename TNeedle, typename TStrs> inline void _buildAutomaton_MultiBFAM(Pattern<TNeedle, MultiBFAM<Trie> > & me, TStrs const & strs);       	// "projects/library/seqan/find/find_multiple_bfam.h"(129)

//____________________________________________________________________________
// _createAcTrie

template <typename TNeedle> inline void _createAcTrie(Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(120)

//____________________________________________________________________________
// _createTree

template <typename TNeedle, typename TMultiFinder> void _createTree(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &me, unsigned start, unsigned end, unsigned k, unsigned parent, unsigned direction, unsigned idx, unsigned plen);       	// "projects/library/seqan/find/find_pex.h"(516)

//____________________________________________________________________________
// _dataHost

template <typename TNeedle, typename TSpec> inline Holder<TNeedle> & _dataHost(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_pattern_base.h"(144)
template <typename TNeedle, typename TSpec> inline Holder<TNeedle> & _dataHost(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_pattern_base.h"(150)

//____________________________________________________________________________
// _findAbndm_LargeNeedle

template <typename TFinder, typename TNeedle> inline bool _findAbndm_LargeNeedle(TFinder & finder, Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(385)

//____________________________________________________________________________
// _findAbndm_SmallNeedle

template <typename TFinder, typename TNeedle> inline bool _findAbndm_SmallNeedle(TFinder & finder, Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(251)

//____________________________________________________________________________
// _findBeginInit

template <typename TPattern> inline void _findBeginInit(TPattern & pattern);       	// "projects/library/seqan/find/find_begin.h"(224)

//____________________________________________________________________________
// _findBndm_LargeNeedle

template <typename TFinder, typename TNeedle> inline bool _findBndm_LargeNeedle(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(175)

//____________________________________________________________________________
// _findBndm_SmallNeedle

template <typename TFinder, typename TNeedle> inline bool _findBndm_SmallNeedle(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(144)

//____________________________________________________________________________
// _findMyersLargePatterns

template <typename TFinder, typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TSize> inline bool _findMyersLargePatterns (TFinder & finder, Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, TSize haystack_length);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(614)
template <typename TFinder, typename TNeedle, typename TFindBeginPatternSpec, typename TSize> inline bool _findMyersLargePatterns( TFinder & finder, Pattern<TNeedle, Myers<AlignTextBanded, TFindBeginPatternSpec> > & me, TSize);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(787)

//____________________________________________________________________________
// _findMyersSmallPatterns

template <typename TFinder, typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TSize> inline bool _findMyersSmallPatterns (TFinder & finder, Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, TSize haystack_length);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(724)
template <typename TFinder, typename TNeedle, typename TFindBeginPatternSpec, typename TSize> inline bool _findMyersSmallPatterns( TFinder & finder, Pattern<TNeedle, Myers<AlignTextBanded, TFindBeginPatternSpec> > & me, TSize);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(1058)

//____________________________________________________________________________
// _findShiftAnd_LargeNeedle

template <typename TFinder, typename TNeedle> bool _findShiftAnd_LargeNeedle(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(315)
template <typename TFinder, typename TNeedle> inline bool _findShiftAnd_LargeNeedle(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(610)
template <typename TFinder, typename TNeedle> inline bool _findShiftAnd_LargeNeedle(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(164)

//____________________________________________________________________________
// _findShiftAnd_SmallNeedle

template <typename TFinder, typename TNeedle> bool _findShiftAnd_SmallNeedle(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(261)
template <typename TFinder, typename TNeedle> inline bool _findShiftAnd_SmallNeedle(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(587)
template <typename TFinder, typename TNeedle> inline bool _findShiftAnd_SmallNeedle(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(142)

//____________________________________________________________________________
// _findShiftOr_LargeNeedle

template <typename TFinder, typename TNeedle> bool _findShiftOr_LargeNeedle(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(194)

//____________________________________________________________________________
// _findShiftOr_SmallNeedle

template <typename TFinder, typename TNeedle> bool _findShiftOr_SmallNeedle(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(159)

//____________________________________________________________________________
// _find_score_simple_proportional

template <typename TFinder, typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> bool _find_score_simple_proportional(TFinder & finder, Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_score.h"(360)

//____________________________________________________________________________
// _finderInit

template <typename TNeedle> inline void _finderInit (Pattern<TNeedle, HammingHorspool> & me);       	// "projects/library/seqan/find/find_hamming_horspool.h"(140)

//____________________________________________________________________________
// _finderSetNonEmpty

template <typename T> inline void _finderSetNonEmpty(T & me);       	// "projects/library/seqan/find/find_base.h"(502)
template <typename THaystack, typename TSpec> inline void _finderSetNonEmpty(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(511)

//____________________________________________________________________________
// _firstNonRepeatRange

template <typename THaystack, typename TNeedle, typename TIndexSpec, typename TSpec> inline bool _firstNonRepeatRange( Finder<THaystack, Swift<TSpec> > &finder, Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > &pattern, bool printDots);       	// "projects/library/seqan/find/find_swift.h"(945)

//____________________________________________________________________________
// _getCharacterClass

template <typename TValue,typename TNeedle2> String <unsigned> _getCharacterClass(TNeedle2 const & host,unsigned start,unsigned end);       	// "projects/library/seqan/find/find_wild_shiftand.h"(281)

//____________________________________________________________________________
// _getRoot

template <typename TNeedle, typename TMultiFinder> int _getRoot(Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(220)
template <typename TNeedle, typename TMultiFinder> int _getRoot(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &);       	// "projects/library/seqan/find/find_pex.h"(227)

//____________________________________________________________________________
// _isInt

inline bool _isInt(String<char> const & number);       	// "projects/library/seqan/find/find_wild_shiftand.h"(119)

//____________________________________________________________________________
// _length_wo_wild

template <typename TNeedle> unsigned _length_wo_wild(TNeedle const & needle);       	// "projects/library/seqan/find/find_wild_shiftand.h"(209)

//____________________________________________________________________________
// _myersCoreSmall

template <typename TWord, typename TAlignSpec, typename TFindBeginPatternSpec> inline int _myersCoreSmall(TWord &VP, TWord &VN, TWord const &bitmap, int scoreBit, Myers<TAlignSpec, TFindBeginPatternSpec> );       	// "projects/library/seqan/find/find_myers_ukkonen.h"(1025)

//____________________________________________________________________________
// _myersCoreSmallDiag

template <typename TWord, typename TAlignSpec, typename TFindBeginPatternSpec> inline int _myersCoreSmallDiag(TWord &VP, TWord &VN, TWord const &bitmap, int scoreBit, Myers<TAlignSpec, TFindBeginPatternSpec> );       	// "projects/library/seqan/find/find_myers_ukkonen.h"(1040)

//____________________________________________________________________________
// _myersSetHost

template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> void _myersSetHost(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, TNeedle2 const & ndl, True);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(396)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> void _myersSetHost(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > &, TNeedle2 const &, False);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(403)

//____________________________________________________________________________
// _nextNonRepeatRange

template <typename THaystack, typename TNeedle, typename TIndexSpec, typename TSpec> inline bool _nextNonRepeatRange( Finder<THaystack, Swift<TSpec> > &finder, Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > &pattern, bool );       	// "projects/library/seqan/find/find_swift.h"(908)

//____________________________________________________________________________
// _patternFirstInit

template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> inline void _patternFirstInit(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(288)
template <typename TNeedle, typename TFindBeginPatternSpec, typename TNeedle2> inline void _patternFirstInit(Pattern<TNeedle, Myers<AlignTextBanded, TFindBeginPatternSpec> > & me, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(328)

//____________________________________________________________________________
// _patternInit

template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, Quasar> & me);       	// "projects/library/seqan/find/find_quasar.h"(109)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(218)
template <typename TIndex, typename TFloat, typename _TSize, typename TSpec> inline void _patternInit(Pattern<TIndex, Swift<TSpec> > &pattern, TFloat errorRate, _TSize minLengthForAll);       	// "projects/library/seqan/find/find_swift.h"(430)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, Horspool> &);       	// "projects/library/seqan/find/find_horspool.h"(125)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(209)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline void _patternInit (Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_score.h"(295)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, SetHorspool> & me);       	// "projects/library/seqan/find/find_set_horspool.h"(175)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(538)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(130)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(129)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, WuManber> & me);       	// "projects/library/seqan/find/find_wumanber.h"(443)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(131)
template <typename TNeedle, typename TFinder, typename TMultiFinder> void _patternInit(Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > &me, TFinder &);       	// "projects/library/seqan/find/find_pex.h"(273)
template <typename TNeedle, typename TFinder, typename TMultiFinder> void _patternInit(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &me, TFinder &);       	// "projects/library/seqan/find/find_pex.h"(554)
template <typename TNeedle, typename TSpec> inline void _patternInit (Pattern<TNeedle, BFAM<TSpec> > & me);       	// "projects/library/seqan/find/find_bom.h"(175)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(225)
template <typename TNeedle, typename TAutomaton> inline void _patternInit (Pattern<TNeedle, MultiBFAM<TAutomaton> > & me);       	// "projects/library/seqan/find/find_multiple_bfam.h"(229)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TFinder> void _patternInit(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > &me, TFinder &);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(532)
template <typename TNeedle, typename TFinder, typename TFindBeginPatternSpec> void _patternInit(Pattern<TNeedle, Myers<AlignTextBanded, TFindBeginPatternSpec> > &me, TFinder &finder);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(562)

//____________________________________________________________________________
// _patternMatchNOfFinder

template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline void _patternMatchNOfFinder(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, bool match);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(373)

//____________________________________________________________________________
// _patternMatchNOfPattern

template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline void _patternMatchNOfPattern(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, bool match);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(339)

//____________________________________________________________________________
// _printMask

inline void _printMask(String <unsigned> const & mask,String <char> name);       	// "projects/library/seqan/find/find_abndm.h"(33)
inline void _printMask(String <unsigned> const & mask,unsigned start, unsigned len,String <char> name);       	// "projects/library/seqan/find/find_abndm.h"(46)

//____________________________________________________________________________
// _printR

template <typename TNeedle> void _printR(Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(140)

//____________________________________________________________________________
// _printSwiftBuckets

template <typename TNeedle, typename TIndexSpec, typename TSpec > inline void _printSwiftBuckets(Pattern< Index<TNeedle, TIndexSpec>, Swift<TSpec> > &p);       	// "projects/library/seqan/find/find_swift.h"(355)

//____________________________________________________________________________
// _printSwiftParams

template <typename TParams> inline void _printSwiftParams(TParams &bucketParams);       	// "projects/library/seqan/find/find_swift.h"(343)

//____________________________________________________________________________
// _qgramLemma

template <typename TIndex, typename TSpec, typename TSeqNo> inline int _qgramLemma(Pattern<TIndex, Swift<TSpec> > const & pattern, TSeqNo seqNo, int errors);       	// "projects/library/seqan/find/find_swift.h"(401)

//____________________________________________________________________________
// _setFinderEnd

template <typename THaystack, typename TSpec> inline void _setFinderEnd(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(254)
template <typename THaystack, typename TSpec, typename TPosition> inline void _setFinderEnd(Finder<THaystack, TSpec> & me, TPosition end_pos);       	// "projects/library/seqan/find/find_base.h"(262)

//____________________________________________________________________________
// _setFinderLength

template <typename THaystack, typename TSpec, typename TSize> inline void _setFinderLength(Finder<THaystack, TSpec> & me, TSize _length);       	// "projects/library/seqan/find/find_base.h"(273)

//____________________________________________________________________________
// _setHost_MultiBFAM

template <typename TNeedle, typename TAutomaton, typename TNeedle2> void _setHost_MultiBFAM(Pattern<TNeedle, MultiBFAM<TAutomaton> > & me, TNeedle2 const & needle_);       	// "projects/library/seqan/find/find_multiple_bfam.h"(138)

//____________________________________________________________________________
// _setHost_WuManber

template <typename TNeedle, typename TNeedle2> void _setHost_WuManber(Pattern<TNeedle, WuManber> & me, TNeedle2 const & needle_);       	// "projects/library/seqan/find/find_wumanber.h"(337)

//____________________________________________________________________________
// _startVerify_MultiBFAM

template <typename TNeedle, typename TAutomaton, typename THaystackIterator> inline bool _startVerify_MultiBFAM(Pattern<TNeedle, MultiBFAM<TAutomaton> > &, THaystackIterator);       	// "projects/library/seqan/find/find_multiple_bfam.h"(244)
template <typename TNeedle, typename THaystackIterator> inline bool _startVerify_MultiBFAM(Pattern<TNeedle, MultiBFAM<Oracle> > & me, THaystackIterator tit);       	// "projects/library/seqan/find/find_multiple_bfam.h"(253)

//____________________________________________________________________________
// _swiftBucketNo

template <typename TIndex, typename TSpec, typename TParams, typename TSize> inline unsigned _swiftBucketNo(Pattern<TIndex, Swift<TSpec> > const &, TParams &bucketParams, TSize seqNo);       	// "projects/library/seqan/find/find_swift.h"(391)

//____________________________________________________________________________
// _swiftBucketParams

template <typename TIndex, typename TSpec, typename TSize> inline typename Pattern<TIndex, Swift<TSpec> >::TBucketParams & _swiftBucketParams(Pattern<TIndex, Swift<TSpec> > & pattern, TSize seqNo);       	// "projects/library/seqan/find/find_swift.h"(381)

//____________________________________________________________________________
// _swiftMultiFlushBuckets

template <typename TIndex, typename TSpec > inline void _swiftMultiFlushBuckets(Pattern<TIndex, Swift<TSpec> > &pattern);       	// "projects/library/seqan/find/find_swift.h"(729)

//____________________________________________________________________________
// _swiftMultiProcessQGram

template <typename THaystack, typename TIndex, typename TSpec, typename THValue > inline bool _swiftMultiProcessQGram( Finder<THaystack, Swift<TSpec> > &finder, Pattern<TIndex, Swift<TSpec> > &pattern, THValue hash);       	// "projects/library/seqan/find/find_swift.h"(604)

//____________________________________________________________________________
// _validate

template <typename TNeedle2> bool _validate(TNeedle2 const & needle);       	// "projects/library/seqan/find/find_wild_shiftand.h"(131)

//____________________________________________________________________________
// atBegin

template <typename THaystack, typename TSpec> inline bool atBegin(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(521)

//____________________________________________________________________________
// atEnd

template <typename THaystack, typename TSpec> inline bool atEnd(Finder<THaystack, Swift<TSpec> > & me);       	// "projects/library/seqan/find/find_swift.h"(282)
template <typename THaystack, typename TSpec> inline bool atEnd(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(529)

//____________________________________________________________________________
// begin

template <typename THaystack, typename TSpec, typename TTag> inline typename Iterator<THaystack, Tag<TTag> const>::Type begin(Finder<THaystack, TSpec> & me, Tag<TTag> const tag);       	// "projects/library/seqan/find/find_base.h"(303)
template <typename THaystack, typename TSpec, typename TTag> inline typename Iterator<THaystack const, Tag<TTag> const>::Type begin(Finder<THaystack, TSpec> const & me, Tag<TTag> const tag);       	// "projects/library/seqan/find/find_base.h"(312)

//____________________________________________________________________________
// beginPosition

template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> >::Type & beginPosition(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_pattern_base.h"(177)
template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> const >::Type & beginPosition(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_pattern_base.h"(183)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type beginPosition(Finder<THaystack, Swift<TSpec> > & finder);       	// "projects/library/seqan/find/find_swift.h"(796)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type beginPosition(Finder<THaystack, Swift<TSpec> > const & finder);       	// "projects/library/seqan/find/find_swift.h"(804)
template <typename THaystack, typename TSpec> inline typename Position<THaystack>::Type beginPosition(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(283)
template <typename THaystack, typename TSpec> inline typename Position<THaystack const>::Type beginPosition(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(291)

//____________________________________________________________________________
// clear

template <typename TNeedle, typename TIndexSpec, typename TSpec> inline void clear(Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > & me);       	// "projects/library/seqan/find/find_swift.h"(766)
template <typename THaystack, typename TSpec> inline void clear(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(492)

//____________________________________________________________________________
// container

template <typename THaystack, typename TSpec> inline typename _Parameter<THaystack>::Type container(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(426)
template <typename THaystack, typename TSpec> inline typename _Parameter<THaystack>::Type container(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(434)

//____________________________________________________________________________
// empty

template <typename TNeedle, typename TIndexSpec, typename TSpec> inline bool empty(Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > & me);       	// "projects/library/seqan/find/find_swift.h"(759)
template <typename THaystack, typename TSpec> inline bool empty(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(484)

//____________________________________________________________________________
// end

template <typename THaystack, typename TSpec, typename TTag> inline typename Iterator<THaystack, Tag<TTag> const>::Type end(Finder<THaystack, TSpec> & me, Tag<TTag> const tag);       	// "projects/library/seqan/find/find_base.h"(343)
template <typename THaystack, typename TSpec, typename TTag> inline typename Iterator<THaystack const, Tag<TTag> const>::Type end(Finder<THaystack, TSpec> const & me, Tag<TTag> const tag);       	// "projects/library/seqan/find/find_base.h"(352)

//____________________________________________________________________________
// endPosition

template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> >::Type & endPosition(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_pattern_base.h"(201)
template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> const >::Type & endPosition(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_pattern_base.h"(207)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type endPosition(Finder<THaystack, Swift<TSpec> > & finder);       	// "projects/library/seqan/find/find_swift.h"(814)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type endPosition(Finder<THaystack, Swift<TSpec> > const & finder);       	// "projects/library/seqan/find/find_swift.h"(822)
template <typename THaystack, typename TSpec> inline typename Position<THaystack>::Type endPosition(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(323)
template <typename THaystack, typename TSpec> inline typename Position<THaystack const>::Type endPosition(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(331)

//____________________________________________________________________________
// find

template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, Quasar> & me);       	// "projects/library/seqan/find/find_quasar.h"(138)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(390)
template <typename THaystack, typename TNeedle, typename TIndexSpec, typename TSpec> inline bool find( Finder<THaystack, Swift<TSpec> > &finder, Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > &pattern, double errorRate, bool printDots);       	// "projects/library/seqan/find/find_swift.h"(977)
template <typename THashes, typename TPipeSpec, typename TNeedle, typename TIndexSpec, typename TSpec> inline bool find( Finder<Pipe<THashes, TPipeSpec>, Swift<TSpec> > &finder, Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > &pattern, double errorRate, bool printDots);       	// "projects/library/seqan/find/find_swift.h"(1057)
template <typename TFinder, typename TNeedle2> bool find(TFinder & finder, Pattern<TNeedle2, Horspool> & me);       	// "projects/library/seqan/find/find_horspool.h"(435)
template <typename TFinder, typename TNeedle> inline bool find (TFinder & finder, Pattern<TNeedle, AbndmAlgo > & me);       	// "projects/library/seqan/find/find_abndm.h"(589)
template <typename TFinder, typename TNeedle> inline bool find (TFinder & finder, Pattern<TNeedle, AbndmAlgo > & me, int const k);       	// "projects/library/seqan/find/find_abndm.h"(615)
template <typename TFinder, typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline bool find(TFinder & finder, Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_score.h"(463)
template <typename TFinder, typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline bool find(TFinder & finder, Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, int const limit_);       	// "projects/library/seqan/find/find_score.h"(473)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, SetHorspool> & me);       	// "projects/library/seqan/find/find_set_horspool.h"(213)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(651)
template <typename TFinder, typename TNeedle> bool find(TFinder & finder, Pattern<TNeedle, HammingHorspool> & me);       	// "projects/library/seqan/find/find_hamming_horspool.h"(166)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "projects/library/seqan/find/find_shiftand.h"(203)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "projects/library/seqan/find/find_shiftor.h"(232)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, WuManber> & me);       	// "projects/library/seqan/find/find_wumanber.h"(454)
template <typename THaystack, typename THaystack2, typename TNeedle> inline bool find(Finder<THaystack, MultipatternFinder> & me, THaystack2 & hstk, TNeedle const & ndl);       	// "projects/library/seqan/find/find_multi.h"(129)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, Simple> & me);       	// "projects/library/seqan/find/find_simple.h"(103)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "projects/library/seqan/find/find_bndm.h"(225)
template <typename TFinder, typename TNeedle, typename TMultiFinder> inline bool find (TFinder & finder, Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(364)
template <typename TFinder, typename TNeedle, typename TMultiFinder> inline bool find (TFinder & finder, Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(597)
template <typename TFinder, typename TNeedle, typename TSpec> inline bool find(TFinder & finder, Pattern<TNeedle, BFAM<TSpec> > & me);       	// "projects/library/seqan/find/find_bom.h"(187)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(245)
template <typename TFinder, typename TAutomaton, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, MultiBFAM<TAutomaton> > & me);       	// "projects/library/seqan/find/find_multiple_bfam.h"(277)
template <typename TFinder, typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(1244)
template <typename TFinder, typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, int const k);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(1295)

//____________________________________________________________________________
// findBegin

template <typename TFinder, typename TPattern> inline bool findBegin(TFinder & finder, TPattern & pattern);       	// "projects/library/seqan/find/find_begin.h"(255)
template <typename TFinder, typename TPattern, typename TLimit> inline bool findBegin(TFinder & finder, TPattern & pattern, TLimit limit);       	// "projects/library/seqan/find/find_begin.h"(264)

//____________________________________________________________________________
// find_horspool

template <typename TFinder, typename TNeedle2> bool find_horspool(TFinder & finder, Pattern<TNeedle2, Horspool> & me, bool find_first);       	// "projects/library/seqan/find/find_horspool.h"(135)
template <typename TValue, typename TFormat, typename TFile, typename FileReaderTSpec, typename TFinderSpec, typename TNeedle2> bool find_horspool(Finder<String<TValue, FileReader<TFormat, TFile, FileReaderTSpec> >, TFinderSpec > & finder, Pattern<TNeedle2, Horspool> & me, bool find_first);       	// "projects/library/seqan/find/find_horspool.h"(299)

//____________________________________________________________________________
// getBeginScore

template <typename TPattern> inline typename Value<typename ScoringScheme<TPattern>::Type>::Type getBeginScore(TPattern & pattern);       	// "projects/library/seqan/find/find_begin.h"(287)

//____________________________________________________________________________
// getScore

template <typename TNeedle> int getScore(Pattern<TNeedle, AbndmAlgo > & me);       	// "projects/library/seqan/find/find_abndm.h"(242)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline typename Value<TScore>::Type getScore(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_score.h"(286)
template <typename TNeedle, typename TVerification, typename TMultiFinder> int getScore(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(237)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> int getScore(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(519)

//____________________________________________________________________________
// goBegin

template <typename THaystack, typename TSpec> inline void goBegin(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(539)

//____________________________________________________________________________
// goEnd

template <typename THaystack, typename TSpec> inline void goEnd(Finder<THaystack, Swift<TSpec> > & me);       	// "projects/library/seqan/find/find_swift.h"(289)
template <typename THaystack, typename TSpec> inline void goEnd(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(548)

//____________________________________________________________________________
// haystack

template <typename TObject > inline typename Haystack<TObject>::Type & haystack(TObject &obj);       	// "projects/library/seqan/find/find_base.h"(711)
template <typename TObject > inline typename Haystack<TObject const>::Type & haystack(TObject const &obj);       	// "projects/library/seqan/find/find_base.h"(717)

//____________________________________________________________________________
// host

template <typename TNeedle> inline typename Host<Pattern<TNeedle, Quasar>const>::Type & host(Pattern<TNeedle, Quasar> & me);       	// "projects/library/seqan/find/find_quasar.h"(119)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, Quasar>const>::Type & host(Pattern<TNeedle, Quasar> const & me);       	// "projects/library/seqan/find/find_quasar.h"(127)
template <typename TNeedle, typename TSpec> inline typename Host<Pattern<TNeedle, TSpec> >::Type & host(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_pattern_base.h"(243)
template <typename TNeedle, typename TSpec> inline typename Host<Pattern<TNeedle, TSpec> const>::Type & host(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_pattern_base.h"(251)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, MultipleShiftAnd>const>::Type & host(Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(236)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, MultipleShiftAnd>const>::Type & host(Pattern<TNeedle, MultipleShiftAnd> const & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(244)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, AbndmAlgo> >::Type & host(Pattern<TNeedle, AbndmAlgo> & me);       	// "projects/library/seqan/find/find_abndm.h"(223)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, AbndmAlgo> const>::Type & host(Pattern<TNeedle, AbndmAlgo> const & me);       	// "projects/library/seqan/find/find_abndm.h"(231)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline typename Host<Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > >::Type & host(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_score.h"(159)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline typename Host<Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > const>::Type & host(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > const & me);       	// "projects/library/seqan/find/find_score.h"(167)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, SetHorspool>const>::Type & host(Pattern<TNeedle, SetHorspool> & me);       	// "projects/library/seqan/find/find_set_horspool.h"(188)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, SetHorspool>const>::Type & host(Pattern<TNeedle, SetHorspool> const & me);       	// "projects/library/seqan/find/find_set_horspool.h"(196)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WildShiftAnd>const>::Type & host(Pattern<TNeedle, WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(570)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WildShiftAnd>const>::Type & host(Pattern<TNeedle, WildShiftAnd> const & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(578)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, HammingHorspool>const>::Type & host(Pattern<TNeedle, HammingHorspool> & me);       	// "projects/library/seqan/find/find_hamming_horspool.h"(148)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, HammingHorspool>const>::Type & host(Pattern<TNeedle, HammingHorspool> const & me);       	// "projects/library/seqan/find/find_hamming_horspool.h"(156)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WuManber> >::Type & host(Pattern<TNeedle, WuManber> & me);       	// "projects/library/seqan/find/find_wumanber.h"(416)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WuManber> const>::Type & host(Pattern<TNeedle, WuManber> const & me);       	// "projects/library/seqan/find/find_wumanber.h"(424)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline typename Host<Pattern<TNeedle, Pex<TVerification,TMultiFinder > > >::Type & host(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me);       	// "projects/library/seqan/find/find_pex.h"(203)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline typename Host<Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const>::Type & host(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const & me);       	// "projects/library/seqan/find/find_pex.h"(211)
template <typename TNeedle, typename TAutomaton> inline typename Host<Pattern<TNeedle, MultiBFAM<TAutomaton> > >::Type & host(Pattern<TNeedle, MultiBFAM<TAutomaton> > & me);       	// "projects/library/seqan/find/find_multiple_bfam.h"(202)
template <typename TNeedle, typename TAutomaton> inline typename Host<Pattern<TNeedle, MultiBFAM<TAutomaton> > const>::Type & host(Pattern<TNeedle, MultiBFAM<TAutomaton> > const & me);       	// "projects/library/seqan/find/find_multiple_bfam.h"(210)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline typename Host<Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > >::Type & host(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(475)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline typename Host<Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > const>::Type & host(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > const & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(483)
template <typename THaystack, typename TSpec> inline typename _Parameter<THaystack>::Type host(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(410)
template <typename THaystack, typename TSpec> inline typename _Parameter<THaystack>::Type host(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(418)

//____________________________________________________________________________
// hostIterator

template <typename THaystack, typename TSpec> inline typename Iterator<THaystack, Rooted>::Type & hostIterator(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(466)
template <typename THaystack, typename TSpec> inline typename Iterator<THaystack, Rooted>::Type const & hostIterator(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(474)

//____________________________________________________________________________
// infix

template <typename THaystack, typename TSpec> inline typename Infix<THaystack>::Type infix(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(390)
template <typename THaystack, typename TSpec> inline typename Infix<THaystack const>::Type infix(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(399)

//____________________________________________________________________________
// init

template <typename THaystack> inline void init(Finder<THaystack, MultipatternFinder> & me);       	// "projects/library/seqan/find/find_multi.h"(117)

//____________________________________________________________________________
// length

template <typename THaystack, typename TSpec> inline typename Size<THaystack>::Type length(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(363)
template <typename THaystack, typename TSpec> inline typename Size<THaystack const>::Type length(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(370)

//____________________________________________________________________________
// needle

template <typename TObject > inline typename Needle<TObject>::Type & needle(TObject &obj);       	// "projects/library/seqan/find/find_pattern_base.h"(273)
template <typename TObject > inline typename Needle<TObject const>::Type & needle(TObject const &obj);       	// "projects/library/seqan/find/find_pattern_base.h"(280)
template <typename TNeedle, typename TSpec > inline typename Needle< Pattern<TNeedle, TSpec> >::Type & needle(Pattern<TNeedle, TSpec> & obj);       	// "projects/library/seqan/find/find_pattern_base.h"(290)
template <typename TNeedle, typename TSpec > inline typename Needle< Pattern<TNeedle, TSpec> const>::Type & needle(Pattern<TNeedle, TSpec> const & obj);       	// "projects/library/seqan/find/find_pattern_base.h"(297)
template <typename THaystack> inline unsigned int & needle(Finder<THaystack, MultipatternFinder> & me);       	// "projects/library/seqan/find/find_multi.h"(91)
template <typename THaystack> inline unsigned int const & needle(Finder<THaystack, MultipatternFinder> const & me);       	// "projects/library/seqan/find/find_multi.h"(98)

//____________________________________________________________________________
// operator+

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> const operator+ (Finder<THaystack, TSpec> const & left, TIntegral right);       	// "projects/library/seqan/find/find_base.h"(625)

//____________________________________________________________________________
// operator++

template <typename THaystack, typename TSpec> inline Finder<THaystack, TSpec> & operator++(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(609)

//____________________________________________________________________________
// operator+=

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> & operator+= (Finder<THaystack, TSpec> & left, TIntegral right);       	// "projects/library/seqan/find/find_base.h"(638)

//____________________________________________________________________________
// operator-

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> const operator- (Finder<THaystack, TSpec> const & left, TIntegral right);       	// "projects/library/seqan/find/find_base.h"(651)
template <typename THaystack, typename TSpec, typename TIntegral> inline typename Difference<Finder<THaystack, TSpec> const>::Type operator- (Finder<THaystack, TSpec> const & left, Finder<THaystack, TSpec> const & right);       	// "projects/library/seqan/find/find_base.h"(659)

//____________________________________________________________________________
// operator--

template <typename THaystack, typename TSpec> inline Finder<THaystack, TSpec> & operator--(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(600)

//____________________________________________________________________________
// operator-=

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> & operator-= (Finder<THaystack, TSpec> & left, TIntegral right);       	// "projects/library/seqan/find/find_base.h"(672)

//____________________________________________________________________________
// position

template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, MultipleShiftAnd> & me);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(255)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type position(Finder<THaystack, Swift<TSpec> > & finder);       	// "projects/library/seqan/find/find_swift.h"(778)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type position(Finder<THaystack, Swift<TSpec> > const & finder);       	// "projects/library/seqan/find/find_swift.h"(786)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, SetHorspool> & me);       	// "projects/library/seqan/find/find_set_horspool.h"(207)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, WuManber> & me);       	// "projects/library/seqan/find/find_wumanber.h"(434)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, AhoCorasick> & me);       	// "projects/library/seqan/find/find_ahocorasick.h"(239)
template <typename TNeedle, typename TAutomaton> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, MultiBFAM<TAutomaton> > & me);       	// "projects/library/seqan/find/find_multiple_bfam.h"(220)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, TSpec> >::Type position(Finder<THaystack, TSpec> & me);       	// "projects/library/seqan/find/find_base.h"(559)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, TSpec> >::Type position(Finder<THaystack, TSpec> const & me);       	// "projects/library/seqan/find/find_base.h"(568)

//____________________________________________________________________________
// positionRange

template <typename THaystack, typename TSpec> inline Pair<typename Position<Finder<THaystack, Swift<TSpec> > >::Type> positionRange(Finder<THaystack, Swift<TSpec> > &finder);       	// "projects/library/seqan/find/find_swift.h"(832)
template <typename THaystack, typename TSpec> inline Pair<typename Position<Finder<THaystack, Swift<TSpec> > >::Type> positionRange(Finder<THaystack, Swift<TSpec> > const &finder);       	// "projects/library/seqan/find/find_swift.h"(849)

//____________________________________________________________________________
// range

template <typename THaystack, typename TSpec> inline typename Infix<THaystack>::Type range(Finder<THaystack, Swift<TSpec> > &finder);       	// "projects/library/seqan/find/find_swift.h"(868)
template <typename THaystack, typename TSpec, typename TText> inline typename Infix<TText>::Type range(Finder<THaystack, Swift<TSpec> > &finder, TText &text);       	// "projects/library/seqan/find/find_swift.h"(883)
template <typename TNeedle, typename TIndexSpec, typename TSpec> inline typename Value<TNeedle>::Type & range(Pattern<Index<TNeedle, TIndexSpec>, Swift<TSpec> > &pattern);       	// "projects/library/seqan/find/find_swift.h"(898)

//____________________________________________________________________________
// scoreLimit

template <typename TNeedle> inline int scoreLimit(Pattern<TNeedle, AbndmAlgo > const & me);       	// "projects/library/seqan/find/find_abndm.h"(565)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline typename Value<TScore>::Type scoreLimit(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > const & me);       	// "projects/library/seqan/find/find_score.h"(241)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline int scoreLimit(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const & me);       	// "projects/library/seqan/find/find_pex.h"(248)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline int scoreLimit(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > const & me);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(495)

//____________________________________________________________________________
// scoringScheme

template <typename TNeedle, typename TSpec> inline typename ScoringScheme<Pattern<TNeedle, TSpec> >::Type scoringScheme(Pattern<TNeedle, TSpec> &);       	// "projects/library/seqan/find/find_pattern_base.h"(336)
template <typename TNeedle, typename TSpec> inline typename ScoringScheme<Pattern<TNeedle, TSpec> const>::Type scoringScheme(Pattern<TNeedle, TSpec> const &);       	// "projects/library/seqan/find/find_pattern_base.h"(343)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline TScore const & scoringScheme(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "projects/library/seqan/find/find_score.h"(199)

//____________________________________________________________________________
// segment

template <typename TNeedle, typename TSpec> inline typename Infix<TNeedle>::Type segment(Pattern<TNeedle, TSpec> & me);       	// "projects/library/seqan/find/find_pattern_base.h"(224)
template <typename TNeedle, typename TSpec> inline typename Infix<TNeedle>::Type segment(Pattern<TNeedle, TSpec> const & me);       	// "projects/library/seqan/find/find_pattern_base.h"(231)

//____________________________________________________________________________
// setBeginPosition

template <typename TNeedle, typename TSpec, typename TPosition> inline void setBeginPosition(Pattern<TNeedle, TSpec> & me, TPosition _pos);       	// "projects/library/seqan/find/find_pattern_base.h"(192)

//____________________________________________________________________________
// setContainer

template <typename THaystack, typename TSpec> inline void setContainer(Finder<THaystack, TSpec> & me, typename _Parameter<THaystack>::Type container_);       	// "projects/library/seqan/find/find_base.h"(455)

//____________________________________________________________________________
// setEndPosition

template <typename TNeedle, typename TSpec, typename TPosition> inline void setEndPosition(Pattern<TNeedle, TSpec> & me, TPosition _pos);       	// "projects/library/seqan/find/find_pattern_base.h"(215)

//____________________________________________________________________________
// setHaystack

template <typename THaystack, typename TSpec > inline void setHaystack(Finder<THaystack, TSpec> &obj, THaystack const &hstk);       	// "projects/library/seqan/find/find_base.h"(694)

//____________________________________________________________________________
// setHost

template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, Quasar> & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_quasar.h"(92)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, Quasar> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_quasar.h"(100)
template <typename TNeedle, typename TSpec, typename TNeedle2> inline void setHost(Pattern<TNeedle, TSpec> & me, TNeedle2 const & ndl);       	// "projects/library/seqan/find/find_pattern_base.h"(162)
template <typename TNeedle, typename TSpec, typename TNeedle2> inline void setHost(Pattern<TNeedle, TSpec> & me, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_pattern_base.h"(169)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, MultipleShiftAnd> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(124)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, MultipleShiftAnd> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_multiple_shiftand.h"(209)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, Horspool> & me, TNeedle2 const & ndl);       	// "projects/library/seqan/find/find_horspool.h"(86)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, Horspool> & horsp, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_horspool.h"(117)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AbndmAlgo> & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_abndm.h"(153)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AbndmAlgo> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_abndm.h"(201)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> void setHost(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_score.h"(179)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> void setHost(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TNeedle2 const & ndl);       	// "projects/library/seqan/find/find_score.h"(187)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, SetHorspool> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_set_horspool.h"(112)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, SetHorspool> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_set_horspool.h"(166)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, WildShiftAnd> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_wild_shiftand.h"(309)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, WildShiftAnd> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_wild_shiftand.h"(529)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, HammingHorspool> & me, TNeedle2 const & ndl, int const k);       	// "projects/library/seqan/find/find_hamming_horspool.h"(81)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, HammingHorspool> & horsp, TNeedle2 & ndl, unsigned int k);       	// "projects/library/seqan/find/find_hamming_horspool.h"(131)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, ShiftAnd> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_shiftand.h"(80)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, ShiftAnd> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_shiftand.h"(121)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, ShiftOr> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_shiftor.h"(79)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, ShiftOr> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_shiftor.h"(120)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, WuManber> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_wumanber.h"(399)
template <typename TNeedle, typename TNeedle2> inline void setHost(Pattern<TNeedle, WuManber> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_wumanber.h"(407)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, Simple> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_simple.h"(87)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, Simple> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_simple.h"(93)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, BndmAlgo> & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_bndm.h"(82)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, BndmAlgo> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_bndm.h"(122)
template <typename TNeedle, typename TNeedle2, typename TVerification, typename TMultiFinder> void setHost (Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_pex.h"(183)
template <typename TNeedle, typename TNeedle2, typename TVerification, typename TMultiFinder> void setHost (Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_pex.h"(194)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, BFAM<Oracle> > & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_bom.h"(137)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, BFAM<Trie> > & me, TNeedle2 const& needle);       	// "projects/library/seqan/find/find_bom.h"(148)
template <typename TNeedle, typename TNeedle2, typename TSpec> inline void setHost (Pattern<TNeedle, BFAM<TSpec> > & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_bom.h"(166)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AhoCorasick> & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_ahocorasick.h"(187)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, AhoCorasick> & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_ahocorasick.h"(216)
template <typename TNeedle, typename TAutomaton, typename TNeedle2> void setHost (Pattern<TNeedle, MultiBFAM<TAutomaton> > & me, TNeedle2 const & needle);       	// "projects/library/seqan/find/find_multiple_bfam.h"(185)
template <typename TNeedle, typename TAutomaton, typename TNeedle2> inline void setHost(Pattern<TNeedle, MultiBFAM<TAutomaton> > & me, TNeedle2 & needle);       	// "projects/library/seqan/find/find_multiple_bfam.h"(193)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> void setHost(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, TNeedle2 & ndl);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(410)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> void setHost(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, TNeedle2 const & ndl);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(419)
template <typename THaystack, typename TSpec> inline void setHost(Finder<THaystack, TSpec> & me, typename _Parameter<THaystack>::Type container_);       	// "projects/library/seqan/find/find_base.h"(445)

//____________________________________________________________________________
// setMinThreshold

template <typename TIndex, typename TSpec, typename TSeqNo, typename TThreshold> inline void setMinThreshold(Pattern<TIndex, Swift<TSpec> > & pattern, TSeqNo seqNo, TThreshold thresh);       	// "projects/library/seqan/find/find_swift.h"(412)

//____________________________________________________________________________
// setNeedle

template <typename TNeedle, typename TSpec > inline void setNeedle(Pattern<TNeedle, TSpec> &obj, TNeedle const &ndl);       	// "projects/library/seqan/find/find_pattern_base.h"(314)
template <typename THaystack> inline void setNeedle(Finder<THaystack, MultipatternFinder> & me, unsigned int const needleIndex_);       	// "projects/library/seqan/find/find_multi.h"(107)

//____________________________________________________________________________
// setPosition

template <typename THaystack, typename TSpec, typename TPosition> inline void setPosition(Finder<THaystack, TSpec> & me, TPosition pos_);       	// "projects/library/seqan/find/find_base.h"(590)

//____________________________________________________________________________
// setScoreLimit

template <typename TNeedle, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, AbndmAlgo > & me, TScoreValue _limit);       	// "projects/library/seqan/find/find_abndm.h"(578)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TScoreValue _limit);       	// "projects/library/seqan/find/find_score.h"(262)
template <typename TNeedle, typename TScoreValue,typename TVerification, typename TMultiFinder> inline void setScoreLimit(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TScoreValue _limit);       	// "projects/library/seqan/find/find_pex.h"(261)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, Myers<TSpec, TFindBeginPatternSpec> > & me, TScoreValue _limit);       	// "projects/library/seqan/find/find_myers_ukkonen.h"(508)

//____________________________________________________________________________
// setScoringScheme

template <typename TNeedle, typename TSpec, typename TScore2> inline void setScoringScheme(Pattern<TNeedle, TSpec> & me, TScore2 & score);       	// "projects/library/seqan/find/find_pattern_base.h"(365)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TScore2> inline void setScoringScheme(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TScore2 & score);       	// "projects/library/seqan/find/find_score.h"(211)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TScore2> inline void setScoringScheme(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TScore2 const & score);       	// "projects/library/seqan/find/find_score.h"(220)

//____________________________________________________________________________
// valid

template <typename TNeedle> inline bool valid(Pattern <TNeedle,WildShiftAnd> & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(551)
template <typename TNeedle> inline bool valid(Pattern <TNeedle,WildShiftAnd> const & me);       	// "projects/library/seqan/find/find_wild_shiftand.h"(559)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

