/***************************************************************************
 * RT2400/RT2500 SourceForge Project - http://rt2x00.serialmonkey.com      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   Licensed under the GNU GPL                                            *
 *   Original code supplied under license from RaLink Inc, 2004.           *
 *   This MD5 code is based on code from Dynamics -- HUT Mobile IP         *
 *   Copyright (C) 1998-2001, Dynamics group                               *
 ***************************************************************************/

 /***************************************************************************
 *      Module Name: md5.h
 *
 *      Abstract: contain MD5 and AES cipher algorithm
 *
 *      Revision History:
 *      Who             When            What
 *      --------        -----------     -----------------------------
 *      MarkW           8th  Dec 04     Baseline code
 ***************************************************************************/

#ifndef	__MD5_H__
#define	__MD5_H__

#define MD5_MAC_LEN 16
#define SHA_DIGEST_LEN 20

typedef struct _MD5_CTX {
	ULONG Buf[4];		// buffers of four states
	UCHAR Input[64];	// input message
	ULONG LenInBitCount[2];	// length counter for input message, 0 up to 64 bits
} MD5_CTX;

VOID MD5Init(MD5_CTX * pCtx);
VOID MD5Update(MD5_CTX * pCtx, UCHAR * pData, ULONG LenInBytes);
VOID MD5Final(UCHAR Digest[16], MD5_CTX * pCtx);
VOID MD5Transform(ULONG Buf[4], ULONG Mes[16]);

void md5_mac(UCHAR * key, ULONG key_len, UCHAR * data, ULONG data_len,
	     UCHAR * mac);
void hmac_md5(UCHAR * key, ULONG key_len, UCHAR * data, ULONG data_len,
	      UCHAR * mac);

#endif				// __MD5_H__

/******************************************************************************/

VOID SHAInit(SHA_CTX * pCtx);
UCHAR SHAUpdate(SHA_CTX * pCtx, UCHAR * pData, ULONG LenInBytes);
VOID SHAFinal(SHA_CTX * pCtx, UCHAR Digest[20]);
VOID SHATransform(ULONG Buf[5], ULONG Mes[20]);

void hmac_sha1(unsigned char *text, int text_len, unsigned char *key,
	       int key_len, unsigned char *digest);
void F(char *password, unsigned char *ssid, int ssidlength, int iterations,
       int count, unsigned char *output);
int PasswordHash(char *password, unsigned char *ssid, int ssidlength,
		 unsigned char *output);

/******************************************************************************/
#ifndef	_AES_H
#define	_AES_H

#ifndef	uint8
#define	uint8  unsigned	char
#endif

#ifndef	uint32
#define	uint32 unsigned	long int
#endif

typedef struct {
	uint32 erk[64];		/* encryption round     keys */
	uint32 drk[64];		/* decryption round     keys */
	int nr;			/* number of rounds     */
} aes_context;

int aes_set_key(aes_context * ctx, uint8 * key, int nbits);
void aes_encrypt(aes_context * ctx, uint8 input[16], uint8 output[16]);
void aes_decrypt(aes_context * ctx, uint8 input[16], uint8 output[16]);

#endif				/* aes.h */
