
(define-syntax make-semaphore
  (syntax-form (name n)
    (make <semaphore>
          state: (%make <vector> #f #f)
          count: n
	  name: name))
  (syntax-form (n) (make-semaphore #f n))
  (syntax-form ()
    (make-semaphore #f 0))
  (else
   make-semaphore.))

(define-method write-object ((self <semaphore>) port)
  (format port "#[<semaphore> ~s ~a]" (name self) (count self)))

(define (make-semaphore. #optional (n default: 0))
  (make-semaphore n))

(define-safe-glue (semaphore-signal (s <semaphore>))
{
  obj n = gvec_ref( s, SEMAPHORE_COUNT );

  gvec_write_non_ptr( s, SEMAPHORE_COUNT, ADD1(n) );
  if (FX_LT( n, ZERO ))
   {
     obj thr = dequeue_pop_front( s );

     /* the top thread is no longer blocked... */
     gvec_write_non_ptr( thr, THREAD_BLOCKED_ON, ZERO );

     mark_thread_ready( thr );
   }
  RETURN0();
})

(define-safe-glue (semaphore-wait (s <semaphore>))
{
  obj n = SUB1( gvec_ref( s, SEMAPHORE_COUNT ) );
  gvec_write_non_ptr( s, SEMAPHORE_COUNT, n );
  if (FX_LT(n,ZERO))
   {
     dequeue_push_back( s, current_thread );
     SAVE_CONT0(sem_ok);
     SWITCH_THREAD( s, TSTATE_BLOCKED );
   }
  else
   {
     RETURN0();
   }
}
("sem_ok" {
   RESTORE_CONT0();
   RETURN0();
}))

(define-syntax (with-semaphore s . body)
  (semaphore-wait s)
  (bind ((#rest r (handler-case
		   (begin . body)
		   ((<condition> condition: c)
		    (semaphore-signal s)
		    (signal c)))))
    (semaphore-signal s)
    (list->values r)))

   
