///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/basis_on_pointset.h"
namespace rheolef {

// -----------------------------------------------------------------------
// basis evaluated on lattice of quadrature formulae
// -----------------------------------------------------------------------
template<class T>
void 
basis_on_pointset<T>::_initialize (reference_element hat_K) const
{
  reference_element::variant_type K_variant = hat_K.variant();
  if (_mode == quad_mode) {
    typename quadrature<T>::const_iterator first = _p_quad -> begin(hat_K);
    size_type                              nq    = _p_quad -> size (hat_K);
    _val[K_variant].resize (nq);
    for (size_type q = 0; q < nq; first++, q++) {
      const point_basic<T>& hat_node_q = (*first).x;
      _b.eval (hat_K, hat_node_q, _val[K_variant][q]);
    }
  } else if (_mode == nodal_mode) {
    std::vector<point_basic<T> > hat_node;
    _nb.hat_node (hat_K, hat_node);
    size_type nq = hat_node.size();
    _val[K_variant].resize (nq);
    for (size_type q = 0; q < nq; q++) {
      _b.eval (hat_K, hat_node[q], _val[K_variant][q]);
    }
  } else {
    fatal_macro ("unsupported eval in specific mode");
  }
  _initialized [K_variant] = true;
}
template<class T>
void 
basis_on_pointset<T>::_grad_initialize (reference_element hat_K) const
{
  reference_element::variant_type K_variant = hat_K.variant();
  if (_mode == quad_mode) {
    typename quadrature<T>::const_iterator first = _p_quad -> begin(hat_K);
    size_type                              nq    = _p_quad -> size (hat_K);
    _grad_val[K_variant].resize (nq);
    for (size_type q = 0; q < nq; first++, q++) {
      const point_basic<T>& hat_node_q = (*first).x;
      _b.grad_eval (hat_K, hat_node_q, _grad_val[K_variant][q]);
    } 
  } else {
    fatal_macro ("unsupported grad eval in non-quadrature mode");
  }
  _grad_initialized [K_variant] = true;
}
template<class T>
typename basis_on_pointset<T>::size_type
basis_on_pointset<T>::size (reference_element hat_K) const
{
  if (_mode == quad_mode) {
    return _p_quad -> size (hat_K);
  } else if (_mode == nodal_mode) {
    return _nb.size (hat_K);
  } else {
    fatal_macro ("unsupported size(hat_K) in specific mode");
  }
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
#define _RHEOLEF_instanciation(T)       	\
template class basis_on_pointset<T>;

_RHEOLEF_instanciation(Float)

} // namespace rheolef
