set terminal epslatex color standalone
set output "p-laplacian-rate-log.tex"

set size square 0.7

set xtics (\
	"[c]{$10^{-2}$}" 1e-2, \
	"[c]{$10^{-1}$}" 1e-1, \
	"[c]{$10^{0}$}" 1 )
set ytics (0,1,2)

set xlabel "[c]{$|p-2|$}"
set  label "[l]{\\Large $\\bar{v}$}" at graph 0.05,0.75

set logscale x
plot [1e-2:1][0:2] \
  "p-laplacian-rate.gdat" u (2-$1):2 title "[r]{$p<2$}" w l, \
  "p-laplacian-rate.gdat" u ($1-2):2 title "[r]{$p>2$}" w l

#pause -1 "<retour>"
