///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// discontinuous galerkin : test in horizontal transport
#include "rheolef.h"
using namespace rheolef;
using namespace std;

point v (const point & x) { return point(1, 0); }

Float u0 (const point & x) { 
  Float a = 0.2;
  Float b = 0.2;
  if ((x[0] < a+b)&&(x[0]>a-b))
    return 1;
  return 0;
}

// transport_pur xxx.geo <Dt> 
int main (int argc, char **argv) {
#ifdef _RHEOLEF_HAVE_UMFPACK
  Float Dt = (argc > 2) ? atof(argv[2]) : 0.001 ;
  size_t n_max = 500;
  geo omega (argv[1]);
  space Vh (omega, "P2", "vector");
  //Vh.block ("boundary");
  space Xh (omega, "P1d");
  field vh = interpolate (Vh, v);
  field uh = interpolate(Xh, u0);
  form a0 (Xh, Xh, "d_dx0", vh[0]); //a0 = trans(a0);
  form a1 (Xh, Xh, "d_dx1", vh[1]); //a1 = trans(a1);
  form m  (Xh, Xh, "mass");
  form cv (Xh, Xh, "convect", vh);
  form a = a0 + a1 - cv + 1.0/Dt*m;
  ssk<Float> a_fact = lu(a.uu);
  branch event ("t","u");
  cout << event(0, uh);
  for (size_t n = 1 ; n <= n_max ; n++) {
    field f = 1.0/Dt*m*uh;
    uh.u = a_fact.solve(f.u);
    cout << event (Float(n)*Dt,uh);
  }
#endif // _RHEOLEF_HAVE_UMFPACK
  return 0;
}
