#!/bin/bash
if test $# -eq 0; then
  echo "usage: $0 [-eps] file[.plot]" 1>&2
  exit 1
fi
output_format_eps=false
if test x"$1" = x"-eps"; then
  shift
  output_format_eps=true
fi
name=`expr $1 : '\(.*\).plot' \| $1`
if test ! -f $name.plot; then
  echo "$0: file \"$name.plot\" not found" 1>&2
  exit 1
fi
liste=""
for mot in $(cat $name.plot); do
  if [ "${mot:(-5)}" = ".tex\"" ]; then
	mot=${mot#\"}
	mot=${mot%\"}
	liste="$liste $mot"
  elif [ "${mot:(-5)}" = ".tex'" ]; then
	mot=${mot#\'}
	mot=${mot%\'}
	liste="$liste $mot"
  fi
done
# clean:
for i in $liste; do
  n=${i%.tex}
  rm -f $n.dvi $n.aux $n.log $n.tex $n-inc.eps $n.glog
done
# -----------
# run gnuplot
# -----------
command="gnuplot $name.plot"
echo $command
eval $command 2> $name.glog
status=$?
cat $name.glog
if test $status -ne 0; then
  echo "$0: command failed: gnuplot $name.plot" 1>&2
  for i in $liste; do
    n=${i%.tex}
    rm -f $n.dvi $n.aux $n.log $n.tex $n-inc.eps $n.glog
  done
  exit 1
fi
if test `grep -i warning $name.glog | \
	      grep -v -i 'empty cb range' | \
	      grep -v -i 'difficulty making room for' | \
	      wc -l` \
	     -ne 0; then
  echo "$0: gnuplot warning changed to error"
  for i in $liste; do
    n=${i%.tex}
    rm -f $n.dvi $n.aux $n.log $n.tex $n-inc.eps $n.glog
  done
  exit 1
fi
#rm -f $name.glog
# -----------
# run latex
# -----------
for i in $liste; do
  n=${i%.tex}  
  # small fix for some file names containing '=' such as "evp-shear-eta-a=1-r=1.5.plot" :
  command="sed -e 's/inc}}/inc.eps}}/' < $i > $i.new && mv $i.new $i"
  echo $command
  eval $command
  command="(echo R | latex $i 2>&1) > $n.glog"
  echo $command
  eval $command
  status=$?
  nerr=`grep -i "Latex Error" $n.log | wc -l`
  if test $nerr -ne 0 || test ! -f $n.dvi; then
    cat $n.glog	
    echo "! $0: latex ERROR with $name.plot"
    rm -f $n.dvi $n.aux $n.log $n.tex $n-inc.eps $n.glog
    exit 1
  fi
  command="dvips -E $n.dvi"
  echo $command
  eval $command
  status=$?
  if test $status -ne 0; then
    echo "! $0: dvips ERROR with $name.plot"
    exit 1
  fi
  command="ps2epsi $n.ps $n.eps"
  echo $command
  eval $command
  status=$?
  rm -f $n.dvi $n.aux $n.log $n.tex $n-inc.eps $n.glog $n.ps
  if test $status -ne 0; then
    rm -f $n.eps
    echo "! $0: ps2epsi ERROR with $name.plot"
    exit 1
  fi
  if $output_format_eps; then
    # .eps done : next output file
    continue
  fi
  # here output .pdf 
  command="epstopdf $n.eps"
  echo $command
  eval $command
  status=$?
  rm -f $n.eps
  if test $status -ne 0; then
    rm -f $n.pdf
    echo "! $0: epstopdf ERROR with $name.plot"
    exit 1
  fi
done
