#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main (int argc, char** argv) {
  environment rheolef (argc, argv);
  field uh;
  din >> uh;
  string valued =  (uh.size() == 3) ? "vector" : "scalar";
  space Ph (uh.get_geo(), "P2", valued);
  Ph.block("top");  Ph.block("bottom");
  if (uh.get_geo().dimension() == 3) {
    Ph.block("back"); Ph.block("front");
  } else {
    Ph.block("left"); Ph.block("right");
  }
  const space& Xh = uh.get_space();
  form a (Ph, Ph, "grad_grad");
  form b (Xh, Ph, "curl");
  field psi_h (Ph, 0.);
  field lh = b*uh;
  solver sa (a.uu());
  psi_h.set_u() = sa.solve (lh.u() - a.ub()*psi_h.b());
  dout << catchmark("psi") << psi_h;
}
