#include "rheolef.h"
using namespace rheolef;
using namespace std;
void usage(string name) {
  derr << name << ": usage: "
       << name << " "
       << "[-|file[.field[.gz]]] "
       << "[-check] "
       << "[-residue] "
       << "[-criteria] "
       << endl;
  exit (1);
}
field residue (Float p, const field& uh) {
  warning_macro ("p="<<p);
  const space& Xh = uh.get_space();
  string grad_approx = "P" + itos(Xh.degree()-1) + "d";
  space Th (Xh.get_geo(), grad_approx, "vector");
  field fh (Xh, 1);
  form m     (Xh, Xh, "mass");
  form inv_mt(Th, Th, "inv_mass");
  form grad  (Xh, Th, "grad");
  field grad_uh = inv_mt*(grad*uh);
  field wh = pow(norm2(grad_uh), p/2 - 1);
  form a (Xh, Xh, "grad_grad", wh);
  field mrh = a*uh - m*fh;
  mrh["boundary"] = 0;
  field rh (Xh);
  solver sm = ldlt(m.uu());
  rh.set_u() = sm.solve(mrh.u());
  rh["boundary"] = 0;
  return rh;
}
void check (Float p, const field& uh) {
  field rh = residue(p, uh);
  const space& Xh = rh.get_space();
  form m (Xh, Xh, "mass");
  Float res = sqrt(m(rh,rh));
  derr << "check: residue = " << res << endl;
  check_macro (res < 1e-3, "unexpected residue");
}
field criteria (Float p, const field& uh) {
  if (uh.get_approx() == "P1") return abs(uh);
  const space& Xh = uh.get_space();
  string grad_approx = "P" + itos(Xh.degree()-1) + "d";
  space Th (Xh.get_geo(), grad_approx, "vector");
  form inv_mt(Th, Th, "inv_mass");
  form grad  (Xh, Th, "grad");
  field grad_uh = inv_mt*(grad*uh);
  field norm_grad_uh = norm(grad_uh);
  return pow(norm_grad_uh, p/2);
}
int main(int argc, char**argv) {
  environment rheolef (argc,argv);
  if (argc < 3) usage(argv[0]);
  Float p;
  field uh;
  if (strcmp (argv[1], "-") == 0)  {
    din >> catchmark("p")     >> p
        >> catchmark("u")     >> uh;
  } else {
    idiststream in; in.open(argv[1], "field");
    in >> catchmark("p")     >> p
       >> catchmark("u")     >> uh;
  }
  for (int i = 2; i < argc; i++) {
    if (strcmp (argv[i], "-check") == 0) { check (p, uh); }
    else if (strcmp (argv[i], "-residue") == 0) { dout << catchmark("ru")   << residue (p, uh); }
    else if (strcmp (argv[i], "-criteria") == 0) { dout << catchmark("c")   << criteria (p, uh); }
    else {
       derr << argv[0] << ": unknown option \'" << argv[i] << "'" << endl;
       usage(argv[0]);
    }
  }
}
