//  mkgeo_grid -e 1000 -a -2 -b 2 > line2.geo
//  ./convect line2 1e-3 5 > line2.branch 
//  ./convect2 line2 1e-3 5 > line22.branch 
//  (./convect_error < line2.branch > line2-cmp.branch) 2>&1|g -v trace |g -v load |tee cv.gdat
//  (./convect_error < line22.branch > line22-cmp.branch) 2>&1|g -v trace |g -v load |tee cv2.gdat
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "rotating-hill.h"
int main (int argc, char **argv) {
  environment rheolef (argc,argv);
  geo omega (argv[1]);
  Float  nu     = (argc > 2) ? atof(argv[2]) : 1e-2;
  size_t n_max  = (argc > 3) ? atoi(argv[3]) : 50;
  size_t d = omega.dimension();
  Float delta_t = 2*acos(-1.)/n_max;
  space Vh (omega, "P1", "vector");
  field uh = interpolate (Vh, u(d));
  space Xh (omega, "P1");
  Xh.block ("boundary");
  field phi_h      = interpolate (Xh, phi(d,nu,0));
  field phi_h_prec = interpolate (Xh, phi(d,nu,-delta_t));
  characteristic X1 (  -delta_t*uh);
  characteristic X2 (-2*delta_t*uh);
  form m (Xh, Xh, "lumped_mass");
  form a (Xh, Xh, "grad_grad");
  branch event ("t","phi");
  dout << catchmark("nu") << nu << endl
       << event (0, phi_h);
  for (size_t n = 1; n <= n_max; n++) {
    Float t = n*delta_t;
    field l1h = riesz(Xh, compose(phi_h, X1));
    field l2h = riesz(Xh, compose(phi_h_prec, X2));
    field lh = 2*l1h - 0.5*l2h;
    form c = (1.5 + delta_t*phi::sigma(d,nu,t))*m + delta_t*nu*a;
    solver sc (c.uu());
    phi_h_prec = phi_h;
    phi_h.set_u() = sc.solve (lh.u() - c.ub()*phi_h.b());
    dout << event (t, phi_h);
  }
}
