% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logs.R
\name{showLog}
\alias{showLog}
\alias{getLog}
\title{Inspect Log Files}
\usage{
showLog(id, reg = getDefaultRegistry())

getLog(id, reg = getDefaultRegistry())
}
\arguments{
\item{id}{[\code{integer(1)} or \code{data.table}]\cr
Single integer to specify the job or a \code{data.table} with column \code{job.id}
and exactly one row.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
Nothing.
}
\description{
\code{showLog} opens the log in the pager. For customization, see \code{\link[base]{file.show}}.
\code{getLog} returns the log as character vector.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
tmp = makeRegistry(file.dir = NA, make.default = FALSE)

# Create some dummy jobs
fun = function(i) {
  if (i == 3) stop(i)
  if (i \%\% 2 == 1) warning("That's odd.")
}
ids = batchMap(fun, i = 1:5, reg = tmp)
submitJobs(reg = tmp)
waitForJobs(reg = tmp)
getStatus(reg = tmp)

writeLines(getLog(ids[1], reg = tmp))
\dontrun{
showLog(ids[1], reg = tmp)
}

grepLogs(pattern = "warning", ignore.case = TRUE, reg = tmp)
}
\seealso{
Other debug: \code{\link{getErrorMessages}},
  \code{\link{getStatus}}, \code{\link{grepLogs}},
  \code{\link{killJobs}}, \code{\link{resetJobs}},
  \code{\link{testJob}}
}
\concept{debug}
