/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2                                                       *
 * Modul:     callback.h                                                     *
 *            GTK callback functions for paul                                *
 * Author:    Andreas Tille                                                  *
 * Date:      03.09.1998                                                     *
 * Copyright: Andreas Tille, 1999; Gnu Public License                        *
 *                                                                           *
 *****************************************************************************/

#if !defined(_callback_h_)
#define _callback_h_
#define FAST_TIME  0.4

typedef struct {
   char          *name;     /* Name of parameter                                 */
   int            typ;      /* type of value                                     */
   void          *val;      /* Pointer to value of parameter                     */
   gfloat         upper;    /* upper boundary                                    */
   gfloat         lower;    /* lower boundary                                    */
   GtkSignalFunc  valchg;   /* Function called if value was changed              */
   GtkAdjustment *adj;      /* Adjustment to edit value                          */
   void          *userdata; /* sometimes we need some data in callback functions */
} ITEM;

typedef struct {
   char          *name;   /* Name of possibilty for value                      */
   unsigned char  val;    /* Pointer to value according to this name           */
} RADIO;

typedef struct {
   char          *title,  /* Title of parameter input window                   */
                 *frame;  /* Title of frame                                    */
   int            np;     /* Number of parameters in param                     */
   int            def;    /* Number of default parameter                       */
   unsigned char *val;    /* Pointer to value of parameter                     */
   RADIO         *radio;  /* Parameters                                        */
} RADIO_PARA_IN;

typedef int (*PAUL_FUNC)(PAUL *p);
typedef int (*PICLIST_FUNC)(GList *pl);
#define PAUL_FUNC_TYPE     0
#define PICLIST_FUNC_TYPE  1
#define THIS               1  /* 2 */
#define MARK               2  /* 1 */
#define ALL                4  /* 0 */

/* obtain picture (list) from clist */
#define LI2PL(cl)       (GList *)(GTK_CLIST(cl)->selection ? gtk_clist_get_row_data(GTK_CLIST(cl),(gint)GTK_CLIST(cl)->selection->data) : NULL)
/* obtain activ row number */
#define ACT_ROW(p)      ( IS_PAUL(p) ? gtk_clist_find_row_from_data(GTK_CLIST(p->filelist), p->activ) : -1 )
#define ROW(p, pl)      ( IS_PAUL(p) && pl ? gtk_clist_find_row_from_data(GTK_CLIST(p->filelist), pl) : -1 )

/* from animate.c */
void       AnimationTimeParameterCallback(PAUL *p);
int        PictureAnimate(GtkWidget *button, PAUL *p);
int        StopPictureAnimate(GtkWidget *button, PAUL *p);

/* from callback.c */
void       DoPaulExit(GtkWidget *w, PAUL *p);
void       PaulExit(PAUL *p);
void       PictureKeyPressed(GtkWidget *show, GdkEvent *event, PAUL *p);
void       ConfigureCallback(GtkWidget *show, GdkEventConfigure *event, PAUL *p);
void       BrightnessCallback(PAUL *p, int which);
void       CutCallback(PAUL *p, int which);
void       DelBorderCallback(PAUL *p, int which);
void       DelScanBorderCallback(PAUL *p, int which);
void       DifferenceCallback(PAUL *p, int which);
void       QueueDifferenceCallback(PAUL *p);
void       FFTCallback(PAUL *p, int which);
void       FilterCallback(PAUL *p, int which);
void       HistogramCallback(PAUL *p, int which);
void       ScaleCallback(PAUL *p, int which);
void       MoveImageCallback(PAUL *p, int which);
void       MirrorCallback(PAUL *p, int which);
void       MonochromeCallback(PAUL *p, int which);
void       NegativCallback(PAUL *p, int which);
void       RotateCallback(PAUL *p, int which);
void       RotateVariableCallback(PAUL *p, int which);
void       ShrinkCallback(PAUL *p, int which);

/* gcutarea.c */
int        CutPaul(PAUL *p);

/* from file.c */
void       FileDelete(PAUL *p);
void       FileLoad(PAUL *p);
void       FileSave(PAUL *p);
void       FilesSaveAll(PAUL *p);
void       FileSaveAs(PAUL *p);
void       LoadFirstPicture(PAUL *p);

/* from filelist.c */
int        FileListButtonPressed(GtkWidget *list_item, GdkEventButton *event, PAUL *p);
void       FileListSelectChild(GtkWidget *list, gint row, gint col, GdkEventButton *event, PAUL *p);
void       MarkFilename(GtkWidget *clist, int row, char mark);

/* from ginfo.c */
void       FileInfo(PAUL *p);

/* from ginsert.h */
void       ThisInsertCallback(PAUL *p);

/* from gtkpaul.c */
int        CreatePicture(PAUL *p);

/* from gtkuti.c */
void       ApplyPaulFunc(PAUL *p, void *func, int func_type, int which, int freeze);
void       _ParameterChanged(GtkButton *button, gpointer data);
void       _RadioParameterChanged(GtkButton *button, unsigned char *val);
GtkWidget *BuildParameterTable(ITEM *para, int np);
GtkWidget *BuildRadioTable(RADIO *para, int np, unsigned char init);
void       BuildParameterInput(GtkWidget *box, const char *title, const char *frame_title, void *data, 
                               GtkSignalFunc chg_func, void *chg_data,
                               GtkSignalFunc add_func, void *add_data);
void       RadioButtonParameter(RADIO_PARA_IN *para_in, GtkWidget *box);
void       RefreshImage(GtkCList *list, GList *pl);
void       SelectAndShowActiv(PAUL *p);
void       SelectAndUpdateInfo(PAUL *p);
void       AddImageToFilelist(PAUL *p, PICTURE *bild);
void       RemoveActivImageFromFilelist(PAUL *p);
GList     *RemoveImageFromFilelist(PAUL *p, GList *pl);
void       CreateGtkListOfImages(PAUL *p);
GList     *GetListFromSelection(GList *piclist);
void       MakeNewFileList(PAUL *p);
void       MenueSensitive(PAUL *p);
int        ButtonSensitive(PAUL *p);
int        SetAnimateControl(PAUL *p);

/* menue.c */
int        BuildMenu(PAUL *p);

/* from operimg.c */
void       CreateOperationImageWindow(PAUL *p);
void       OperationToList(gpointer *realdata, gpointer *flagdata);

/* from parameter.c */
void       BrightnessParameterCallback(PAUL *p);
void       DelBorderParameterCallback(PAUL *p);
void       DifferenceParameterCallback(PAUL *p);
void       FilterParameterCallback(PAUL *p);
void       GrayParameterCallback(PAUL *p);
void       MoveParameterCallback(PAUL *p);
void       RotationParameterCallback(PAUL *p);
void       ScaleParameterCallback(PAUL *p);
void       ShrinkParameterCallback(PAUL *p);

#endif




