// $Id: RomMajutsushi.hh,v 1.10 2005/01/13 18:25:41 m9710797 Exp $

#ifndef __ROMMAJUTSUSHI_HH__
#define __ROMMAJUTSUSHI_HH__

#include "Rom8kBBlocks.hh"

namespace openmsx {

class DACSound8U;

class RomMajutsushi : public Rom8kBBlocks
{
public:
	RomMajutsushi(const XMLElement& config, const EmuTime& time,
	              std::auto_ptr<Rom> rom);
	virtual ~RomMajutsushi();
	
	virtual void reset(const EmuTime& time);
	virtual void writeMem(word address, byte value, const EmuTime& time);
	virtual byte* getWriteCacheLine(word address) const;

private:
	std::auto_ptr<DACSound8U> dac;
};

} // namespace openmsx

#endif
