# Version number
OMNIPY_MAJOR = 0
OMNIPY_MINOR = 5

.ifdef OMNIORB_VERSION
.else
OMNIORB_MAJOR_VERSION = 2
OMNIORB_MINOR_VERSION = 8
OMNIORB_MICRO_VERSION = 0
OMNIORB_VERSION = \
  $(OMNIORB_MAJOR_VERSION).$(OMNIORB_MINOR_VERSION).$(OMNIORB_MICRO_VERSION)

OMNIORB_$(OMNIORB_MAJOR_VERSION) = 1
OMNIORB_$(OMNIORB_MAJOR_VERSION)_$(OMNIORB_MINOR_VERSION) = 1
OMNIORB_$(OMNIORB_MAJOR_VERSION)_$(OMNIORB_MINOR_VERSION)_$(OMNIORB_MICRO_VERSION) = 1
.endif


.ifdef OMNIORB_3_0

version30dir = omni30
version30macros = OMNIORBPY_FOR_30

.else

version28dir = omni28
version28macros = OMNIORBPY_FOR_28
UTOP=../../..

.endif

versiondir = $(version28dir)$(version30dir)
versionmacros = $(version28macros)$(version30macros)

DIR_CXXMACROS = OMNIPY_MAJOR=$(OMNIPY_MAJOR) OMNIPY_MINOR=$(OMNIPY_MINOR)\
	OMNIORB_VERSION_STRING=""""$(OMNIORB_VERSION)"""" $(versionmacros)\
	WITH_THREAD

DIR_FIRSTACTIONS = DEFINE VERSIONDIR [.$(versiondir)]
subdirs = $(versiondir) common

CXXSRCS=versiondir:omnipy.cc-
	versiondir:pyORBFunc.cc-
	versiondir:pyPOAFunc.cc-
	versiondir:pyPOAManagerFunc.cc-
	versiondir:pyObjectRef.cc-
	versiondir:pyCallDescriptor.cc-
	versiondir:pyServant.cc

CXXSRCS_0=[.common]pyExceptions.cc-
	[.common]pyMarshal.cc-
	[.common]pyTypeCode.cc-
	[.common]pyThreadCache.cc-
	[.common]pyomniFunc.cc

lib = _omnipymodule$(DebugSuffix).olb

OBJS = $(lib)(omnipy)-
          $(lib)(pyORBFunc)-
          $(lib)(pyPOAFunc)-
          $(lib)(pyPOAManagerFunc)-
          $(lib)(pyObjectRef)-
          $(lib)(pyCallDescriptor)-
          $(lib)(pyServant)-
          $(lib)(pyExceptions)-
          $(lib)(pyMarshal)-
          $(lib)(pyTypeCode)-
          $(lib)(pyThreadCache)-
          $(lib)(pyomniFunc)

DIR_CXXINCLUDES = $(UTOP)/src/lib/omniORB2 $(UTOP)/src/lib/omniORB2/orbcore\
	/python_include


all :: $(OBJS)

export :: all

export :: $(lib)
	@ $(ExportLibrary)
