# This file is automatically generated - do not edit
# Generated by ./pod2help.pl from nxtvepg.pod at Wed Feb 27 21:38:01 2002

.menubar.help insert 0 separator
.menubar.help insert 0 command -label {Description} -command {PopupHelp 0}
set {helpIndex(Description)} 0
set helpTexts(0) {{Description} title {
} {} {nxtvepg} bold { is an X11 and Win32API application to decode, analyze and browse TV programme schedules transmitted on analog TV channels as defined in ETS 300 707: "Protocol for a TV Guide using electronic data transmission" by the European Telecommunications Standards Institute.
The Nextview standard was developed for use in TV sets, but it can also be received and used in a PC - provided you have a Teletext capable TV tuner card and are lucky enough to have a Nextview content provider in your country.
} {} {nxtvepg} bold { enables you to obtain free TV programme listings for all of the major networks in Germany, Austria, France and Switzerland. Currently Nextview EPG is transmitted by the following TV networks (note that each of these EPGs cover not only the provider's programme but also that of many other networks):
In Germany and Austria: Pro7, 3Sat, RTL-II.
In Switzerland: DRS1, TSR1, TSI1, EuroNews.
In France: Canal+, M6, TV5.
In Turkey: TRT-1
For up-to-date information check the nxtvepg homepage in the Internet (see the About popup in the Help menu). If you don't receive any of the channels listed above, you can only use the demo mode as described with the } {} {-demo} bold { command line option.
} {} }
.menubar.help insert 1 command -label {Options} -command {PopupHelp 1}
set {helpIndex(Options)} 1
set helpTexts(1) {{Options} title {
Summary of command line options:
} {} {-display} bold { } {} {display} underlined {
UNIX only: The display on which the windows will be created. Default: taken from environment variable DISPLAY.
} {} {-geometry} bold { } {} {geometry} underlined {
Specifies the position of the main window, e.g.  } {} {-geometry -0+0} bold { to put the main window in the upper right corner of the visible screen. The size of the window cannot be changed.
} {} {-iconic} bold {
Start with the main window iconified (i.e. minimized).
} {} {-rcfile} bold { } {} {path} underlined {
Specify an alternate configuration file. Default: on UNIX $HOME/.nxtvepgrc, on Windows nxtvepg.ini in the current directory.
} {} {-dbdir} bold { } {} {directory} underlined {
Specify an alternate directory for the databases. Default: On UNIX /usr/tmp/nxtvdb, on Windows the current directory. Note that the database management is not equipped for concurrent writing, so if you have more than one TV tuner card in your system or network, relocate the directory into the users' homes.
If you're using an acquisition daemon, the browser must be configured to use the same directory as the daemon.  If the daemon is running on a different host, you need to mount the remote directory, e.g. via NFS.
} {} {-card} bold { } {} {index} underlined {
Specify which tuner card to use, if you have more than one. The given index is appended to /dev/vbi and /dev/video. Default: index 0, i.e. the card in the first PCI slot.
} {} {-provider} bold { } {} {CNI} underlined {
Select a provider by its hexadecimal CNI (Country and Network Identifier), e.g. C<-provider d94> for "Pro Sieben". You can find out the provider's CNI during a provider scan or from the database file names. Default: the last provider selected during the previous session.
} {} {-noacq} bold {
Start with acquisition disabled. The acquisition can still be started later from the Control menu.
} {} {-daemon} bold {
Start without the graphical user interface (UNIX only). The process will detach from the terminal and perform background acquisition. If no other options are given the same provider and acquisition mode as configured with the GUI will be used. If the -provider option is given acquisition will work for this provider only (note the difference to non-daemon mode, where that option selects the browser database). The -daemon option cannot be combined with the -noacq or -demo options.
The daemon always creates a named socket in the } {} {/tmp} underlined { directory plus optionally a TCP/IP socket to allow connects by browser processes. While connected, the browser receives updates for opened Nextview databases and reports about the acquisition progress; if left unconnected, the browser listing might be incomplete or outdated.
It's important to note that the browser } {} {must use} bold { the same } {} {-dbdir} underlined { directory, because the daemon forwards only deltas to the database files stored in that directory. For more details see the } {} {Client/Server} underlined { dialog described in } {} {Configuration} href {.
Warning: for security reasons it's depreciated to run the daemon with root privileges, because nxtvepg has not been reviewed yet for possible exploits. If you want to start the daemon already during system startup, you should use su(1). Also note that you'll probably need to specify -rcfile because the $HOME environment variable  might not be (correctly) defined.  Example:
   su nobody -c "/usr/local/bin/nxtvepg -daemon \ 
   -rcfile /usr/local/etc/nxtvepgrc" 
The only way to stop the daemon is to send it a signal, i.e. kill it with SIGTERM. For more details see } {} {Control} href { and } {} {Files} href {.
} {} {-nodetach} bold {
In daemon mode this option prevents the process actually making itself a daemon, i.e. it doesn't fork and stays connected to the terminal. Also all log messages starting with level .I warning are sent to standard error out (e.g. configuration errors that lead to an immediate exit).  This mode is intended for debugging purposes only.
} {} {-acqpassive} bold {
In daemon mode this option overrides the acquisition mode setting in the configuration file and forces the acquisition into passive mode (see } {} {Acquisition modes} href {).  The configuration file is not changed, so that you can use different acquisition strategies for daemon and GUI.
} {} {-demo} bold { } {} {path} underlined {
Load database given by } {} {path} underlined { and enter demo mode. In this mode all entries of the database are shifted into the presence, i.e. just far enough so that none expire. Hence the entries' dates and times are not for real and acquisition or database reselection is not possible.
} {} {-help} bold {
List all available command line options.
After the options you can add a database filename. This is equivalent to specifying } {} {-dbdir} bold { and } {} {-provider} bold {. The provider CNI is taken from the file name. If the file name does not have the format as defined in } {} {Files} href {, it's assumed to be a demo database and loaded just as with the } {} {-demo} bold { option. The database filename argument silently overrides any previously given options.
This is particularily useful for users of graphical file managers (like the Windows Explorer) who can just drag and drop a database file onto the executable. When used on Windows systems the working directory is set to the one that contains the executable, because the Explorer seems to set it to the user's desktop root, so that none of the DLLs and drivers are found.
Note to Windows users: all these options - unless otherwise noted - are available in the Win32 version too. You can supply the options either from a "MS-DOS" command prompt or batch file, or by appending them to the executable in a shortcut definition.
} {} }
.menubar.help insert 2 command -label {Getting started} -command {PopupHelp 2}
set {helpIndex(Getting started)} 2
set helpTexts(2) {{Getting started} title {
Before you can start reading in TV programme schedules (called } {} {acquisition} underlined { from here on), you have to do just a few configurations. Which ones depends on your setup and will be described in the following. As long as your browser window contains no data, there's also a recommondation how to get to data in the browser window, highlighted with a yellow background.
This manual describes all features of nxtvepg in detail. You do not have to read all of it at once to operate the software. However it's recommended to skim at least through } {} {Basic browsing} href {, } {} {Data acquisition} href { and } {} {Filtering} href {.
Windows users first have to configure the driver for their TV card. Therefore invoke the 'TV card input' dialog from the Configure menu (see } {} {Configuration} href {) and specify the type of your tuner. In Germany, Austria and Switzerland it should be either Philips PAL or Temic PAL. In France it's one of the SECAM types. Then select how your card's } {} {PLL} underlined { needs to be set up. On most cards it's either } {} {No init} underlined { or } {} {28 MHz} underlined {. If you're not sure about your configuration, start with the topmost and then try them one after each other and start an EPG scan inbetween to check if the tuner works. If this seems too much work, open your PC and read the manufacturer from the metal tuner box on the TV tuner card.
If you don't have an antenna connected to your PC, you can select an external source for video input. If you have problems see } {} {README} underlined { for more details and a list of error messages from the Windows driver.
UNIX users just need to check if the correct input source and frequency table are selected in the TV card input dialog.
In the next step - if you chose to use the TV tuner - run a provider scan from the Configure menu.  During the scan all TV channels are checked for Nextview transmissions. After the scan has finished, open the provider selection dialog from the Configure menu and select you favorite one.
If the provider scan does not find all Nextview provider channels (possibly due to weak reception - this is a very simple scan that does not attempt any fine-tuning) check the } {} {Slow} underlined { button and try again. If this does not help, you can still add the missing providers manually. set the acquisition mode to } {} {external} underlined { or } {} {passive} underlined { (UNIX only). Then use an external application to tune the channel (Windows users have to stop acquisition first; then start the TV application; then tune the channel; then quit the other application; finally start acquisition again). In external mode nxtvepg will not touch the tuner and wait infinitly for Nextview reception on the current channel.  On Windows (and Linux with bttv drivers version 0.7.50 and earlier) this method has the disadvantage that no frequency will be known for this provider so this procedure has to be repeated every time you start acquisition.
Alternatively if you decided not to use the tuner, open the Acquisition mode dialog from the Configure menu and select external mode. Then provide the video signal of one of the content provider channels listed in the introduction to the selected input socket. As soon as an EPG provider is recognized, its data will appear in the browser window. See } {} {Data acquisition} href { about the disadvantages of not using the TV tuner as input.
Acquisition of a complete database takes about 20 minutes. However programmes that are nearer in the future are available much faster, since they are transmitted more often. The currently running and directly following programmes of all networks are usually available after about 2-3 minutes max.
} {} }
.menubar.help insert 3 command -label {Basic browsing} -command {PopupHelp 3}
set {helpIndex(Basic browsing)} 3
set helpTexts(3) {{Basic browsing} title {
The browser mainly consists of two windows: the upper one contains a list of programme titles, sorted by start time. All currently running programmes (or rather: all programmes that should be running according to their start time) are marked by a light blue background color. One line in the list is selected by a cursor; the lower window contains the attributes and description for this selected title. The amount of information available here depends entirely on the content provider.
The basic browsing of programme information works very straight-forward. You can either use the mouse or the keyboard cursor keys:
With the mouse, you can click on any title to select it and display its description in the lower window. With a double-click you open a popup window with a summary of all attributes known for that title.  See } {} {Filtering} href { on how to use those for filtering. Use the scrollbar to scroll the listing forward to programmes farer in the future.
With the keyboard, use the Cursor up/down keys to select any title. For fast scrolling use the page up/down keys. With the Home key you always get back to the first title. With TAB and SHIFT-TAB you can move the keyboard input focus to other widgets, e.g. to the scrollbars or the shortcut list. On Unix, the menus can be accessed with the Meta key (usually the ALT key) together with one of the underlined characters in the menu buttons.
nxtvepg can communicate with the } {} {xawtv} underlined { TV application (UNIX only) to provide a connection in both directions: Firstly you'll find a } {} {Tune-TV} underlined { button in the main window below the clock. When you press it, the network of the currently selected programme will be tuned into xawtv. With the right mouse button you can also pop up a small menu which offers basic control over xawtv. Secondly, when you change the channel in xawtv, the cursor will automatically jump onto the programme currently running on that network. To use these features, you'll have to open the } {} {Network name configuration} underlined { dialog at least once to synchronize network names with your xawtv station names. See } {} {Configuration} href { for details.
At the bottom of the window there is a status line which informs you about the state of the browser database and background acquisition. It's basically a very dense summary of the } {} {Statistics} bold { popups from the } {} {Control} bold { menu and is especially useful to warn you about the database age or stalled acquisition.
} {} {Note:} underlined { For most providers it holds true that descriptions are available only (or only in full length) for currently running programmes and those whose start time is very close. This time span for full coverage can be as short as 2 hours, or 3 titles per network. For details on the acquisition process see the following chapter.
} {} }
.menubar.help insert 4 command -label {Data acquisition} -command {PopupHelp 4}
set {helpIndex(Data acquisition)} 4
set helpTexts(4) {{Data acquisition} title {
As long as acquisition is enabled, programme titles are constantly being acquired or updated in the background. You will notice that all incoming programme information is instantly inserted to the programme listing. Every effort is taken to not alter the cursor position or title selection, except if the cursor is on the very first item - then the cursor stays on top.
By default, the acquisition always works for the provider whose database you have loaded into the browser. Therefore, upon program start or whenever you switch providers, the TV tuner is set onto the frequency of the provider's TV channel.  Please note that this mode is only possible after a provider scan, because that's the only way to find out the frequencies. Check out } {} {Acquisition modes} href { for more sophisticated acquisition strategies.
If you do not choose the TV tuner as input (e.g. if you choose an external source via the Composite or S-Video input sockets), or if the TV tuner is kept busy by another application (UNIX only, e.g. if you watch TV) data is still being acquired, but it's no longer possible to automatically change the TV channel. Hence you are resposible for selecting the channel of the provider who's database you want to load or refresh. If a transmission belonging to a different provider than the one selected in the browser is detected, a second database is automatically opened in the background to store the incoming data.
The transmitted database is constantly in change: Elapsed titles are removed, new titles appended, and the titles closest to the current time updated with an increased amount of description. (The reason that the complete description is not transmitted for all titles is simply that the size of the database has to be reduced - it shall be transmitted in 20 minutes maximum.)  So you should start the acquisition as often as possible, about every 2-3 hours, at least a couple of minutes before you browse.
You can monitor the progress of acquisition with the timescale and database statistics windows from the Control menu. See } {} {Statistics} href { for details.
} {} }
.menubar.help insert 5 command -label {Acquisition modes} -command {PopupHelp 5}
set {helpIndex(Acquisition modes)} 5
set helpTexts(5) {{Acquisition modes} title {
The acquisition mode configuration dialog enables you to control for which providers data is collected, and in which order. It's mainly intended for users who use more than one provider's database, i.e. in a merged database, or want to optimize startup time. If you're happy with a single provider or don't want to browse immediately after program start, you should keep the default, which is loading data always for the provider selected in the browser.
} {} {Passive} bold {
UNIX only: In this mode the software never accesses the video device and never changes the input channel or tuner frequency.  It's useful if you want to set up the source with command line tools like } {} {v4lctl} underlined {. If you're using applications which keep the video device busy (e.g. a TV application) you don't need this mode, because when nxtvepg detects an unsolicited channel change, it automatically switches to the passive mode for as long as the video device remains busy.
Please note: when nxtvepg does not control the input channel, it can not automatically take care of updating your databases. Even if the browser database should be completely empty, no data will appear until you tune in the provider's channel manually with an external application. Because of this, passive mode is depreciated.
} {} {External} bold {
This is the recommended mode for Composite or S-Video input sources. Only the input source will be set; the tuner is not touched. Hence the provider channel has to be selected either externally (e.g. in a satellite receiver connected to the Composite or S-Video input sockets) or by a different application (e.g. TV application, UNIX only), just like in passive mode.
On Windows systems this mode can be used if your tuner is not known to nxtvepg, i.e. if the EPG scan does not find any channels with all of the available tuner types. In this case tune in the provider channel with a TV application; then quit this application and start nxtvepg. When you view the acquisition statistics from the Control menu, the VPS/PDC code of the tuned channel should appear in the lower half of the window.
} {} {Follow-UI} bold {
This is the default mode: the acquisition always works for the provider you have selected for the browser (i.e. user interface). If you change the provider in the browser window, acquisition follows by tuning the new channel. Of course this requires to have performed an EPG scan at least once, so that the tuner frequencies of all providers are known. When you use a merged database in the browser, acquisition works on each of the merged providers, one after another, just like in the mode described next.
} {} {Manually selected} bold {
This mode enables you to manually select for which providers the acquisition should work. If you select more than one provider, they are loaded one after another, in your specified order. Warning: if you choose a provider for the browser that's not on the list, no data will be loaded into the browser, even if it's completely empty.
Since transmission errors have to be considered, it's not attempted to load every single block of a provider before acquisitions switches to the next. Instead a statistical criterium was defined, that regards the variance in coverage of all networks contained in the database, and the slope of that variance.
} {} {Cyclic: Now - Near - All} bold {
Like the previous mode, this one enables you to specify a list of providers to load data for. However they are not just loaded completely one after another. Instead, a 3-staged round-robin is implemented. In the first stage, only } {} {Now} underlined { data is loaded, i.e. the currently running and next 2-3 programmes. When this has been completed for all providers, the next stage begins, which loads } {} {Near} underlined { data, i.e. all programmes running in the next 12-24 hours. When that was completed, the final stage loads the outstanding blocks for all providers. See below for an explanation what this mode is good for.
} {} {Cyclic: Now - All} bold {
This is the same as the previous mode, except that the } {} {Near} underlined { stage is skipped.
} {} {Cyclic: Near - All} bold {
This is the same as the mode before the previous one, except that the } {} {Now} underlined { stage is skipped.
Which mode is best for you depends on how you use the browser. As said above, if you're mainly using a single provider, stick with the Follow-UI mode. If you use a merged database, data is automatically loaded for all contained providers. However if you switch manually between multiple providers, you should choose one of the manual acquisition modes.
The Cyclic modes enables you to optimize startup time. While in standard manual mode, the first database is loaded completely before the next one is started, in Cyclic modes you can specify to load only Now data of all providers first. Hence already after a couple minutes you'll have updated Now information for all providers. If you require more look-ahead than the next 2-3 programmes, e.g. the complete evening, use a Cyclic mode that starts with the Near stage.
If you use manual acquisition together with a merged browser database, make sure to put the same provider at top in both lists, i.e. acquisition should always start for the "master database" of the merge.
Please note that the time until all databases are complete is longer in the cyclic modes than in standard manual mode. In general, the time used for the Now and Next stages just adds to the time to complete the database.
Also note that the cyclic modes depend on the transmission cycles of the providers. Firstly this means that the time ranges covered by the cycle stages may differ between providers. Secondly, the cycle times may vary. In the worst case the Near cycle runs as long as the cycle for the complete database (e.g. the German provider RTL2). In this case you don't win anything by selecting a mode that contains a Near stage.
} {} }
.menubar.help insert 6 command -label {Statistics} -command {PopupHelp 6}
set {helpIndex(Statistics)} 6
set helpTexts(6) {{Statistics} title {
There are currently three ways to obtain information about the state of the databases and the acquisition process: the first and most obvious is the status line at the bottom of the main window (only if enabled, see see } {} {Configuration} href {). The second one are the timescale popup windows, which visualize for each TV network the time ranges which are covered with TV programme data. The third one are the database statistics popup windows which offer technical details about the database, e.g. which percentage of entries is already loaded etc., both in textual form and as charts.
The latter two windows are available separately for the browser and acquisition databases. (By default both are the same databases, but you can configure background acquisition on multiple databases, see } {} {Acquisition modes} href {). All types of statistics are regularily updated while acquisition is running. While connected to an acquisition daemon, all statistics output refers to the acquisition running in the daemon.
} {} {Status line} bold {
The status line separately summarizes the state of the browser database (unless it's a merged database) and the acquisition process. Since there's not much room only the most relevant information is included there, i.e. the kind of information presented depends on the current state.
For the browser database you'll normally just see the name of the content provider network and a percentage that describes how many of the blocks (i.e. TV programmes) in the provider database already have been received.
If more than 10% of the blocks in the database lie in the past, you'll additionally see a note about this percentage of expired blocks. Note that a 100% loaded database may appear completely empty when all blocks are expired.  As soon as you start acquisition the fill percentage will drop to 0 because a new inventory will have been loaded which no longer contains the expired blocks.
When acquisition for the browser database stopped more than 60 minutes ago, a note is added to the status line. In this case it may be advisable to start acquisition for this database to load descriptions for programmes that are now included in the "Near" time range (see } {} {Data acquisition} href {).
If acquisition is currently not active you'll see a note about that, often together with a reason, e.g. "no reception" when you've manually tuned a station that doesn't transmit Nextview.
Else you'll see the name of the content provider network and a percentage that describes the progress of acquisition. Note that this percentage may be different from the overall fill percentage given with the browser database, as it also reflects blocks that have to be reloaded due to version changes.
Additionally there may be a note about the current mode of acquisition, like the current phase for cyclic acquisition modes or "forced passive" when nxtvepg is not able to change the channel, maybe due to a TV application running in parallel. See } {} {Acquisition modes} href { for details.
} {} {Timescale popup windows} bold {
You can monitor the progress of acquisition with the timescale windows which can be opened from the Control menu. There's one window for the browser database, and one for the acquisition database. The acquisition window is updated whenenever new EPG blocks are received.
The timescale windows have one scale for each network covered by the selected provider. Each scale covers 5 days, beginning with the start time of the first TV programme in the database. Depending on how long ago the database was updated, the dates may be partly or entirely in the past. The exact dates are printed in the date scale at top of the window.
Ranges that are covered by programmes of the respective network in the database are marked in shades of red or blue, uncovered ranges are left black. The different colors reflect the } {} {stream} underlined { in which the data was received, or an error status; the shades age and version. Stream numbers are directly connected with the cycle phases mentioned in } {} {Acquisition modes} href {; besides this the difference is not relevant during normal operation.
} {} {red:} underlined {
PI blocks received in stream 1, i.e. cycle phase 'Near'.
} {} {blue:} underlined {
PI blocks received in stream 2, i.e. cycle phase 'All'.
} {} {dark red or blue:} underlined {
PI blocks from an earlier database version.
} {} {orange:} underlined {
expired PI blocks from stream 1.
} {} {cyan:} underlined {
expired PI blocks from stream 2.
} {} {yellow:} underlined {
invalid PI blocks (overlapping or zero run-time, block number not in the range given in inventory, etc.)
} {} {gray:} underlined {
missing PI blocks. Note that the range can only be roughly estimated, as the time range a block covers is not known until the actual block is available.
} {} {black:} underlined {
time range which is not covered by the provider.
In front of the scales there are 5 separate boxes, which refer to the first 5 programmes (PI blocks) in the inventory (AI block).  They have two purposes: firstly, during acquisition you can see when the 'Now' cycle phase is complete; secondly you can check if the data from the Now cycle is expired (marked orange).  If all 5 are orange, it's time to update the database.
} {} {Database statistics popup windows} bold {
There are two popup windows available from the Control menu which contain statistical information about the browser database and the acquisition database and progress. The window is horizontally divided in two parts: the upper part lists static information; the lower part lists dynamic info and is available only while acquisition is active.
The acquisition statistics are updated every time a new AI block (inventory which lists all covered networks and block counts per network; usually transmitted every 10 seconds) is received.
} {} {Last AI update:} underlined {
The (local) time when the last inventory block was received. Since this block has to be transmitted on a regular basis it tells you when acquisition was active for this database.
} {} {Database version:} underlined {
The version number is incremented by the provider every day or after content changes.  A version change forces a complete reload of the database.
} {} {Blocks in AI:} underlined {
How many blocks are transmitted in total. This number is taken from the provider's AI block, i.e. the inventory.  Additionally listed separately for stream 1 and 2 (swo).
} {} {Block count db:} underlined {
How many blocks are in the local database. At maximum this can be the number of blocks given in the AI block.
} {} {Current version:} underlined {
How many blocks are in the local database and have the latest version.
} {} {Filled:} underlined {
Percentage of blocks in the database in respect to the total given in the AI block, i.e. "Block count db" divided by "Blocks in AI". The second percentage in the line only reflects blocks of the current version and hence the degree of completeness of acquisition.
} {} {Expired blocks:} underlined {
Number of blocks which have a stop time that's in the past, i.e. which no longer show up in the browser. The percentage given here is in respect to the actual number of blocks in the local database (all versions), not the AI.
} {} {Defective blocks:} underlined {
Number of blocks with invalid or overlapping start time. These blocks do not show up in the browser (as it would be impossible to handle if there is more than one "now" entry for a network).  The percentage given here is in respect to the actual number of blocks in the local database (all versions), not the AI.
The pie chart on the left on the window visualizes these numbers. The circle represents 100% of the blocks listed in AI.  It's divided in stream 1 (red) and stream 2 (blue). The shaded segments represent the blocks that are still missing in the local database. The yellow segments the percentage of expired and/or defective blocks.
When you interpret those values, please remember that blocks may be appended to the transmission cycle when programmes have expired (in a slight violation of the Nextview standard this is done even without changing the database version). So you might see from time to time that the fill percentages take a step back down during acquisition. Also note that expired PI are not accessible from the user interface, however they are included in the database dump from the } {} {Control} underlined { menu.
} {} {Acq. runtime:} underlined {
How long the acquisition has been continuously running for this database. This timer is reset upon provider or database version changes or when an external channel change is detected.
} {} {Channel VPS/PDC:} underlined {
The VPS/PDC code that has last been received on the currently tuned channel. Usually this will be the same as the provider CNI given in the database statistics, but you might see different values here when you manually tune in a different channel with an external application.
If a valid VPS/PDC code (Programme Identification Label, PIL) was received together with the CNI it is appended after the CNI in decoded format (i.e. DD.MM HH:MM with day, month, hour and minute).  Note: the VPS/PDC codes are used to uniquely identify the current programme on a given network.  You can display the codes for all programmes in the database if you enable them in the } {} {Column selection} underlined { dialog (see } {} {Configuration} href {).
} {} {TTX data rate:} underlined {
The rate at which teletext data lines are received on the current channel in baud, i.e. bits per second.  Each teletext line counts as 45 bytes.
} {} {EPG data rate:} underlined {
Same as TTX data rate, however only teletext lines that belong to the page which transmits Nextview are counted.
} {} {EPG page rate:} underlined {
The per second average of received teletext pages with carry Nextview data. Many provider transmit one page per second during the day and up to 1.5 or 2 pages per second during the night.
} {} {AI recv. count:} underlined {
The number of AI blocks received since acquisition start.  As long as this counter remains at zero, no data is added to the database (because the AI block is mandatory to identify the provider.)
} {} {AI min/avg/max:} underlined {
The minimum, average and maximum distance between reception of AI blocks. The average should usually be 10 seconds.  The maximum should not be much higher or else an EPG scan might have a hard time finding this provider; also the acquisition start-up time would be higher because at first an AI block must be awaited.
} {} {PI rx repetition:} underlined {
The average of the number of times each block in the AI was received since start of the acquisition.  Divided in Now, stream 1 and stream 2. This value is used by acquisition control in the termination criterium for acquisition phases, if the acquisition mode is cyclic.
} {} {Acq mode:} underlined {
The current acquisition mode as configured by the user, or forced passive if nxtvepg failed to switch the channel.
} {} {Network variance:} underlined {
The variance of block coverage across all networks. This value is used by acquisition control in the termination criterium for acquisition phases, if the acquisition mode is cyclic. It's calculated by separately counting the number of blocks in the database for each network; then for each network calculating the percentage of available blocks in regard to expected blocks; then calculating the average and finally variance of these percentages.
The diagram at the left displays a history of fill percentages for stream 1 and 2; the meaning of the colors is the same as in the timescale windows.
} {} }
.menubar.help insert 7 command -label {Merged databases} -command {PopupHelp 7}
set {helpIndex(Merged databases)} 7
set helpTexts(7) {{Merged databases} title {
If you compare databases of different Nextview providers, you will often find that each has one or more nice features, or covers networks, that the others lack. Instead of changing back and forth between several providers all the time, database merging allows to select and combine features or networks from several original databases into one newly created database.
When you select the } {} {Merge providers...} bold { entry from the } {} {Configure} bold { menu, you will get a dialog with two listboxes: the left one contains a list of all currently available databases. The right one is the list of databases you want to merge. You can add, delete or reorder the entries is this list. When you're done with your selection, press } {} {Ok} bold { to start the merge and switch the browser to the new database.
By ordering providers in your selection, you assign priorities which are important for conflict resolution. A conflict occurs when programme start and stop times differ between providers. The likelyhood of such conflicts depends on the quality of your providers; theoretically they should never happen except if there are late program changes. In reality, conflicts are not that unlikely, particularily for programmes early in the morning. You should put the most reliable provider in the first position, because conflicting programmes from providers further down will be rejected, i.e. not added to the merged database.
The } {} {Configure} bold { button in the dialog gives you fine-control over the priority of providers during the merge of all distinct programme attributes. You can even completely remove a provider for an attribute, e.g. if they transmit false data (e.g. the Sound attribute is handled wrong by the German provider 3Sat: they have swapped Stereo and Surround). An exception is the title, where you must not delete any providers.
Attributes that cannot be merged, e.g. editorial rating, are fetched from the first database in the list that contains the attribute for a given programme.  An exception are sorting criteria and series, where only the first provider in the list is queried (i.e. even if the first provider does not have a sorting criterion for a given programme, the further databases are not searched) because these types of attributes cannot be mixed between providers (see also } {} {Filtering} href {).
Note: If you use a manual or cyclic acquisition mode, you should take care to include all providers of your merged database in the same order. Else, program changes will not appear in your database until the provider with highest priority is loaded. If you stay with the default } {} {Follow-UI} bold {, acquisition control will automatically cycle across all merged providers in the correct order.
} {} }
.menubar.help insert 8 command -label {Navigate} -command {PopupHelp 8}
set {helpIndex(Navigate)} 8
set helpTexts(8) {{Navigate} title {
The Navigate menu contains a tree of filtering options, that's transmitted by the selected provider together with the programme data. Filtering enables to restrict the listing of programme information to those titles matching the selected menu entry.
The extent and content of this menu depends entirely on the provider. Unfortunately most providers supply only a very limited menu, so you'll probably want to define your own filters, as described in the next two chapters.
Any filter selection can always be undone by the } {} {Reset} underlined { menu entry or the reset button in the main window.
} {} }
.menubar.help insert 9 command -label {Filtering} -command {PopupHelp 9}
set {helpIndex(Filtering)} 9
set helpTexts(9) {{Filtering} title {
Similar to } {} {Navigate} underlined {, this menu allows to control which of the programmes in the database are presented in the listing.  However here, you are not limited to a preselection of filter options.  There's a filter for every kind of attributes that can be attached to a program, e.g. it's network, start time, theme descriptors, ... and many more.
Filters can be undone either singularily by selecting the same filter menu entry again, or globally by clicking on the } {} {Reset} underlined { button or menu entries.
You can combine as many filters as you want to build a complex filter. If you combine two filters of different types, only programmes that match both attributes will be listed (logical AND). If you choose more than one filter of the same type, all programmes that match either attribute will be listed (logical OR).
} {} {Examples:} underlined { If you want to see all programmes listed for either network ARD or ZDF, simply select both networks. If you want to see all movies scheduled on PRO7, select network=PRO7 and theme=movies.
Summary of filter options:
} {} {Features} bold {
Restrict the listing to programmes that match all given attributes (logical AND), i.e. sound format, picture format, analog/digital, encrypted yes/no, live/new/repeat and subtitles yes/no. If you want to allow more than one value of the same attribute (e.g. picture format wide OR Pal+) you have to put them into different feature classes.
} {} {Parental Rating} bold {
Restrict the listing to programmes that are suitable for children of the given age or elder.
} {} {Editorial Rating} bold {
Restrict the listing to programmes that are rated (by the content provider) to have at least the given quality. The range of rating values is 1 to 7. Note that some providers do not use all values, e.g. only 1 to 5, or e.g. just 3, 5 and 7.
} {} {Themes} bold {
Restrict the listing to programmes that have any of the given theme categories attached to them (logical OR). The Nextview standard contains a list of 76 predefined themes, which are structured into 11 main categories and subcategories. A programme can have up to 5 themes attached. If you want to restrict the listing to programmes that have more than one of the given themes (logical AND) you need to specify them in different theme classes.
} {} {Series} bold {
Restrict the listing to programmes that belong to any of the given series. A series code always implies a network specification (even if the same programme is transmitted on different networks). This filter type is only available for providers that assign series codes; for the other ones you can use text search among programme titles.
} {} {Program index} bold {
Restrict the listing to programmes who's index is in the given range. The currently running programme of each network is given index zero, the following programme of each network index one etc. The three most important combinations are available as radio buttons: } {} {now} underlined { (range 0-0), } {} {next} underlined { (range 1-1) and } {} {now or next} underlined { (range 0-1).
For merged databases only indices 0 and 1 are supported.
} {} {Networks} bold {
Restrict the listing to programmes of one or more given networks. The filter is disabled when all checkbuttons are deactivated.
You can also permanently add an equivalent network filter menu to the main window by enabling } {} {Show networks} underlined { at the end of the } {} {Configuration} href { menu. Note that selection, order and names of networks are all configurable.
} {} {Text search} bold {
Restrict the listing to programmes who's title or description (or either if both options are enabled) contain the given text.  If you enable } {} {match complete text} underlined { an exact match will be required, i.e. a search for "heute" will not match on "heute journal" (this option is intended for title-only searches, as started from the context menu). If you enable } {} {match case} underlined { character case is relevant in comparisons, i.e. a search for "heute" will not match on title "Heute Abend".
The last used options are remembered in your personal configuration file. A history of the last searches, including options, are also stored and available in the "Title" drop-down menu in the main browser window.
} {} {Start Time} bold {
Restrict the listing to programmes who's start time lies in the given interval. There are two special modes for the interval specification: If you enable } {} {Start at current time} underlined { the interval start is fixed to the actual time when the filter is applied and the value given as stop time is interpreted as duration, i.e. it's added to the interval start. If you enable } {} {Stop at end of day} underlined { the interval end is fixed to 23:59 of the same day.
Note that the main intention of this filter is to support time restrictions in the provider's navigation menus (see } {} {Navigate} href {). For manual navigation there are more practical alternatives, e.g. the scrollbar and drop-down menus in the main browser window.
} {} {Sorting Criterions} bold {
Restrict the listing to programmes that have any of the given sorting criteria attached to them. Sorting criteria work very much like themes, however their meaning is not predefined by the Nextview standard. The content provider can use arbitrary numbers to represent an attribute. Attributes usually are themes that are not in the predefined catalog, e.g. current events like the Olympic Games, but could also be not content related at all.  The meaning of these numbers is only defined by the provider's navigation menus (see } {} {Navigate} href {).
Note that the interpretation of two filter types depends on the provider: sorting criterion and series. That's because those are just arbitrary numbers which only have a meaning in the context of the provider's navigation menu.
} {} {Hint:} underlined { the filter menu can also be used to examine the filter options that are invoked by the entries in the Navigate menu.
} {} }
.menubar.help insert 10 command -label {Filter shortcuts} -command {PopupHelp 10}
set {helpIndex(Filter shortcuts)} 10
set helpTexts(10) {{Filter shortcuts} title {
There's a number of predefined filter options in the main window below the clock. These shortcuts enable you to invoke filters by a single click of the mouse. You can freely add or remove entries from this list.
When you want to add a shortcut, either choose an entry from the Navigate menu or define your own filters via the Filter menu, possibly based on one or more already defined shortcuts. When you have found an interesting selection, call } {} {Add filter shortcut...} underlined { from the Filter menu. You'll find a new shortcut appended to the list of existing shortcuts. First you'll probably want to enter a description in the entry field at the top of the dialog; default is just "shortcut #xx". When you're done just press } {} {Save} underlined {, or } {} {Abort} underlined { if you've changed your mind and don't want to add this shortcut after all.
You can also change descriptions or ordering of existing shortcuts in this dialog.  If you want to modify the shortcut list without adding a new one, you can also access the dialog from the } {} {Configure} underlined { menu.
If you want to change the filter settings of an existing shortcut, then invoke the shortcut, modify the settings as you need and then use the } {} {Update filter shortcut} underlined { dialog in the Filter menu to save the new settings of any existing shortcut. You can use the } {} {Update & Edit} underlined { Button to jump to the filter configuration dialog, e.g. if you want to fine-tune the description or ordering.
When you deselect a shortcut, either by selecting another shortcut or clicking on it a second time with } {} {CTRL} underlined { held down, all it's filters will automatically be undone. Hence when you have two themes shortcuts, e.g. "Movies" and "Sports", and select first Movies, then Sports, you'll see only sports programmes afterwards.  However if you had selected theme movies manually, e.g. by the context menu explained in the next chapter, the movies filter might remain set, so that you'd get all programmes of theme movies OR sports.  Since that is usually not what one expects, a filter mask has been introduced to the shortcut setting.
The filter mask is defined in the shortcuts dialog with a checkbutton for each filter type. By default, the mask is enabled for every filter type you've included in the shortcut filter setting.  When you invoke the shortcut from the main window later, all filters of the given types will be cleared (masked out) before the shortcut filters are added. To return to the above example: if the "Sports" shortcut is defined with a themes mask, the manually set movies filter would be cleared before the theme filter is set to sports.
The masking can also be enabled when no filter of that type has been chosen. This can be used to define } {} {undo} underlined { shortcuts. E.g. choose the mask 'Themes' if you want a shortcut that allows to clear all theme-related filters at once. Or enabled all masks for a } {} {Reset} underlined { button (the only difference to the pre-defined Reset button would be that the cursor does not jump to the first Now programme.)
You can invoke several shortcuts in parallel by pressing the } {} {CTRL} underlined { or } {} {SHIFT} underlined { keys when selecting in the listbox - just as you know it from other applications. However the behavior of the combined shortcuts is slightly subtle and might not always match your expectations. That's because the shortcuts are not cleanly separated when processed. Instead all filters of all selected shortcuts are thrown together and then processed as if they belonged all to one shortcut in the way described in } {} {Filtering} href {. This might change in the future if someone convices me there's a real need to.
} {} }
.menubar.help insert 11 command -label {Context menu} -command {PopupHelp 11}
set {helpIndex(Context menu)} 11
set helpTexts(11) {{Context menu} title {
Another quick way to select and deselect filters is by using the context menu, which is popped up with the right mouse button in the browser window.
This menu consists of three parts: the first entries allow to undo the previously selected filters - either one by one or globally (reset).
The second part offers a number of possible new filter options, which depend on the currently selected title and the already selected filters. The offered filter types include: themes and network of the selected programme title, it's series code, repeat or original transmission suppression (only in cunjunction with series or title text filters) and last but not least the title text.
The title text and series filters allow to check very quickly for repeats of a programme. These filter options are included only if there is a match, i.e. if there's another programme with the same title or series code repectively.
The optional third part is empty by default, but can be used to invoke user-defined external commands on the selected programme. More precisely, you can execute any command with parameters of the selected programme (like title or start time) on its command line. The user commands and can be added via the Configure menu (see } {} {Configuration} href {).
} {} }
.menubar.help insert 12 command -label {Control} -command {PopupHelp 12}
set {helpIndex(Control)} 12
set helpTexts(12) {{Control} title {
Summary of commands available from the Control menu:
} {} {Enable acquisition} bold {
Toggles acquisition on or off.  When you start the browser, acquisition is automatically enabled (although failure to do so is silently ignored). Switching off acquisition allows other applications (e.g. a teletext decoder) to use the TV card while you browse the database, if you have only one TV card.
UNIX: When acquisition is switched off, the } {} {/dev/vbi} underlined { device is freed. Acquisition can also been switched on and off automatically (i.e. from a shell script) by sending signal HUP (e.g. with the kill(1) command) to any of the nxtvepg processes or threads.  If you're using a daemon for acquisition (see the next command) you have to send the signal to one of the daemon processes/threads.  To simplify this, the pid of the process which needs to be signalled is stored in } {} {/tmp/.vbi.pid} underlined { while the device is in use.
Windows: When acquisition is switched off, the driver is unloaded so that other programs can access the TV card.  Note that most Windows driver implementations do not allow for more than one TV card in the PC.
} {} {Connect to acq. daemon} bold {
UNIX only: Connect to or disconnect from an acquisition daemon, running in the background on the same host, or somewhere else in the network.  The address of the daemon and other parameters are configured in the } {} {Client/Server} underlined { menu (see } {} {Configuration} href {). By default the daemon is started on the local host.  The main advantage of using the daemon is that you can keep running acquisition permanently in the background, even if you terminate the browser, or even the X11 server (i.e. the windowing system).
If you attempt to connect, but no daemon is running, you'll be offered the option to automatically start the daemon and retry the connect, provided you have configured server hostname } {} {localhost} underlined {. The daemon will be started with the same database directory and rcfile as the browser.
Note that disconnecting from the daemon or terminating the browser does not stop the acquisition and hence does not free the device.  If that's what you want, choose the } {} {Enable acquisition} underlined { command instead, which sends the TERM signal to the daemon, i.e. it terminates the process. Of course this option only is available if your daemon is running on the same host and with the same user id as the browser process.
} {} {Dump stream} bold {
UNIX only: All incoming Nextview blocks are dumped to } {} {stdout} underlined { in an ASCII format. This is mainly intended for developers, but it may also help to debug reception problems, because in the dump you'll find any block that could be decoded without hamming errors, even before an inventory block (AI) has been received. This may help if you have very bad reception, because it may take a long time until a error-free copy of the usually large AI block is received.
When connected to a acquisition daemon, blocks are only dumped if they are new to the database or their content changed (because only those are forwarded by the daemon to the client.)
} {} {Dump raw database} bold {
Open a dialog that allows to dump all blocks in the database to } {} {stdout} underlined { (UNIX only) or into the named file in a raw text format, which is actually the same as with the } {} {Dump stream} underlined { command. This feature is mainly intended for developers. To understand all the infos in the text dump, you'll have to look at the source in } {} {epgui/epgtxtdump.c} underlined { in the nxtvepg source package.
The array of checkbuttons allows to control which kind of blocks will be written. The programme information blocks (PI) do contain the actual programme descriptions; } {} {Defective PI} underlined { contains those PI which were not accepted into the database because of inconsistencies like a zero or overlapping running time. For an explanation of the other block types please see the ETSI specification 707.
} {} {Dump in HTML} bold {
Open a dialog that allows to export the complete database or selected programmes into a file in HTML format (Hypertext Markup Language) which can then be loaded into a WWW browser, e.g. } {} {Netscape} underlined {. This is particularily useful if you want to print out TV descriptions.
At the top of the dialog window you have to enter the output file name. Click on the little folder button for a file selection dialog.
By default the checkbutton } {} {Selected programme only} underlined { is enabled. In this mode only info on the programme which is currently selected with the cursor will be written. In combination with the } {} {Append to file} underlined { mode this allows to build a document with the programmes that interest you step by step. If you deselect } {} {Selected programme only} underlined {, info on all programmes that match your current filter will be written. Note that this can generate very large files which may take a long time to load into your Web browser. In this mode you may want to set an additional start time filter (see } {} {Filtering} href {) to restrict the number of programmes written.
In the bottommost box you see three radio buttons with which you select the format in which the information will be written. If you select } {} {titles} underlined { you'll get a table in the same configuration as in the titles list in the upper part of the main window. If you select } {} {descriptions} underlined { you'll get roughly the same as in the lower part of the main window. Obviously, if you select } {} {titles and descriptions} underlined { you'll get both, in form of one table with all the titles on top and all descriptions separately below. If you select } {} {Add hyperlinks} underlined { the titles in the table will be linked to the descriptions.
The look of the generated document is almost entirely determined by use of an internal CSS stylesheet. If you don't like the look you can override it with your own stylesheet. Save it to a file named } {} {nxtvhtml.css} underlined { and put it in the same directory as the generated HTML file. For more information on HTML and style sheets see } {} {http://www.w3.org/} underlined {
} {} {View timescales} bold {
Toggles the timescale window for the browser database. The window reflects for each network included in the selected database, which time ranges are covered by programme information. If acquisition is working on the database, you can watch how more and more of the scales get covered.  See } {} {Statistics} href { for details.
} {} {View statistics} bold {
Toggles the browser database statistics window, which informs you about number of program entries in the database, fill percentage, expiration percentage, date of last update etc.  If the acquisition is working on the same database, it also contains information about state and progress of acquisition.  See } {} {Statistics} href { for details.
} {} {View acq timescales} bold {
Toggles the timescale window for the acquisition database. This entry is only available if the acquisition uses a different database than the browser.
} {} {View acq statistics} bold {
Toggles the acquisition statistics window, which informs you about state and progress of acquisition. If the acquisition control mechanism switches to a different database, the acq statistics window will automatically follow.  See } {} {Data acquisition} href { for details.
} {} {Quit} bold {
Close all windows and terminate the application.
} {} }
.menubar.help insert 13 command -label {Configuration} -command {PopupHelp 13}
set {helpIndex(Configuration)} 13
set helpTexts(13) {{Configuration} title {
Summary of commands available from the Configure menu:
} {} {Select provider...} bold {
Open the provider selection dialog.  This dialog lists all TV channels from which Nextview data can be received.  When you select a channel name on the list, you'll see the name of the Nextview service that's transmitted there and a list of all networks covered by it on the right. If you leave the dialog with Ok, the selected provider's database will be loaded into the browser.  The according TV channel will also be tuned to update the database, if you have selected "Follow-UI" acquisition mode.
} {} {Merge providers...} bold {
Open a dialog that allows to merge several databases into one. See } {} {Merged databases} href { for details.
} {} {Acquisition mode...} bold {
Open a dialog that allows to control the background acquisition process. See } {} {Acquisition modes} href { for more details.
} {} {Provider scan...} bold {
Open a dialog that allows to start a scan across all TV channels for Nextview transmissions.  You should perform this search at least once, firstly to find out which providers are available in your area, and secondly to determine the frequencies of all provider's TV channels. They are required for most acquisition modes, and due to driver limitations often not available without a scan (e.g. on Windows or Linux with bttv driver <= 0.7.50). See also } {} {Getting started} href {.
Check the } {} {Slow} underlined { button if you have bad reception on some channels. In slow mode the scanner will wait at least for 2 seconds on each channel for a VPS or PDC identification or an EPG package. Else channels without a stable video signal and without any teletext packets will be skipped after 150 ms.
UNIX only: The } {} {Use .xawtv} underlined { button is automatically checked if an xawtv configuration file is found in your home directory. Instead of searching all possible channels in all bands, nxtvepg then just checks the channels assigned there (fine-tuning and absolute frequencies currently are ignored though).
Use the } {} {Refresh only} underlined { mode if you deleted your database files or if you upgrade from an incompatible software version. In this mode only the channels on which Nextview data was received before are checked (the frequencies are kept in the rc/ini file). This enables you to regain your complete provider list very quickly.
} {} {TV card input...} bold {
Open a dialog where the driver for the TV card can be configured. On Windows systems you must at least specify which type of tuner is on your card, and how the PLL needs to be initialized. You can check your setting by starting an EPG scan: if nothing is found, try a different setting (or check the antenna cable). For more details see } {} {Getting started} href {, or } {} {README} underlined { if you get error messages from the Bt8x8 driver. If you experience data loss due to heavy system load, you can raise the acquisition thread priority.
The remaining three configuration options apply to both Linux and Windows: firstly you may choose which video input source to use. See } {} {Data acquisition} href { about the consequences of not using the TV tuner as input. If you live in France, select the French frequency table to be used for the EPG scan. If you have more than one TV tuner card, you can also choose which one to use, just like with the } {} {-card} bold { command line option.
} {} {Client/Server...} bold {
Opens a dialog that allows to configure the connection between acquisition daemon (called "server" here) and GUI.  The connection allows to forward all newly acquired EPG data from the daemon to the GUI and to monitor the daemon's acquisition progress.
The dialog contains settings of which some refer to the server-side only, some to the client-side only and some to both server and client.  To avoid confusion, there are three radio buttons at the top of the dialog which allow to grey out items that do not refer to the client or server respectively.
} {} {Enable remote control} underlined {
By enabling remote-control you can stop acquisition, change acquisition mode, TV card parameters or any parameters configured by this dialog in a running daemon via the network connection.
} {} {Enable TCP/IP} underlined {
By enabling connections via the TCP/IP network protocol, you allow connections from remote hosts.  Since there's currently no access control in nxtvepg, these hosts can be anywhere in your network, or anywhere in the world if you're connected to the Internet. If you don't have a firewall which prevents incoming connections of untrusted hosts, this mode is highly depreciated, because nxtvepg is not in any way secured against malicious client connections.
} {} {Server hostname} underlined {
Client-side only: this setting identifies the host on which the daemon is running. You can enter either a hostname in "dot.com" format or an IP address in "127.0.0.1" format.  If you set it to } {} {localhost} underlined { the connection is automatically established via UNIX domain sockets (i.e. pipes), which is more efficient than TCP/IP.  You can still use TCP/IP locally if you set it to the name of your local host, as returned by hostname(1).
} {} {Server TCP port} underlined {
If TCP/IP is enabled, this setting tells server and client which port to use. You can enter an arbitrary number between 1024 and 65535 here, but you have to make sure no other server is using the same port. Make sure you configure the same port number for client and server. The default is 7658.
} {} {Bind IP address} underlined {
If TCP/IP is enabled and your server host has more than one IP address, you can select here on which one to listen for incoming connections. Make sure you use the same IP address as server hostname on client-side, or a hostname that resolves to that IP address.  This setting is optional; if you leave the field blank (default) the server will bind to all IP addresses.
Note: on systems that support it, TCP/IP sockets are created in the IPv6 domain (} {} {PF_INET6} underlined {) by default.  On some systems (e.g. NetBSD) you cannot connect via IPv4 to an IPv6 server and vice versa, i.e. you need to use the same domain on both ends.  If your client only supports IPv4, you can force your server to create an IPv4 socket by binding to an IPv4 address.  If you fail to connect to a local IPv6 server via the IPv4 loopback address 127.0.0.1, use the IPv6 equivalent "::1".
} {} {Max. connections} underlined {
This setting limits the number of client connections the server will allow.  Once the limit is reached the server will stop listening for new connections.
} {} {Log filename} underlined {
If you enable log generation by the following option, you can choose here where the log will go. Make sure the file is writable to the uid under which the daemon process is running.  The file opened and closed for each appended log line (usually there's very low traffic into that file) so you can operate on it (e.g. truncate it) without restarting the daemon.
} {} {File min. log level} underlined {
Here you can choose if log information should be written to a file. If you run nxtvepg with TCP/IP disabled, you don't need to use logging; but if you allow remote connections you should keep log files at "info" level to be able to check which hosts connect to your server.
The following settings are available: "no logging" disables logging; "error" enables logging of internal errors that lead to an immediate exit of the daemon; "warning" additionally enables logging of unexpected events, i.e. internal errors which do not lead to exit; "notice" additionally enables logging of server status changes, i.e. startup and shutdown; "info" additionally enables logging of connection establishment or shutdown.
} {} {Syslog min. level} underlined {
Here you can enable or disable logging to syslog. See } {} {syslogd(8)} underlined { and } {} {syslog.conf(5)} underlined { for details about the syslog facility. The log levels you can choose here are the same as described in the previous paragraph for logging to files.
Note that while network mode is enabled configuration of acquisition mode and TV card input has no effect and no EPG scan is possible. If you use the same rc/ini file for daemon and GUI the changed settings will however be used by the daemon upon the next start.
} {} {Xawtv connection...} bold {
Opens a dialog that allows to configure the interaction between the } {} {xawtv} underlined { TV application and nxtvepg. This menu entry is available only on UNIX when a } {} {.xawtv} underlined { configuration file is found in your home. The first three buttons allow to switch the interaction features separately on or off. If you want to improve startup time, turn them all off; in this case nxtvepg does not need to search for the xawtv window (which can take up to several seconds if you have many applications running or a slow connection to your X server.) By default all three interaction features are enabled.
The first button relates to the } {} {Tune TV} underlined { button and it's little popup menu (accessed with right mouse button) below the clock. If you're not interested in remote-controlling xawtv, switch it off.
If you leave the } {} {Cursor follows channel changes} underlined { option enabled, nxtvepg will monitor xawtv channel changes. Whenever such a change is detected, the cursor in the programme listbox will be set onto the title currently running on that network. During EPG acquisition VPS/PDC is used to exactly determine the current programme (only on networks which support VPS/PDC); however if the nominal running time is in the past it's currently not possible to display the programme in the listbox. This info may however be sent to xawtv (see next option). If you have just a network filter enabled, it will be switched to the new network so that you'll get a complete listing of that network's programmes, starting with the currently running one. This works even when you have excluded this network in the network selection configuration. If there are more or other filters than network enabled, then they will remain unchanged. If the current programme on the new network does not match this filter setting, then neither cursor nor listbox content will be changed.
If you leave the } {} {Display EPG info in xawtv} underlined { option enabled, nxtvepg will monitor xawtv channel changes. During EPG acquisition VPS/PDC are also monitored to determine newly starting programmes. VPS/PDC also allows to detect channel changes on an external input source, e.g. a satellite receiver connected via the Composite socket. After a change of channel or current programme title, the info about the currently running title will be displayed in xawtv. The display format is selected by the following radio buttons:
With } {} {Separate popup} underlined { nxtvepg will generate a small popup window and put it right beneath the xawtv window. The blue area in the small bar on top represents how much of the (nominal) running time lies in the past. With } {} {Video overlay} underlined { the info will be handed to xawtv and displayed as subtitles (please note that this option only works properly with XFree86 version 4 and the XVideo extension). If you prefer a proportional font add the following line to } {} {~/.Xdefaults} underlined {:
   xawtv.vtx.label.font: -*-helvetica-bold-r-*--14-*-*-*-*-*-iso8859-* 
and execute } {} {xrdb -load ~/.Xdefaults} underlined { afterwards. Note that this will affect subtitles too. Future versions of xawtv will hopefully allow for dynamic font selection. } {} {Video overlay, 2 lines} underlined { is the same except that it writes running time and title in separate lines and additionally contains the percentage of expired running time. (Not recommended with xawtv versions older than 3.48 as there was a bug in displaying lines of different width.) With } {} {Xawtv window title} underlined { the info will be sent to xawtv and displayed in the window title. Except for this last option, you can configure the desired display duration with the slider at the bottom of the dialog. A duration of zero means the display will never be removed.
} {} {Select columns...} bold {
Open the browser listbox column configuration dialog. It allows to select which attributes are displayed for the listed programmes. In the listbox on the left you find a list of all available categories, e.g. title, running time & date, TV network, rating, sound and picture format, i.e. mostly the same attributes that are available for filtering. The listbox on the right contains the types currently selected for display. The topmost entry appears on the left side of the listbox.  Press } {} {Apply} underlined { to refresh the browser listbox with the new column selection and save the new configuration to the config file.
} {} {Select networks...} bold {
Open the network selection dialog. It allows to permanently suppress TV networks in a provider's listing, e.g. if you can not receive the channel. You can also change the order of the networks, e.g. to put your favorite networks at the top of the filter menus.
This window has two lists: on the left you'll find all networks that are covered by the provider in their original order, on the right those that are selected for the programme listing in your preferred order. By default, both lists will have exactly the same content. If you want to exclude networks, select them in the right list and press } {} {Delete} underlined {. You can always include them again by selecting them in the left list and pressing } {} {Add} underlined {. You can change the order in the right list by selecting one or more networks and pressing the } {} {up} underlined { or } {} {down} underlined { arrows. If you want the same selection and order for all providers, you can simply copy your selection with the } {} {copy} underlined { menu.
} {} {Network names...} bold {
Open the network names configuration dialog. It's main purpose is to synchronize the network names with } {} {xawtv} underlined { (UNIX TV application), i.e. the } {} {~/.xawtv} underlined { configuration file. This is required because the network name is used in communication with } {} {xawtv} underlined { for the } {} {"Tune TV"} underlined { remote control, and as well for channel change notifications.  For many networks there will be no need to change anything, but for some there exist different variants, e.g. in Germany "Super RTL" vs. "S-RTL" or "KiKa" vs. "Kinderkanal".
Another use of this dialog is to make network naming consistent across all providers. The names you specify here will be used in the programme listbox and all filter menus, independently of the provider.
On the left side of the window you'll find a list of all networks of all known Nextview providers. The names used here are the ones you configured before, or if you haven't done so, the names that match the station names in } {} {.xawtv} underlined { best; unmatched names are marked red. If that file does not exist, the name is taken from the first database which covers this network, in order of your provider selection history.
On the right side, you're offered four ways to change the name: topmost is a simple entry field where you can type in an arbitrary name. Below is a popup menu which contains all network names defined in } {} {.xawtv} underlined {. Below is a button which contains the one name in } {} {.xawtv} underlined { which resembles the current string in the entry field most, or } {} {none} underlined {. It's marked red until it's identical to the entry field. You can copy the name to the entry field by clicking the button. Below is a listbox with the original names used in the various provider databases. When you select a name from the menu or the listbox, it will be copied into the entry field and the network name list on the left. If you want to save the changed list, leave the dialog with } {} {Save} underlined {, else use } {} {Abort} underlined {.
Note: if you receive channels that carry multiple networks, e.g. in Germany "Arte / Kinderkanal", it's recommended to include all networks' names in the xawtv network name, separated by a slash. The slash is recognized as separator by nxtvepg (and hopefully future versions of xawtv) and all resulting segments can be used as network names.
} {} {Context menu...} bold {
Open the context menu configuration dialog which allows to add references to external commands to the context popup menu. (See also } {} {Context menu} href {.) At the top of the dialog window there is a list of all currently defined command titles. When you open the dialog for the first time, it'll be empty.
Below the list there are two text input fields which allow to modify or create new commands. The field labeled } {} {Title} bold { defines the text which will be included to the popup menu.  The field labeled } {} {Command} bold { defines the command line to be executed when the entry is selected in the popup menu, with possible placeholders enclosed in ${} which are replaced by parameters of the currently selected programme in the browser listbox. After the substitution and after appending an ampersand '&' sign to allow asynchronous execution (UNIX only), the command line is passed to a shell via the system(3) function.
When you press the menu button } {} {Copy Example} underlined { a list pops up which contains a few example commands which can be copied into the title and command entry fields.  To save a new or modified title and command, you have to press either the } {} {New} underlined { or } {} {Update} underlined { button and leave the popup with } {} {Ok} underlined {.  Use } {} {Delete} underlined { to remove an entry from the listbox; the buttons with up/down arrows to change the ordering.  Use } {} {Clear} underlined { to clear the entry fields, e.g. before you create a new entry.
The following is a list of formal variables (i.e. placeholders) which are substituted in the command line with parameters of the selected title upon invocation of the external command. The meaning of the variables should be self-explanatory, except possibly for CNI, which is a hexadecimal network code; and e/p_rating which are editorial and parental rating respectively.
   ${title} 
   ${network} 
   ${start} 
   ${stop} 
   ${relstart} 
   ${duration} 
   ${CNI} 
   ${description} 
   ${themes} 
   ${VPS}  or  ${PDC} 
   ${e_rating} 
   ${p_rating} 
   ${sound} 
   ${format} 
   ${digital} 
   ${encrypted} 
   ${live} 
   ${repeat} 
   ${subtitle} 
The keywords can be followed by a colon and an output format specification. In case of the start, stop and VPS/PDC times, all options defined in the } {} {strftime(3)} bold { manpage are available; default is %H:%M-%d.%m.%Y (hour, minute, day, month, year). In case of relative start time and duration, you can choose between minutes (default) and seconds by appending "m" or "s". For all other variables the modifiers are currently ignored.
The substrings which replace the formal variables are enclosed in single quotes to protect them from interpretation by the shell. Single quotes inside the substituted string are correctly escaped.
Example: The command line
   plan ${start:%d.%m.%Y %H:%M} ${title} 
could for example result in
   plan '22.08.2001 13:05' 'Kpt'\''n Blaubrs Seemannsgarn' 
to be passed to the Bourne Shell.
} {} {Filter shortcuts...} bold {
Open the filter shortcut dialog to rename, reorder or delete shortcuts.  You have to press the } {} {Update} underlined { button to save any changes for a shortcut and then close the dialog with } {} {Save} underlined {. See } {} {Filter shortcuts} href { for more details.
} {} {Show shortcuts} bold {
Toggle visibility of the shortcut listbox.
} {} {Show networks} bold {
Toggle visibility of the network filter listbox.
} {} {Show status line} bold {
Toggle visibility of the status line at the bottom of the browser window.
} {} {Show column headers} bold {
Toggle visibility of the browser listbox column header menu bar.
} {} }
