/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multibyte.h,v 1.1.2.2 1999/08/10 23:21:49 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */
/*
 * Misc entries that are publically available
 */

/*
 * check for various charsets.
 */
#define	iseuckanji(c)	(0xa1 <= (c) && (c) <= 0xfe)
#define	issjiskanji1(c)	((0x81 <= (c) && (c) <= 0x9f) || (0xe0 <= (c) && (c) <= 0xfc))
#define	issjiskanji2(c)	((0x40 <= (c) && (c) <= 0x7e) || (0x80 <= (c) && (c) <= 0xfc))
#define isjishankana(c)	(0xa1 <= (c) && (c) <= 0xdf)
#define isbig5mb1(c)	(0xa1 <= (c) && (c) <= 0xfe)
#define	isbig5mb2(c)	((0x40 <= (c) && (c) <= 0x7e) || (0xa1 <= (c) && (c) <= 0xfe))

/*
 * designation.
 */
#define isecma(c)	(0x30 <= (c) && (c) <= 0x7f)
#define SO	'\016'
#define SI	'\017'
#define SS2	((u_char)'\216')
#define SS3	((u_char)'\217')

/*
 * local type declarations.
 */
enum _cstype { CS94, CS96, CS9494, CS9696 };
typedef enum _cstype CSTYPE;

struct _charset {
	char	*name;		/* readable name */
	int	blen;		/* length in buffer including flagbyte */
	int	len;		/* width in appearance */

	/* mostly generic */
	u_int	(*chclass)();	/* function to get character class */
	enum _cstype type;	/* size of charset: 94/96/94x94/96x96 */

	/* specific to iso-2022-* */
	char	enter;		/* last char of designation */
	char	version;	/* version character */
	char	oldstyle;	/* old style: ESC $ x not ESC $ ( x */
	char	western;	/* western: need space between words */
};
typedef struct _charset CHARSET;

struct _encoding {
	char	*name;
	int	(*toint)();
	int	(*fromint)();
	void	(*keyinput)();
	int	(*display)();

	/* for iso-2022-* and euc-* */
	CHAR_T	initg0;
	CHAR_T	initg1;
	CHAR_T	initg2;
	CHAR_T	initg3;

	/* for iso-2022-* */
	int	maxcharset;	/* 1: G0 only  2: G0 and G1 ... */
	int	maxside;	/* 1: GL only  2: GL and GR */
	int	shifttype;	/* preferred shift type */
#define S_SI		0x0001	/*0F*/
#define S_SO		0x0002	/*0E*/
#define S_LS0		0x0001	/*0F*/
#define S_LS1		0x0002	/*0E*/
#define S_LS2		0x0004	/*ESC n*/
#define S_LS3		0x0008	/*ESC o*/
#define	S_SS2		0x0010	/*ESC N*/
#define	S_SS3		0x0020	/*ESC O*/
#define S_LS1R		0x0200	/*ESC ~*/
#define S_LS2R		0x0400	/*ESC }*/
#define S_LS3R		0x0800	/*ESC |*/
#define	S_SS2R		0x1000	/*8E*/
#define	S_SS3R		0x2000	/*8F*/
#define	S_NONE		0x0000
#define	S_0		0x0001
#define	S_1		0x0202
#define	S_2		0x1414
#define	S_3		0x2828
#define S_SEVEN_LOCK	0x000f
#define S_SEVEN_SINGLE	0x0030
#define S_SEVEN		0x003f
#define S_EIGHT_LOCK	0x0e00
#define S_EIGHT_SINGLE	0x3000
#define S_EIGHT		0x3e00
#define S_ALL		0x3e3f
#define S_EUC		0x3000
	int	(*recommendation)();
	int	flags;
#define	E_SOLRESET	0x0001	/* reset designation at begin of line */
#define	E_EOLRESET	0x0002	/* reset designations at end of line */
#define	E_NOOLDSTYLE	0x0004	/* should use ESC $ ( B for ESC $ [@AB] */
};
typedef struct _encoding ENCODING;

struct _iso2022state {
	CHARSET const *charsets[4];
	int	gl;
	int	gr;
};
typedef struct _iso2022state ISO2022STATE;

/*
 * multibyte flags.
 */
#define MB_MULTIBYTE	0x01	/* conversion contains multibyte char */
#define	MB_SKIP		0x02	/* conversion contains unencodable char */
#define	MB_RAW		0x04	/* conversion ocntains raw binary char */
#define	MB_JOIN		0x08	/* should join the line to the next line */

/*
 * global vars.
 */
/* multibyte.c */
extern ENCODING const encodingtab[];
extern CHARSET const charsettab[];

/*
 * function prototypes.
 *
 * We don't provide "PUBLIC:" comments since they shouldn't be reachable from
 * other functions.
 */

/* multibyte.c */
void multi_initstate __P((SCR *, ENCODING const *, ISO2022STATE *));

/* multi_chclass.c */
u_int jis0208_chclass __P((CHAR_T *, u_int));
u_int ksc5601_chclass __P((CHAR_T *, u_int));

/* multi_big5.c */
int big5_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int int_to_big5 __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
void big5_keyinput __P((SCR *, ENCODING const *, CHAR_T *, size_t, CHAR_T *, size_t *, int *, size_t *));
int big5_display __P((SCR *, ENCODING const *, CHAR_T *, CHAR_T *));

/* multi_euc.c */
#if 0
int euc_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int int_to_euc __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
#endif
int euc_recommendation __P((CHARSET const *, ENCODING const *));
#if 0
void euc_keyinput __P((SCR *, ENCODING const *, CHAR_T *, size_t, CHAR_T *, size_t *, int *, size_t *));
#endif
int euc_display __P((SCR *, ENCODING const *, CHAR_T *, CHAR_T *));

/* multi_eucjp.c */
#if 0
int int_to_eucjp __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
#endif
int eucjp_display __P((SCR *, ENCODING const *, CHAR_T *, CHAR_T *));

/* multi_euctw.c */
int euctw_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int int_to_euctw __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
void euctw_keyinput __P((SCR *, ENCODING const *, CHAR_T *, size_t, CHAR_T *, size_t *, int *, size_t *));
int euctw_display __P((SCR *, ENCODING const *, CHAR_T *, CHAR_T *));

/* multi_hz.c */
int hz_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int int_to_hz __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));

/* multi_iso2022.c */
int iso2022_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int int_to_iso2022 __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int iso2022kr_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int iso2022jp3_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int int_to_iso2022kr __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int iso2022cn_recommendation __P((CHARSET const *, ENCODING const *));
int iso2022jp_recommendation __P((CHARSET const *, ENCODING const *));
int iso2022kr_recommendation __P((CHARSET const *, ENCODING const *));
int ctext_recommendation __P((CHARSET const *, ENCODING const *));
void iso2022_keyinput __P((SCR *, ENCODING const *, CHAR_T *, size_t, CHAR_T *, size_t *, int *, size_t *));

/* multi_none.c */
int none_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int int_to_none __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
void none_keyinput __P((SCR *, ENCODING const *, CHAR_T *, size_t, CHAR_T *, size_t *, int *, size_t *));

/* multi_sjis.c */
int sjis_to_int __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
int int_to_sjis __P((SCR *, ENCODING const *, CHAR_T *, size_t *, CHAR_T *, size_t, int *, ISO2022STATE *));
void sjis_keyinput __P((SCR *, ENCODING const *, CHAR_T *, size_t, CHAR_T *, size_t *, int *, size_t *));
int sjis_display __P((SCR *, ENCODING const *, CHAR_T *, CHAR_T *));

/* multi_quail.c */
void quail_keyinput __P((SCR *, ENCODING const *, CHAR_T *, size_t, CHAR_T *, size_t *, int *, size_t *));

#ifdef CANNA
/* multi_canna.c */
void canna_keyinput __P((SCR *, ENCODING const *, CHAR_T *, size_t, CHAR_T *, size_t *, int *, size_t *));
#endif

/*
 * Charset id.
 */
#define	CS_NONE		0x00
#define	CS_INVALID	0x01
#define CS_RAW(x)	(CS_RAW0 <= (x) && (x) <= CS_RAW7)
#include "multibyte_def.h"

#define	MAX_MULTI_BLEN	3
#define	MAX_MULTI_LEN	7

#define	ischarset(ch)	(((ch) & 0x80) && ((ch) < CS_MAX))
#define	charset(ch)	charsettab[(ch) & 0x7f]
