/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multi_hz.c,v 1.1.2.1 1997/09/23 00:43:49 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */

#include "config.h"

#ifdef MULTIBYTE

#include <sys/types.h>
#include <sys/queue.h>

#include <bitstring.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/common.h"
#include "multibyte.h"

int
hz_to_int(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;
	u_short ch;
	CHAR_T cs;

	q = dst;
	p = src;
	if (pflags)
		FL_INIT(*pflags, 0);
	cs = CS_NONE;

	for (i = 0; i < slen; i++) {
		if (p[0] == '~') {
			if (i + 1 < slen && p[1] == '~') {
				/*
				 * Double tilde: escapes single tilde
				 */
				p += 2;
				if (dst)
					*q++ = '~';
				else
					q++;
				i++;	/*plus one at for loop*/
				if (pflags)
					FL_SET(*pflags, MB_MULTIBYTE);
				continue;
			}
			if (i + 1 < slen && p[1] == '{' && cs == CS_NONE) {
				/*
				 * tilde open-bracket: enter HZ
				 */
				p += 2;
				cs = CS_GB2312;
				i++;	/*plus one at for loop*/
				if (pflags)
					FL_SET(*pflags, MB_MULTIBYTE);
				continue;
			}
			if (i + 1 < slen && p[1] == '}' && cs == CS_GB2312) {
				/*
				 * tilde close: enter ASCII
				 */
				p += 2;
				cs = CS_NONE;
				i++;	/*plus one at for loop*/
				if (pflags)
					FL_SET(*pflags, MB_MULTIBYTE);
				continue;
			}
			if (i + 1 == slen) {
				/*
				 * tilde on EOL: join the line to the next one
				 */
				p++;
				if (pflags)
					FL_SET(*pflags, MB_MULTIBYTE|MB_JOIN);
				continue;
			}
		}
		if (cs == CS_GB2312) {
			if (! (0x21 <= p[0] && p[0] <= 0x7e
			    && 0x21 <= p[1] && p[1] <= 0x7e))
				goto raw;

			if (dst) {
				*q++ = cs;
				*q++ = *p++;
				*q++ = *p++;
			} else {
				q += 3;
				p += 2;
			}
			i++;	/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		
raw:
		/*
		 * ASCII and other binary chars.
		 */
		if (p[0] & 0x80) {
			if (dst) {
				*q++ = CS_RAW0 + v_key_len(sp, p[0]);
				*q++ = *p++ & 0x7f;
			} else {
				q += 2;
				p++;
			}
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_RAW);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}

int
int_to_hz(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;
	u_short ch;
	CHAR_T cs;

	if (pflags)
		FL_INIT(*pflags, 0);
	q = dst;
	p = src;
	cs = CS_NONE;

	for (i = 0; i < slen; i++) {
		if (p[0] == CS_GB2312) {
			if (cs != CS_NONE) {
				if (dst) {
					*q++ = '~';
					*q++ = '{';
				} else
					q += 2;
				cs = CS_GB2312;
			}

			if (dst) {
				p++;
				*q++ = *p++;
				*q++ = *p++;
			} else {
				p += 3;
				q += 2;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if ((p[0] & 0x80) && !CS_RAW(p[0])) {
			/*
			 * Unknown encoding.  Simply skip them.
			 */
			p += charset(p[0]).blen;
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_SKIP);
			continue;
		}

		if (cs != CS_NONE) {
			if (dst) {
				*q++ = '~';
				*q++ = '}';
			} else
				q += 2;
			cs = CS_NONE;
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
		}

		if (CS_RAW(p[0])) {
			if (dst) {
				*q++ = p[1] | 0x80;
				p += 2;
			} else {
				q++;
				p += 2;
			}
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_RAW);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (cs != CS_NONE) {
		if (dst) {
			*q++ = '~';
			*q++ = '}';
		} else
			q += 2;
		cs = CS_NONE;
		if (pflags)
			FL_SET(*pflags, MB_MULTIBYTE);
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}
#endif /*MULTIBYTE*/
