/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multi_euctw.c,v 1.1.2.1 1997/09/23 00:43:49 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */

#include "config.h"

#ifdef MULTIBYTE

#include <sys/types.h>
#include <sys/queue.h>

#include <bitstring.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/common.h"
#include "multibyte.h"

int
euctw_to_int(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;
	static CHAR_T cnstab[] = {
		0,					/*0xa0*/
		CS_CNS11643_1, CS_CNS11643_2,
		CS_CNS11643_3, CS_CNS11643_4,
		CS_CNS11643_5, CS_CNS11643_6,
		CS_CNS11643_7
	};
#define	iscnscode(x)	\
	(0xa0 <= (x)							\
		&& (x) < 0xa0 + sizeof(cnstab)/sizeof(cnstab[0])	\
		&& cnstab[(x) - 0xa0])
#define	cnscode(x)	cnstab[(x) - 0xa0]

	q = dst;
	p = src;
	if (pflags)
		FL_INIT(*pflags, 0);

	for (i = 0; i < slen; i++) {
		if (i + 1 < slen && iseuckanji(p[0]) && iseuckanji(p[1])) {
			if (dst) {
				*q++ = CS_CNS11643_1;
				*q++ = *p++ & 0x7f;
				*q++ = *p++ & 0x7f;
			} else {
				q += 3;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (i + 3 < slen && p[0] == 0x8e && iscnscode(p[1])
		 && iseuckanji(p[2]) && iseuckanji(p[3])) {
			if (dst) {
				p++;
				*q++ = cnscode(*p); p++;
				*q++ = *p++ & 0x7f;
				*q++ = *p++ & 0x7f;
			} else {
				q += 3;
				p += 4;
			}
			i += 3;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}

raw:
		/*
		 * ASCII and other binary encodings.
		 */
		if (p[0] & 0x80) {
			if (dst) {
				*q++ = CS_RAW0 + v_key_len(sp, *p);
				*q++ = *p & 0x7f;
				p++;
			} else {
				q += 2;
				p++;
			}
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_RAW);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
#undef iscnscode
#undef cnscode
}

int
int_to_euctw(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;
	static CHAR_T cnstab[] = {
		CS_CNS11643_1, CS_CNS11643_2,
		CS_CNS11643_3, CS_CNS11643_4,
		CS_CNS11643_5, CS_CNS11643_6,
		CS_CNS11643_7
	};
	static CHAR_T cnscode[] =  {
		0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7
	};
	int cnsidx;

	if (pflags)
		FL_INIT(*pflags, 0);
	q = dst;
	p = src;

	for (i = 0; i < slen; i++) {
		if (CS_RAW(p[0])) {
			if (dst) {
				*q++ = p[1] | 0x80;
				p += 2;
			} else {
				q++;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_RAW);
			continue;
		}
		if (p[0] == CS_CNS11643_1) {
			if (dst) {
				p++;
				*q++ = *p++ | 0x80;
				*q++ = *p++ | 0x80;
			} else {
				q += 2;
				p += 3;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}

		/*
		 * special processing for G2 charsets....
		 */
		cnsidx = -1;
	    {
		size_t t;
		for (t = 0;
		     t < sizeof(cnscode)/sizeof(cnscode[0]);
		     t++) {
			if (p[0] == cnstab[t]) {
				cnsidx = t;
				break;
			}
		}
	    }
		if (cnsidx != -1) {
			if (dst) {
				p++;
				*q++ = cnscode[cnsidx];
				*q++ = *p++ | 0x80;
				*q++ = *p++ | 0x80;
			} else {
				q += 3;
				p += 2;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}

		if (p[0] & 0x80) {
			/*
			 * Unknown encoding.  Simply skip them.
			 */
			p += charset(p[0]).blen;
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_SKIP);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}

void
euctw_keyinput(sp, e, kbuf, kbuflen, intbuf, pintbuflen, pstate, pconsumed)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *kbuf;
	size_t kbuflen;
	CHAR_T *intbuf;
	size_t *pintbuflen;
	int *pstate;
	size_t *pconsumed;
{
	size_t i;
	size_t j;
	size_t consumed;
	static CHAR_T cnstab[] = {
		0,					/*0xa0*/
		CS_CNS11643_1, CS_CNS11643_2,
		CS_CNS11643_3, CS_CNS11643_4,
		CS_CNS11643_5, CS_CNS11643_6,
		CS_CNS11643_7
	};
#define	iscnscode(x)	\
	(0xa0 <= (x)						\
		&& (x) < sizeof(cnstab)/sizeof(cnstab[0])	\
		&& cnstab[(x) - 0xa0])
#define	cnscode(x)	cnstab[(x) - 0xa0]

	i = j = consumed = 0;
	while (i < kbuflen) {
		/*
		 * Kanji cases.
		 */
		if (i + 1 < kbuflen
		 && iseuckanji(kbuf[i]) && iseuckanji(kbuf[i + 1])) {
			/*
			 * we got G1 char.
			 */
			intbuf[j++] = CS_CNS11643_1;
			intbuf[j++] = kbuf[i++] & 0x7f;
			intbuf[j++] = kbuf[i++] & 0x7f;
			*pstate = 0;
			consumed += 2;
		} else if (i + 2 < kbuflen
		 && kbuf[i] == 0x8e && iscnscode(kbuf[i + 1])
		 && iseuckanji(kbuf[i + 2]) && iseuckanji(kbuf[i + 3])) {
			/*
			 * we got G2 char.
			 */
			intbuf[j++] = cnscode(kbuf[i + 1]);
			intbuf[j++] = kbuf[i + 2] & 0x7f;
			intbuf[j++] = kbuf[i + 3] & 0x7f;
			i += 4;
			*pstate = 0;
			consumed += 4;
		} else if (i + 1 == kbuflen && iseuckanji(kbuf[i])) {
			/*
			 * Only the firstbyte for G1 char is available.
			 * Keep this kanji char till next round.
			 */
			i++;
			*pstate = 1;
		} else if (i + 1 == kbuflen && kbuf[i] == 0x8e) {
			/*
			 * Only the firstbyte for G2 char is available.
			 * Keep this kanji char till next round.
			 */
			i++;
			*pstate = 2;
		} else if (i + 2 == kbuflen && kbuf[i] == 0x8e
		 && iscnscode(kbuf[i + 1])) {
			/*
			 * Only the first/second byte for G2 char are
			 * available.
			 * keep them till next round.
			 */
			i += 2;
			*pstate = 3;
		} else if (i + 3 == kbuflen && kbuf[i] == 0x8e
		 && iscnscode(kbuf[i + 1]) && iseuckanji(kbuf[i + 2])) {
			/*
			 * Only the first/second/third byte for G2 char are
			 * available.
			 * keep them till next round.
			 */
			i += 3;
			*pstate = 4;
		}

		/*
		 * Non-kanji cases.
		 */
		else if (kbuf[i] & 0x80) {
			intbuf[j++] = CS_RAW0 + v_key_len(sp, kbuf[i]);
			intbuf[j++] = kbuf[i] & 0x7f;
			i++;
			*pstate = 0;
			consumed++;
		} else {
			intbuf[j++] = kbuf[i++];
			*pstate = 0;
			consumed++;
		}
	}
	*pintbuflen = j;
	*pconsumed = consumed;
#undef iscnscode
#undef cnscode
}

int
euctw_display(sp, e, name, p)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *name;
	CHAR_T *p;
{
	if (p[0] == CS_CNS11643_1) {
		name[0] = p[1] | 0x80;
		name[1] = p[2] | 0x80;
		name[2] = '\0';
		return 1;
	}
	return 0;
}
#endif /*MULTIBYTE*/
