/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 2000 David Baum.
 * All Rights Reserved.
 */

#include "EventSrcExpr.h"
#include "Bytecode.h"
#include "Error.h"


Expr* EventSrcExpr::Clone(Mapping *b) const
{
	return new EventSrcExpr(fExpr->Clone(b));
}


RCX_Value EventSrcExpr::EmitAny_(Bytecode &) const
{
	int v;
	
	if (!Evaluate(v))
		return kIllegalEA;

	return RCX_VALUE(kRCX_ConstantType, v);
}


bool EventSrcExpr::Evaluate(int &v) const
{
	RCX_Value ea;

	ea = fExpr->GetStaticEA();
	v = -1;

	if (ea != kIllegalEA)
	{
		int d = RCX_VALUE_DATA(ea);
		
		switch(RCX_VALUE_TYPE(ea))
		{
			case kRCX_InputValueType:
				if (d >= 0 && d <=2)
					v = d;
				break;
			case kRCX_TimerType:
				if (d >=0 && d <= 3)
					v = 3 + d;
				break;
			case kRCX_MessageType:
				if (d == 0)
					v = 7;
				break;
			case 21:	// counter type
				if (d >=0 && d <= 2)
					v = 8 + d;
				break;
			default:	// don't do anything...just prevent warnings
				break;
		}
	}

	if (v==-1)
	{
		Error(kErr_BadEventSource).Raise(&GetLoc());
	}
	
	return true;
}
