/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 2000 David Baum.
 * All Rights Reserved.
 */

#ifndef __BinaryBaseExpr_h
#define __BinaryBaseExpr_h

#include "Expr.h"

class BinaryBaseExpr : public Expr
{
public:
			BinaryBaseExpr(Expr *lhs, Expr *rhs);
			~BinaryBaseExpr();
			
	virtual bool		PromiseConstant() const;
	virtual bool		Contains(int var) const;
	virtual bool		EmitSide_(Bytecode &b) const;
	virtual void		GetExprs(vector<Expr*> &v) const;
	
protected:
	Expr*		fLeft;
	Expr*		fRight;
};


#endif
