/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */

#include "SRecord.h"

#define kMaxLine	256


bool SRecord::Read(FILE *fp, int maxLength)
{
	char line[kMaxLine];
	char *ptr;
	int length = 0;
	int dataLen;
	int byte;
	
	delete [] fData;
	fData = new UByte[maxLength];
	fLength = 0;
	
	while(fgets(line, kMaxLine, fp))
	{
		ptr = line;
		if (*ptr == 10 || *ptr==13) // hack for DOS line endings
			ptr++;
		
		if (ptr[0] == 0) continue;
		
		if (ptr[0] != 'S')
			return false;

		if (ptr[1] == '1')
		{
			// data line
			dataLen = ReadHexByte(ptr + 2);
			if (dataLen < 3) return false;

			ptr += 8;
			for(int i=0; i<dataLen-3; i++)
			{
				if (length == maxLength) return false;
				byte = ReadHexByte(ptr);
				ptr += 2;
				if (byte == -1) return 0;
				fData[length++] = (UByte)byte;
			}
		}
		else if (ptr[1] == '9')
		{
			// start address
			dataLen = ReadHexByte(ptr + 2);
			if (dataLen != 3) return false;
			
			fStart = (ReadHexByte(ptr+4) << 8) + ReadHexByte(ptr+6);
		}
	}

	fLength = length;
	return true;
}


int SRecord::ReadHexByte(const char *ptr)
{
	int i;
	int v = 0;
	char c;
	int n;
	
	for(i=0; i<2; i++)
	{
		c = *ptr++;
	
		if (c >= '0' && c <= '9')
			n = c - '0';
		else if (c >= 'A' && c <= 'F')
			n = c - 'A' + 10;
		else if (c >= 'a' && c <= 'f')
			n = c - 'a' + 10;
		else
			return -1;
			
		v = (v << 4) + n;	
	}
	
	return v;
}
