package Memories::Config;
# PATHS AND URLS

# This parameter should be the external address of your Memories
# installation
Memories->config->uri_base("http://memories.simon-cozens.org/");

# This is where your templates will live.
Memories->config->{template_root} = "/home/simon/maypole-sites/memories/templates";

# Here is where uploaded photos will be stored. Your web server user
# should own this directory.
Memories->config->{data_store} = "/web/photostore/";

# You also need to configure your web server so that it serves files out
# of the data store; this URL should be where that data store directory
# is exposed on the web.
Memories->config->{data_store_external} = "http://memories.simon-cozens.org/store/";

# Your database server: the first part should always be "dbi"; the
# second, the name of the DBD driver you're using (usually mysql unless
# you want to do your own thing); the final part, the name of the
# database.
#
# Initialize this database from memories.sql and give www-data (or
# equivalent) read/write access to all tables.
Memories->config->{dsn} = "dbi:mysql:memories";

# SESSION MANAGEMENT
#
# The name of any cookies this application should give out
Memories->config->{auth}{cookie_name} = "memories";

# Session file storage. Create these directories and have them owned by
# www-data
Memories->config->{auth}{session_args} = {
        Directory => "/var/lib/memories/sessions",
        LockDirectory => "/var/lib/memories/sessionlock",
    };

# DISPLAY PARAMETERS
#
# It's OK to leave these as they are.
# 
# The size of thumbnails to generate
Memories->config->{thumb_size} = "90x90";

# Sizes you want to scale to. "full" is special.
Memories->config->{sizes} = 
    [ qw/ 150x100 300x200 640x480 800x600 1024x768 1280x1024 full /];

# Number of photos on a page. It's best if this is a multiple of three
Memories->config->{photos_per_page} = 21;

1;
