/*
 *    Copyright (C) 1999-2002 Stijn van Dongen.
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>

#include "key.h"
#include "read.h"
#include "util.h"

#include "util/txt.h"
#include "util/file.h"
#include "util/minmax.h"
#include "util/types.h"
#include "util/array.h"
#include "util/hash.h"


const char *strPredefines
=
   "\\device         name of device (given by -d)\n"
   "\\base           base name of entry file (given by -i)\n"
   "\\file           name of current file\n"
;

static   mcxHash*    usrTable_g        =  NULL;    /* user keys         */


void yamKeyList
(  const char* mode
)
   {  mcxbool listAll = strstr(mode, "all") != NULL
   ;  if (listAll || strstr(mode, "session"))  
      {  fprintf(stdout, "\nPredefined session variables\n%s", strPredefines)
   ;  }
;  }


void  yamKeySet
(
   const char* key
,  const char* val
)
   {
      mcxTing*  keytxt   =  mcxTingNew(key)

   ;  if (yamKeyInsert(keytxt, val) != keytxt)
      {  fprintf
         (  stderr
         ,  "[yamKeySet] overwriting key <%s>\n"
         ,  keytxt->str
         )
      ;  mcxTingFree(&keytxt)
   ;  }
;  }


mcxTing* yamKeyInsert
(
   mcxTing*        key
,  const char*    valstr
)
   {
      mcxKV* kv   =  mcxHashSearch
                     (  key
                     ,  usrTable_g
                     ,  MCX_DATUM_INSERT
                     )
   ;  if (!kv)
      yamExit("yamKeyInsert", "panic &or PBD cannot insert key")

   ;  else
      {
         if (kv->val)
         mcxTingWrite((mcxTing*) (kv->val), valstr)
      ;  else
         kv->val     =  mcxTingNew(valstr)
   ;  }

   ;  return (mcxTing*) kv->key
;  }


mcxTing* yamKeyGet
(  mcxTing*  key
)  {
      mcxKV*   kv
      =  (mcxKV*) mcxHashSearch
         (  key
         ,  usrTable_g
         ,  MCX_DATUM_FIND
         )
   ;  return kv ? (mcxTing*) kv->val : NULL
;  }


void yamKeyInitialize
(  int n
)
   {  usrTable_g           =  mcxHashNew(n, mcxTingHash, mcxTingCmp)
;  }


void yamKeyStats
(  void
)  {  mcxHashStats(usrTable_g)
;  }

