/*
 *    Copyright (C) 1999-2002 Stijn van Dongen.
*/

#include "digest.h"
#include "filter.h"
#include "parse.h"
#include "util.h"

#include "util/txt.h"

/*
 *    creates successively new segs, and these segs
 *    and their content will be freed. The input txt is left
 *    alone however, and is responsibility of caller.
*/

void yamOutput
(
   mcxTing        *txtin
,  int            filter(yamFilterData* fd, mcxTing* txt, int offset, int length)
,  yamFilterData*   fd
)
   {
      yamSeg   *seg
   ;  int      offset

   ;  if (!txtin)
      yamExit("yamOutput", "[yamOutput PBD] void argument")

   ;  seg                  =  yamSegPush(NULL, txtin)
   ;  offset               =  seg->offset

   ;  while(seg)
      {
         int  prev_offset  =  seg->offset
      ;  yamSeg* prev_seg  =  seg

      ;  if ((offset = findkey(seg)) >= 0)
         {
            if (filter && fd && fd->fp)
            filter(fd, seg->txt, prev_offset, offset - prev_offset)

         ;  seg  =  dokey(seg)
      ;  }

         else
         {
            if (filter && fd && fd->fp)
            filter(fd, seg->txt, prev_offset, seg->txt->len - prev_offset)

         ;  seg  =  seg->prev
         ;  yamSegFree(&prev_seg)
      ;  }
   ;  }
;  }


mcxTing*  yamDigest
(
   mcxTing      *txtin
,  mcxTing      *txtout
)
   {
      yamSeg      *seg
   ;  int         offset

   ;  mcxTing*     txt     = (txtin == txtout) ? NULL : txtout
   ;  txt                  =  mcxTingEmpty(txt, 30)

   ;  if (!txtin)
      yamExit("yamDigest", "[yamDigest PBD] void argument")

   ;  seg                  =  yamSegPush(NULL, txtin)
   ;  offset               =  seg->offset

   ;  while(seg)
      {
         int prev_offset   =  seg->offset
      ;  yamSeg* prev_seg  =  seg

      ;  if ((offset = findkey(seg)) >= 0)
         {
            mcxTingNAppend
            (  txt
            ,  seg->txt->str+prev_offset
            ,  offset - prev_offset
            )
         ;  seg            =  dokey(seg)
      ;  }

         else
         {
            mcxTingNAppend
            (  txt
            ,  seg->txt->str+prev_offset
            ,  seg->txt->len - prev_offset
            )
         ;  seg                =  seg->prev
         ;  yamSegFree(&prev_seg)
      ;  }
   ;  }

   ;  if (txtout == txtin)
      {  
         mcxTingWrite(txtin, txt->str)
      ;  mcxTingFree(&txt)
      ;  return txtin
   ;  }

   ;  return txt
;  }

