/*
madman - a music manager
Copyright (C) 2003  Andreas Kloeckner <ak@ixion.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/




#include <qsize.h>
#include <qvbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qfont.h>
#include <qapplication.h>
#include "ui/passive_popup.h"




tPassivePopup	*tPassivePopup::CurrentPopup = NULL;




tPassivePopup::tPassivePopup(const QString &text, unsigned msec)
  : ShownMilliseconds(msec)
{
  if (CurrentPopup)
    delete CurrentPopup;
  CurrentPopup = this;

  QVBox *vbox = new QVBox(NULL, "passive_popup", Qt::WStyle_NoBorder | Qt::WX11BypassWM | Qt::WStyle_StaysOnTop);
  Widget = vbox;
  vbox->setFrameShape(QFrame::Panel);
  vbox->setFrameShadow(QFrame::Raised);
  vbox->setMargin(5);
  vbox->setSpacing(9);

  QPushButton *button = new QPushButton(tr("Hide"), Widget);
  connect(button, SIGNAL(clicked()), this, SLOT(deleteLater()));

  QLabel *label = new QLabel(text, Widget);
  QFont my_font = label->font();
  if (my_font.pixelSize() < 0)
    my_font.setPointSizeFloat(my_font.pointSizeFloat() * 1.5);
  else
    my_font.setPixelSize(int(my_font.pixelSize() * 1.5));
  my_font.setBold(true);
  label->setFont(my_font);
  label->setAlignment(Qt::AlignHCenter);

  QDesktopWidget *d = QApplication::desktop();
  QSize sizehint = Widget->sizeHint();
  Widget->move(QPoint(
	(d->width() - sizehint.width()) / 2, - sizehint.height()));
  StateMilliseconds = 0;
  TotalStateMilliseconds = 300;
  State = APPEARING;
  Widget->show();

  connect(&MyTimer, SIGNAL(timeout()), this, SLOT(timer()));
  MyTimer.start(20, false);
}




tPassivePopup::~tPassivePopup()
{
  delete Widget;
  CurrentPopup = NULL;
}




void tPassivePopup::timer()
{
  QDesktopWidget *d = QApplication::desktop();
  QSize sizehint = Widget->sizeHint();

  StateMilliseconds += 10;
  if (StateMilliseconds > TotalStateMilliseconds)
  {
    StateMilliseconds = 0;
    switch (State)
    {
      case APPEARING:
	State = SHOWING;
	Widget->move(QPoint((d->width() - sizehint.width()) / 2, 0));
	TotalStateMilliseconds = ShownMilliseconds;
	break;
      case SHOWING:
	State = DISAPPEARING;
	TotalStateMilliseconds = 300;
	break;
      case DISAPPEARING:
	Widget->hide();
	deleteLater();
    }
  }
  switch (State)
  {
    case APPEARING:
      Widget->move(QPoint((d->width() - sizehint.width()) / 2, 
	    - sizehint.height() * (TotalStateMilliseconds-StateMilliseconds) / TotalStateMilliseconds));
      break;
    case DISAPPEARING:
      Widget->move(QPoint((d->width() - sizehint.width()) / 2, 
	    - sizehint.height() * StateMilliseconds / TotalStateMilliseconds));
      break;
    default:
      break;
  }
}

