#! /bin/sh -e
#
# Defaults
RUNDIR_TEMPLATE="/usr/share/m17n-env/xsession.d"
RUNDIR_ACTIVE="$HOME/.xsession.d"
RUNDIR_MENUCOM="whiptail"
RUNDIR_TITLE="Activate ~/.xsession.d/* script snippets"
RUNDIR_MESSAGE="Activate your choices of X programs started automatically. 
This is achieved through creating files in ~/.xsession.d/ which is Desktop
neutral.  Only the first X input method setting choices ([0-9][0-9]im-*) 
will be selected. You can manually add/remove user created entries to 
the following list by adding/removing files in ~/.xsession.d/* . 
If not sure, select template \"10auto-start\" only and learn how this 
works by editing the installed file."

RUNDIR_H_W_MH="23 78 10"

# Use common run-parts commands selection method
. /usr/share/m17n-env/bin/set-select-parts
. /usr/share/m17n-env/bin/set-force-default
. /usr/share/m17n-env/bin/set-select-im
. /usr/share/m17n-env/bin/set-run-parts

# If UIM, set $HOME/.uim
if parts_active $RUNDIR_ACTIVE | grep -e "^[0-9][0-9]?im-uim$" 2>/dev/null >/dev/null ; then
  . /usr/share/m17n-env/bin/set-uim
fi

# Check IM
case $( parts_active $RUNDIR_ACTIVE | sed -n -e 's/^[0-9][0-9]?im-\(.*\)$/\1/p' ) in
  scim)
    scim --help >/dev/null || echo "Install scim package and related packages."
  ;;
  uim)
    uim-xim --help >/dev/null || echo "Install uim-common package."
  ;;
  kinput2)
    kinput2 -version >/dev/null || echo "Install one of (kinput2-canna, kinput2-wnn, kinput2-canna-wnn) packages."
  ;;
esac

