#!/bin/sh

. /usr/local/etc/rc.subr

name=spfmilter
rcvar=`set_rcvar`

command=/usr/local/sbin/spfmilter

start_precmd=start_precmd

start_precmd()
{
	if [ -S "$spfmilter_socket" ]; then
		warn "Stale socket $spfmilter_socket removed."
		rm "$spfmilter_socket"
	fi
}

# Set defaults.
spfmilter_enable=${spfmilter_enable:-"NO"}
spfmilter_socket=${spfmilter_socket:-"/var/run/spfmilter.sock"}
spfmilter_flags=${spfmilter_flags:-""}

load_rc_config $name

# Add socket to any given argument.
spfmilter_flags="${spfmilter_flags} ${spfmilter_socket}"
run_rc_command "$1"
