#include <string.h>
#include <libnjb.h>
#include <getopt.h>

extern int njb_error;

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	extern char *optarg;
	int opt;
	int n, debug;
	datafile_t *filetag;
	char *lang;

	debug= 0;
	while ( (opt= getopt(argc, argv, "D:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		default:
			fprintf(stderr, "usage: tracks [ -D debuglvl ]\n");
			return 1;
		}
	}

	if ( debug ) NJB_Set_Debug(debug);

	/*
	 * Check environment variables $LANG and $LC_CTYPE
	 * to see if we want to support UTF-8 unicode
	 * $LANG = "xx_XX.UTF-8" or $LC_CTYPE = "?"
	 * trigger unicode support.
	 */
	lang = getenv("LANG");
	if (lang != NULL) {
	  if (strlen(lang) > 5) {
	    if (!strcmp(&lang[strlen(lang)-5], "UTF-8")) {
	       NJB_Set_Unicode(NJB_UC_UTF8);
	    }
	  }
	}

	if ( NJB_Discover(njbs, 0, &n) == -1 ) njb_error_dump(stderr);

	if ( n == 0 ) {
		fprintf(stderr, "no NJB devices found\n");
		return 0;
	} 

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	if ( NJB_Capture(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	NJB_Reset_Get_Datafile_Tag(njb);
	while ( (filetag = NJB_Get_Datafile_Tag (njb)) ) {
		datafile_dump(filetag, stdout);
		printf("----------------------------------\n");
	}
	if ( njb_error != EO_EOM ) njb_error_dump(stderr);

	NJB_Release(njb);

	NJB_Close(njb);
	return 0;
}

