//start of LhaOutputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LhaOutputStream.java
 * 
 * Copyright (C) 2001-2002 Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;
import jp.gr.java_conf.dangan.io.GrowthByteBuffer;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;


//import exceptions
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import java.lang.Error;


/**
 * ڑꂽXg[ kf[^o͂邽߂̃[eBeBNXB<br>
 * java.util.zip.ZipOutputStream ƎC^[tFCX悤ɍB
 * ZipƈႢALHȀo͖͂{ 2pXł邽߁A1̃Ggk܂ŁA
 * GgŜ̃f[^ꎞL̈悪KvƂȂB
 * ̂悤ȋL̈gpȂꍇ LhaRetainedOutputStream 
 * LhaImmediateOutputStream gp鎖B<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LhaOutputStream.java,v $
 * Revision 1.1.2.2  2005/05/03 07:48:40  dangan
 * [bug fix]
 *     k@ʎq -lhd- w肵AkTCYIWiTCYȂ߁A
 *     K -lh0- ɍĐݒ肳ĂB̂߃fBNgi[łȂB
 *
 * Revision 1.1.2.1  2005/04/29 02:14:28  dangan
 * [bug fix]
 *     k@ʎq -lhd- w肵AkTCYIWiTCYȂ߁A
 *     K -lh0- ɍĐݒ肳ĂB̂߃fBNgi[łȂB
 *
 * Revision 1.1  2002/12/08 00:00:00  dangan
 * [maintenance]
 *     LhaConstants  CompressMethod ւ̃NX̕ύXɍ킹ďCB
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [change]
 *     RXgN^  String encode ̂p~A
 *     Properties Ɏ̂ǉB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1.2.2 $
 */
public class LhaOutputStream extends OutputStream{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private OutputStream out
    //------------------------------------------------------------------
    /**
     * kf[^o͂Xg[
     */
    private OutputStream out;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  to compress a file
    //------------------------------------------------------------------
    //  private CRC16 crc
    //  private Temporary temp
    //  private LhaHeader header
    //  private OutputStream tempOut
    //  private long length
    //------------------------------------------------------------------
    /**
     * CRC16lZopNX
     */
    private CRC16 crc;

    /**
     * ꎞLpIuWFNg
     */
    private Temporary temp;

    /**
     * ݈k̃Gg̃wb_
     */
    private LhaHeader header;

    /**
     * ݈k̃Gg̈kpo̓Xg[
     */
    private OutputStream tempOut;

    /**
     * ݈kGg̈kÕf[^̒
     */
    private long length;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  property
    //------------------------------------------------------------------
    //  private Properties property
    //------------------------------------------------------------------
    /**
     * ek`ɑΉ̐܂܂vpeB
     */
    private Properties property;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LhaOutputStream()
    //  public LhaOutputStream( OutputStream out )
    //  public LhaOutputStream( OutputStream out, Properties property )
    //  public LhaOutputStream( OutputStream out, RandomAccessFile file )
    //  public LhaOutputStream( OutputStream out, RandomAccessFile file,
    //                          Properties property )
    //  private void constructerHelper( OutputStream out, Temporary temp,
    //                          Properties property )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^
     * gps
     */
    private LhaOutputStream(){  }

    /**
     * out  kf[^o͂OutputStream\zB<br>
     * ꎞޔ@\̓gpB̂߁A
     * kf[^ʂʂ𒴂悤ȃt@C͈kłȂB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param out kf[^o͂Xg[
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaOutputStream( OutputStream out ){

        if( out != null ){

            Properties property = LhaProperty.getProperties();
            this.constructerHelper( out, new TemporaryBuffer(), property );         //throws UnsupportedEncodingException

        }else{
            throw new NullPointerException( "out" );
        }
    }

    /**
     * out  kf[^o͂OutputStream\zB<br>
     * ꎞޔ@\̓gpB̂߁A
     * kf[^ʂʂ𒴂悤ȃt@C͈kłȂB<br>
     * 
     * @param out      kf[^o͂Xg[
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @see LhaProperty
     */
    public LhaOutputStream( OutputStream out, Properties property ){

        if( out      != null
         && property != null ){

            this.constructerHelper( out, new TemporaryBuffer(), property );         //throws UnsupportedEncodingException

        }else if( out == null ){
            throw new NullPointerException( "out" );
        }else{
            throw new NullPointerException( "property" );
        }
    }

    /**
     * out  kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param out   kf[^o͂Xg[
     * @param file  RandomAccessFile ̃CX^XB<br>
     *          <ul>
     *            <li> close() ĂȂB
     *            <li>RXgN^ mode ɂ "rw" IvVgpāA
     *                ǂ݂݂Ə݂o悤ɐꂽCX^Xł邱ƁB
     *          </ul>
     *          ̏𖞂́B
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaOutputStream( OutputStream out, RandomAccessFile file ){

        if( out      != null
         && file     != null ){

            Properties property = LhaProperty.getProperties();
            this.constructerHelper( out, new TemporaryFile( file ), property ); //throws UnsupportedEncodingException

        }else if( out == null ){
            throw new NullPointerException( "out" );
        }else{
            throw new NullPointerException( "file" );
        }
    }

    /**
     * out  kf[^o͂OutputStream\zB<br>
     * 
     * @param out      kf[^o͂Xg[
     * @param file     RandomAccessFile ̃CX^XB<br>
     *            <ul>
     *              <li> close() ĂȂB
     *              <li>RXgN^ mode ɂ "rw" IvVgpāA
     *                  ǂ݂݂Ə݂o悤ɐꂽCX^Xł邱ƁB
     *            </ul>
     *            ̏𖞂́B
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception UnsupportedEncodingException
     *               encode T|[gȂꍇ
     * 
     * @see LhaProperty
     */
    public LhaOutputStream( OutputStream     out, 
                            RandomAccessFile file, 
                            Properties       property ){

        if( out      != null
         && file     != null 
         && property != null ){

            this.constructerHelper( out, new TemporaryFile( file ), property );     //throws UnsupportedEncodingException

        }else if( out == null ){
            throw new NullPointerException( "out" );
        }else if( file == null ){
            throw new NullPointerException( "file" );
        }else{
            throw new NullPointerException( "property" );
        }
    }

    /**
     * RXgN^̏S郁\bhB
     * 
     * @param out    LHAɌ`̃f[^o͂o̓Xg[
     * @param temp   kf[^̈ꎞޔ@\
     * @param encode wb_̕ϊ̂Ɏgp
     *               GR[h{ł VtgJIS(SJIS,MS932,
     *               CP932)gp鎖
     * 
     * @exception UnsupportedEncodingException
     *               encode T|[gȂꍇ
     */
    private void constructerHelper( OutputStream out,
                                    Temporary    temp,
                                    Properties   property ){
        this.out      = out;
        this.temp     = temp;
        this.property = property;

        this.crc     = new CRC16();
        this.header  = null;
        this.tempOut = null;
    }

    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void write( int data )
    //  public void write( byte[] buffer )
    //  public void write( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * ݂̃Gg1oCg̃f[^ށB<br>
     * 
     * @param data ރf[^
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( int data ) throws IOException {
        if( this.tempOut != null ){
            if( this.header != null ){
                crc.update( data );
            }

            this.tempOut.write( data );
            this.length++;
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * ݂̃Gg buffer̓eSďoB<br>
     * 
     * @param buffer of[^̓oCgz
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( byte[] buffer ) throws IOException {
        this.write( buffer, 0, buffer.length );
    }

    /**
     * ݂̃Gg buffer index lengthoCg̃f[^oB<br>
     * 
     * @param buffer of[^̓oCgz
     * @param index  buffeȑoׂf[^̊Jnʒu
     * @param length f[^̃oCg
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( byte[] buffer, int index, int length ) throws IOException {
        if( this.tempOut != null ){
            if( this.header != null ){
                crc.update( buffer, index, length );
            }

            this.tempOut.write( buffer, index, length );
            this.length += length;
        }else{
            throw new IOException( "no entry" );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * flush ͓̓sB
     * ͌ݏݒ̃Gg̃f[^ 
     * ꎞޔ@\ɑ肱ނ悤ɎwB
     *  PostLzssDecoderALzssOutputStream 
     * ̋Kǂ flush() Ȃꍇ
     * f[^o͂鎖ۏ؂ȂB
     *  ۂ̏o͐ flush() B
     * 
     * @exception IOException o̓G[ꍇ
     *
     * @see PostLzssEncoder#flush()
     * @see LzssOutputStream#flush()
     */
    public void flush() throws IOException {
        if( this.tempOut != null ){
            this.tempOut.flush();                                               //throws IOException
        }

        if( this.tempOut != this.out ){
            this.out.flush();                                                   //throws IOException
        }
    }

    /**
     * o͐ɑSẴf[^o͂A
     * Xg[B
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        if( this.tempOut != null ){
            this.closeEntry();                                                  //throws IOException
        }

        //^[~l[^o
        this.out.write( 0 );                                                    //throws IOException
        this.out.close();                                                       //throws IOException
        this.out  = null;

        this.temp.close();
        this.temp = null;

        this.property = null;
        this.crc      = null;
        this.header   = null;
    }


    //------------------------------------------------------------------
    //  original method ( on the model of java.util.zip.ZipOutputStream  )
    //------------------------------------------------------------------
    //  manipulate entry
    //------------------------------------------------------------------
    //  public void putNextEntry( LhaHeader header )
    //  public void putNextEntryAlreadyCompressed( LhaHeader header )
    //  public void putNextEntryNotYetCompressed( LhaHeader header )
    //  public void closeEntry()
    //------------------------------------------------------------------
    /**
     * VGgނ悤ɃXg[ݒ肷B<br>
     * ̃\bh Ɉkς݂̃Gg̏ꍇ
     * putNextEntryAlreadyCompressed(),
     * ɈkĂȂꍇ
     * putNextEntryNotYetCompressed() ĂяoB<br>
     * kĂ邩̔́A
     * <ul>
     *   <li>header.getCompressedSize()<br>
     *   <li>header.getOriginalSize()<br>
     *   <li>header.getCRC()<br>
     * </ul>
     * ̂ǂꂩł LhaHeader.UNKNOWN łΖɈkĂȂƂB
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void putNextEntry( LhaHeader header ) throws IOException {
        if( header.getCompressedSize() == LhaHeader.UNKNOWN
         || header.getOriginalSize()   == LhaHeader.UNKNOWN
         || header.getCRC()            == LhaHeader.UNKNOWN ){
            this.putNextEntryNotYetCompressed( header );                        //throws IOException
        }else{
            this.putNextEntryAlreadyCompressed( header );                       //throws IOException
        }
    }

    /**
     * Ɉkς݂̃Ggނ悤ɃXg[ݒ肷B<br>
     * kς݂Ȃ̂ŁAꎞޔ@\oɒڏo͐ɏo͂B
     * kς݃f[^́AĂяoۏ؂鎖B
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     * @exception IllegalArgumentException
     *               <ol>
     *                  <li>header.getOriginalSize()  LhaHeader.UNKNOWN Ԃꍇ
     *                  <li>header.getComressedSize()  LhaHeader.UNKNOWN Ԃꍇ
     *                  <li>header.getCRC()  LhaHeader.UNKNOWN Ԃꍇ
     *               </ol>
     *               ̉ꂩB
     */
    public void putNextEntryAlreadyCompressed( LhaHeader header ) throws IOException {
        if( header.getOriginalSize()   != LhaHeader.UNKNOWN
         && header.getCompressedSize() != LhaHeader.UNKNOWN
         && header.getCRC()            != LhaHeader.UNKNOWN ){

            if( this.tempOut != null ){
                this.closeEntry();                                              //throws IOException
            }

            String encoding = this.property.getProperty( "lha.encoding" );
            if( encoding == null ){
                encoding = LhaProperty.getProperty( "lha.encoding" );
            }
            this.out.write( header.getBytes( encoding ) );                      //throws IOException
            this.tempOut = out;


        }else if( header.getOriginalSize() == LhaHeader.UNKNOWN ){
            throw new IllegalArgumentException( "OriginalSize must not \"LhaHeader.UNKNOWN\"." );
        }else if( header.getCompressedSize() == LhaHeader.UNKNOWN ){
            throw new IllegalArgumentException( "CompressedSize must not \"LhaHeader.UNKNOWN\"." );
        }else{
            throw new IllegalArgumentException( "CRC must not \"LhaHeader.UNKNOWN\"." );
        }
    }

    /**
     * ɈkĂȂGgނ悤ɃXg[ݒ肷B<br>
     * header  OriginalSize, CompressedSize, CRCw肳ĂĂB
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void putNextEntryNotYetCompressed( LhaHeader header ) throws IOException {
        if( this.tempOut != null ){
            this.closeEntry();                                                  //throws IOException
        }

        this.crc.reset();
        this.length  = 0;
        this.header  = (LhaHeader)header.clone();
        this.tempOut = CompressMethod.connectEncoder( this.temp.getOutputStream(), 
                                                      header.getCompressMethod(), 
                                                      this.property  );
    }

    /**
     * ݏo͒̃GgÃGgo͉\ȏԂɂB
     * kɎs(kTCYkOTCY)ꍇA
     * 𓀂kŊi[BGg̃TCY傫ꍇA
     * ̏ɂ͂Ȃ̎ԂB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void closeEntry() throws IOException {
        if( this.header != null ){
            this.tempOut.close();
            InputStream in;

            if( this.temp.length() < this.length ){
                this.header.setOriginalSize( this.length );
                this.header.setCompressedSize( this.temp.length() );
                this.header.setCRC( (int)crc.getValue() );

                in = this.temp.getInputStream();                                //throws IOException
            }else{
                String method = this.header.getCompressMethod();

                this.header.setOriginalSize( this.length );
                this.header.setCompressedSize( this.length );
                this.header.setCRC( (int)crc.getValue() );
                if( !this.header.getCompressMethod().equalsIgnoreCase( CompressMethod.LHD ) ){
                    this.header.setCompressMethod( CompressMethod.LH0 );
                }

                in = this.temp.getInputStream();                                //throws IOException
                in = CompressMethod.connectDecoder( in, 
                                                    method, 
                                                    this.property,
                                                    this.temp.length() );
            }

            String encoding = this.property.getProperty( "lha.encoding" );
            if( encoding == null ){
                encoding = LhaProperty.getProperty( "lha.encoding" );
            }
            this.out.write( this.header.getBytes( encoding ) );                 //throws UnsupportedEncodingException, IOException

            byte[] buffer = new byte[ 8192 ];
            int length;
            while( 0 <= ( length = in.read( buffer ) ) ){                       //throws IOException
                this.out.write( buffer, 0, length );                            //throws IOException
            }
        }
        this.header  = null;
        this.tempOut = null;
    }


    //------------------------------------------------------------------
    //  inner class
    //------------------------------------------------------------------
    //  private static interface Temporary
    //  private static class TemporaryFile
    //  private static class TemporaryBuffer
    //------------------------------------------------------------------
    /**
     * f[^̈ꎞޔ@\񋟂B
     */
    private static interface Temporary{

        //------------------------------------------------------------------
        //  original method
        //------------------------------------------------------------------
        //  public abstract InputStream getInputStream()
        //  public abstract OutputStream getOutputStream()
        //  public abstract long length()
        //  public abstract void close()
        //------------------------------------------------------------------
        /**
         * ꎞޔ@\ɒꂽf[^oInputStream 𓾂B<br>
         * ̃f[^͒O getOutputStream() ŗ^ 
         * OutputStream ɏo͂ꂽf[^ƓłB<br>
         * getInputStream() œꂽ InputStream  close() ܂ŁA
         * getOutputStream() Ăł͂ȂȂB<br>
         * ܂AgetInputStream() œꂽ InputStream  close() ܂ŁA
         * Ă getInputStream() Ăł͂ȂȂB<br>
         * 
         * @return ꎞޔ@\f[^o InputStream
         * 
         * @exception IOException o̓G[ꍇ
         */
        public abstract InputStream getInputStream() throws IOException;

        /**
         * f[^ꎞޔ@\ɒOutputStream 𓾂B<br>
         * f[^͒ getInputStream() œ
         * InputStream 瓾鎖oB<br>
         * getOutputStream œꂽ OutputStream  close() ܂ŁA
         * getInputStream() Ăł͂ȂȂB
         * ܂AgetOutputStream() œꂽ OutputStream  close() ܂ŁA
         * Ă getOutputStream() Ăł͂ȂȂB<br>
         * 
         * @return f[^ꎞޔ@\ɒ OutputStream
         * 
         * @exception IOException o̓G[ꍇ
         */
        public abstract OutputStream getOutputStream() throws IOException;

        /**
         * ꎞޔ@\Ɋi[Ăf[^ʂ𓾂B
         *  O getOutputStream() ŗ^ꂽ
         * OutputStream ɏo͂ꂽf[^ʂƓłB
         *
         * @return ꎞޔ@\Ɋi[Ăf[^
         */
        public abstract long length() throws IOException;

        /**
         * ꎞޔ@\ŎgpĂASẴVXe\[XJB
         * 
         * @exception IOException o̓G[ꍇ
         */
        public abstract void close() throws IOException ;

    }

    /**
     * ꎞޔ@\ RandomAccessFile gpNXB
     */
    private static class TemporaryFile implements Temporary{

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  private RandomAccessFile tempfile
        //  private long length
        //------------------------------------------------------------------
        /**
         * ꎞޔ@\Ɏgp RandomAccessFile
         */
        private RandomAccessFile tempfile;

        /**
         * getOutputStream ŗ^ OutputStream ɏo͂ꂽf[^ʂێB
         */
        private long length;

        //------------------------------------------------------------------
        //  constructor
        //------------------------------------------------------------------
        //  public TemporaryFile( RandomAccessFile file )
        //------------------------------------------------------------------
        /**
         * RXgN^ filegp TemporaryFile \zB
         * 
         * @param file RandomAccessFile ̃CX^X
         */
        public TemporaryFile( RandomAccessFile file ){
            if( file != null ){ 
                this.tempfile = file;
            }else{ 
                throw new NullPointerException( "file" );
            }
        }

        //------------------------------------------------------------------
        //  method of Temporary
        //------------------------------------------------------------------
        //  public InputStream getInputStream()
        //  public OutputStream getOutputStream()
        //  public long length()
        //  public void close()
        //------------------------------------------------------------------
        /**
         * ꎞޔ@\ɒꂽf[^o InputStream 𓾂B<br>
         * ̃f[^͒O getOutputStream() ŗ^ 
         * OutputStream ɏo͂ꂽf[^ƓB<br>
         * 
         * @return ꎞޔ@\f[^o InputStream
         * 
         * @exception IOException o̓G[ꍇ
         */
        public InputStream getInputStream() throws IOException {
            return new TemporaryFileInputStream();
        }

        /**
         * f[^ꎞޔ@\ɒOutputStream𓾂B<br>
         * f[^͒ getInputStream() 
         *  InputStream 瓾鎖oB<br>
         * 
         * @return f[^ꎞޔ@\ɒ OutputStream
         * 
         * @exception IOException o̓G[ꍇ
         */
        public OutputStream getOutputStream() throws IOException {
            return new TemporaryFileOutputStream();
        }

        /**
         * ꎞޔ@\Ɋi[Ăf[^ʂ𓾂B<br>
         *  O getOutputStream() ŗ^ꂽ
         * OutputStream ɏo͂ꂽf[^ʂƓłB<br>
         *
         * @return ꎞޔ@\Ɋi[Ăf[^
         */
        public long length(){
            return this.length;
        }

        /**
         * ꎞޔ@\ŎgpĂASẴVXe\[XJB
         * RXgN^ŗ^ꂽ RandomAccessFile ͕B
         * 
         * @exception IOException o̓G[ꍇ
         */
        public void close() throws IOException {
            this.tempfile.close(); //throws IOException
            this.tempfile = null;
        }

        //------------------------------------------------------------------
        //  inner classes
        //------------------------------------------------------------------
        //  private class TemporaryFileInputStream
        //  private class TemporaryFileOutputStream
        //------------------------------------------------------------------
        /**
         * TemporaryFile ̓̓Xg[
         */
        private class TemporaryFileInputStream extends InputStream {

            //------------------------------------------------------------------
            //  constructor
            //------------------------------------------------------------------
            //  public TemporaryFileInputStream()
            //------------------------------------------------------------------
            /**
             * TemporaryFile f[^ǂݍ InputStream \zB<br>
             * 
             * @exception IOException o̓G[ꍇ
             */
            public TemporaryFileInputStream() throws IOException {
                TemporaryFile.this.tempfile.seek( 0 );                          //throws IOException
            }

            //------------------------------------------------------------------
            //  method of java.io.InputStream
            //------------------------------------------------------------------
            //  public int read()
            //  public int read( byte[] buffer )
            //  public int read( byte[] buffer, int index, int length )
            //------------------------------------------------------------------
            /**
             * TemporaryFile 1oCg̃f[^ǂݍށB
             * 
             * @return ǂ݂܂ꂽ1oCg̃f[^
             *         EndOfStreamɒBĂꍇ-1
             * 
             * @exception IOException o̓G[ꍇ
             */
            public int read() throws IOException {
                long pos   = TemporaryFile.this.tempfile.getFilePointer();      //throws IOException
                long limit = TemporaryFile.this.length;

                if( pos < limit ){
                    return TemporaryFile.this.tempfile.read();                  //throws IOException
                }else{
                    return -1;
                }
            }

            /**
             * TemporaryFile buffer𖞂悤Ƀf[^ǂݍށB
             *
             * @param buffer f[^ǂݍރobt@
             * 
             * @return ǂ݂܂ꂽf[^
             *         EndOfStreamɒBĂꍇ-1
             * 
             * @exception IOException o̓G[ꍇ
             */
            public int read( byte[] buffer ) throws IOException {
                return this.read( buffer, 0, buffer.length );                   //throws IOException
            }

            /**
             * TemporaryFile buffer indexlengthoCg̃f[^ǂݍ
             * 
             * @param buffer f[^ǂݍރobt@
             * @param index  buffer̃f[^ǂ݂݊Jnʒu
             * @param length ǂݍރf[^
             * 
             * @return ǂ݂܂ꂽf[^
             *         EndOfStreamɒBĂꍇ-1
             * 
             * @exception IOException o̓G[ꍇ
             */
            public int read( byte[] buffer, int index, int length ) 
                                                            throws IOException {
                long pos   = TemporaryFile.this.tempfile.getFilePointer();      //throws IOException
                long limit = TemporaryFile.this.length;
                length = (int)( Math.min( pos + length, limit ) - pos );

                if( pos < limit ){
                    return TemporaryFile.this.tempfile.read( buffer, index, length );//throws IOException
                }else{
                    return -1;
                }
            }

        }

        /**
         * TemporaryFile ̏o̓Xg[
         */
        private class TemporaryFileOutputStream extends OutputStream {

            //------------------------------------------------------------------
            //  constructor
            //------------------------------------------------------------------
            //  public TemporaryFileOutputStream()
            //------------------------------------------------------------------
            /**
             * TemporaryFile Ƀf[^o͂ OutputStream \zB<br>
             * 
             * @exception IOException o̓G[ꍇ
             */
            public TemporaryFileOutputStream() throws IOException {
                TemporaryFile.this.tempfile.seek( 0 );                          //throws IOException
                TemporaryFile.this.length = 0;
            }

            //------------------------------------------------------------------
            //  method of java.io.OutputStream
            //------------------------------------------------------------------
            //  public void write( int data )
            //  public void write( byte[] buffer )
            //  public void write( byte[] buffer, int index, int length )
            //------------------------------------------------------------------
            /**
             * TemporaryFile  1bytẽf[^oB
             * 
             * @param data o1bytẽf[^
             * 
             * @exception IOException o̓G[ꍇ
             */
            public void write( int data ) throws IOException {
                TemporaryFile.this.tempfile.write( data );                      //throws IOException
                TemporaryFile.this.length++;
            }

            /**
             * TemporaryFile  buffer̓eSďoB
             * 
             * @param buffer of[^̓oCgz
             * 
             * @exception IOException o̓G[ꍇ
             */
            public void write( byte[] buffer ) throws IOException {
                TemporaryFile.this.tempfile.write( buffer );                    //throws IOException
                TemporaryFile.this.length += buffer.length;
            }

            /**
             * TemporaryFile  bufferindex lengthoCg̓eoB
             * 
             * @param buffer of[^̓oCgz
             * @param index  buffeȑof[^̊Jnʒu
             * @param length of[^
             * 
             * @exception IOException o̓G[ꍇ
             */
            public void write( byte[] buffer, int index, int length )
                                                        throws IOException {
                TemporaryFile.this.tempfile.write( buffer, index, length );     //throws IOException
                TemporaryFile.this.length += length;
            }

        }

    }

    /**
     * ꎞޔ@\ GrowthByteBuffergpNX
     */
    private static class TemporaryBuffer implements Temporary {

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  private GrowthByteBuffer tempbuffer
        //------------------------------------------------------------------
        /**
         * ꎞޔ@\Ɏgpobt@
         */
        private GrowthByteBuffer tempbuffer;


        //------------------------------------------------------------------
        //  constructor
        //------------------------------------------------------------------
        //  public TemporaryBuffer()
        //------------------------------------------------------------------
        /**
         * GrowthByteBuffer gp@\\zB
         */
        public TemporaryBuffer(){
            this.tempbuffer = new GrowthByteBuffer();
        }

        //------------------------------------------------------------------
        //  method of Temporary
        //------------------------------------------------------------------
        //  public InputStream getInputStream()
        //  public OutputStream getOutputStream()
        //  public long length()
        //  public void close()
        //------------------------------------------------------------------
        /**
         * ꎞޔ@\ɒꂽf[^o InputStream 𓾂B<br>
         * ̃f[^͒O getOutputStream() ŗ^ 
         * OutputStream ɏo͂ꂽf[^ƓB<br>
         * 
         * @return ꎞޔ@\f[^o InputStream
         */
        public InputStream getInputStream(){
            return new TemporaryBufferInputStream();
        }

        /**
         * f[^ꎞޔ@\ɒ OutputStream 𓾂B<br>
         * f[^͒ getInputStream() œ 
         * InputStream 瓾鎖oB<br>
         * 
         * @return f[^ꎞޔ@\ɒ OutputStream
         */
        public OutputStream getOutputStream(){
            return new TemporaryBufferOutputStream();
        }

        /**
         * ꎞޔ@\Ɋi[Ăf[^ʂ𓾂B<br>
         *  O getOutputStream() ŗ^
         * OutputStream ɏo͂ꂽf[^ʂƓłB
         *
         * @return ꎞޔ@\Ɋi[Ăf[^
         */
        public long length(){
            return this.tempbuffer.length();
        }

        /**
         * ꎞޔ@\ŎgpĂASẴVXe\[XJB
         */
        public void close(){
            this.tempbuffer = null;
        }

        //------------------------------------------------------------------
        //  inner classes
        //------------------------------------------------------------------
        //  private class TemporaryBufferInputStream
        //  private class TemporaryBufferOutputStream
        //------------------------------------------------------------------
        /**
         * TemporaryBuffer ̓̓Xg[
         */
        private class TemporaryBufferInputStream extends InputStream{

            //------------------------------------------------------------------
            //  constructor
            //------------------------------------------------------------------
            //  public TemporaryBufferInputStream()
            //------------------------------------------------------------------
            /**
             * TemporaryBuffer f[^ǂݍ InputStream \zB<br>
             */
            public TemporaryBufferInputStream(){
                TemporaryBuffer.this.tempbuffer.seek( 0 );
            }

            //------------------------------------------------------------------
            //  method of java.io.InputStream
            //------------------------------------------------------------------
            //  public int read()
            //  public int read( byte[] buffer )
            //  public int read( byte[] buffer, int index, int length )
            //------------------------------------------------------------------
            /**
             * TemporaryBuffer  1oCg̃f[^ǂݍށB
             * 
             * @return ǂ݂܂ꂽ1oCg̃f[^
             *         EndOfStreamɒBĂꍇ-1
             */
            public int read(){
                return TemporaryBuffer.this.tempbuffer.read();
            }

            /**
             * TemporaryBuffer  buffer𖞂悤Ƀf[^ǂݍށB
             *
             * @param buffer f[^ǂݍރobt@
             * 
             * @return ǂ݂܂ꂽf[^
             *         EndOfStreamɒBĂꍇ-1
             */
            public int read( byte[] buffer ){
                return TemporaryBuffer.this.tempbuffer.read( buffer );
            }

            /**
             * TemporaryBuffer  buffer index lengthoCg̃f[^ǂݍ
             * 
             * @param buffer f[^ǂݍރobt@
             * @param index  buffer̃f[^ǂ݂݊Jnʒu
             * @param length ǂݍރf[^
             * 
             * @return ǂ݂܂ꂽf[^
             *         EndOfStreamɒBĂꍇ-1
             */
            public int read( byte[] buffer, int index, int length ){
                return TemporaryBuffer.this.tempbuffer.read( buffer, index, length );
            }

        }

        /**
         * TemporaryBuffer ̏o̓Xg[
         */
        private class TemporaryBufferOutputStream extends OutputStream {

            //------------------------------------------------------------------
            //  constructor
            //------------------------------------------------------------------
            //  public TemporaryBufferOutputStream()
            //------------------------------------------------------------------
            /**
             * TemporaryBuffer Ƀf[^o͂ OutputStream \zB<br>
             */
            public TemporaryBufferOutputStream(){
                TemporaryBuffer.this.tempbuffer.seek( 0 );
                TemporaryBuffer.this.tempbuffer.setLength( 0 );
            }

            //------------------------------------------------------------------
            //  method of java.io.OutputStream
            //------------------------------------------------------------------
            //  public void write( int data )
            //  public void write( byte[] buffer )
            //  public void write( byte[] buffer, int index, int length )
            //------------------------------------------------------------------
            /**
             * TemporaryBuffer  1bytẽf[^oB
             * 
             * @param data o1bytẽf[^
             */
            public void write( int data ){
                TemporaryBuffer.this.tempbuffer.write( data );
            }

            /**
             * TemporaryBuffer  buffer̓eSďoB
             * 
             * @param buffer of[^̓oCgz
             */
            public void write( byte[] buffer ){
                TemporaryBuffer.this.tempbuffer.write( buffer );
            }

            /**
             * TemporaryBuffer  bufferindex  lengthoCg̓eoB
             * 
             * @param buffer of[^̓oCgz
             * @param index  buffeȑof[^̊Jnʒu
             * @param length of[^
             */
            public void write( byte[] buffer, int index, int length ){
                TemporaryBuffer.this.tempbuffer.write( buffer, index, length );
            }

        }

    }

}
//end of LhaOutputStream.java
