
#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"
#include "ctkcolor.h"

static gpointer ctk_radio_button_destroy(CtkObject *object);

/* Initialize the Button */
void ctk_radio_button_init(CtkRadioButton* button, GSList* radio_group)
{
	ctk_check_button_init(&button->checkbutton);

	button->radio_group = g_slist_append(radio_group, button);

	((CtkObject *)button)->type = CtkTypeRadioButton;
	((CtkWidget *)button)->width = 4;
	((CtkWidget *)button)->height = 1;
	((CtkWidget *)button)->orig_width = 4;
	((CtkWidget *)button)->orig_height = 1;
	((CtkWidget *)button)->main_col = ctk_calculate_palette(CTK_COLOR_CYAN,CTK_COLOR_BLUE);
	((CtkWidget *)button)->inverse_col = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_RED);
	((CtkObject *)button)->destroy_func = ctk_radio_button_destroy;
}

/* Create a Button Widget */
CtkWidget* ctk_radio_button_new(GSList* radio_group)
{
	CtkRadioButton *button;

	button = g_malloc(sizeof(CtkRadioButton));
	
	ctk_radio_button_init(button, radio_group);
	
	return ((CtkWidget *)button);
}

GSList* ctk_radio_button_group(CtkRadioButton *button)
{
	if (!button)
	    return NULL;

	return button->radio_group;
}

CtkWidget* ctk_radio_button_new_with_label(GSList *radiogroup, const gchar *text)
{
	CtkWidget *button;
	CtkWidget *label;
	
	button = ctk_radio_button_new(radiogroup);

	label = ctk_label_new(text);
	ctk_misc_set_alignment(CTK_MISC(label), 0, 0.5);

	ctk_container_add(CTK_CONTAINER(button),label);
	
	ctk_widget_show(label);

	return button;
}

gpointer ctk_radio_button_destroy(CtkObject *object)
{
      CtkRadioButton *radiobutton;
      GSList *radio_link;
      
      if (!object)
	    return NULL;
      
      radiobutton = CTK_RADIO_BUTTON(object);
      
      if (!radiobutton->radio_group)
	    return NULL;
      
      radio_link = g_slist_find(radiobutton->radio_group, radiobutton);

      if (!radio_link)
	    return NULL;
      
      if (radio_link) 
      {
	    GSList* temp;
	    temp = g_slist_remove_link(radiobutton->radio_group,
				       radio_link);
	    if (temp != radiobutton->radio_group)
	    {
		  for (temp = radiobutton->radio_group; temp; temp = temp->next)
		  {
			((CtkRadioButton *)temp->data)->radio_group = radiobutton->radio_group;
		  }
	    }
      }
      
      if (radiobutton->radio_group && !radiobutton->radio_group->next)
	    g_slist_free(radiobutton->radio_group);
      
      return NULL;
}
