/**
 * \file math_parinset.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Andr Pnitz
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

#include "math_parinset.h"
#include "math_data.h"
#include "math_mathmlstream.h"
#include "support/std_ostream.h"


using std::auto_ptr;


MathParInset::MathParInset(MathArray const & ar)
{
	cells_[0] = ar;
}


void MathParInset::metrics(MetricsInfo & mi, Dimension & dim) const
{
	FontSetChanger dummy1(mi.base, "textnormal");
	MathGridInset::metrics(mi);
	dim = dim_;
}


void MathParInset::draw(PainterInfo & pi, int x, int y) const
{
	FontSetChanger dummy1(pi.base, "textnormal");
	MathGridInset::draw(pi, x, y);
}


void MathParInset::write(WriteStream & os) const
{
	for (idx_type i = 0; i < nargs(); ++i)
		os << cell(i) << "\n";
}


void MathParInset::infoize(std::ostream & os) const
{
	os << "Type: Paragraph ";
}


auto_ptr<InsetBase> MathParInset::doClone() const
{
	return auto_ptr<InsetBase>(new MathParInset(*this));
}
