// -*- C++ -*-
/**
 * \file QURL.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS.
 */

#ifndef QURL_H
#define QURL_H

#include "QDialogView.h"

namespace lyx {
namespace frontend {

class ControlCommand;
class QURLDialog;

class QURL :
	public QController<ControlCommand, QView<QURLDialog> >
{
public:
	friend class QURLDialog;
	QURL(Dialog &);
protected:
	virtual bool isValid();
private:
	/// apply dialog
	virtual void apply();
	/// build dialog
	virtual void build_dialog();
	/// update dialog
	virtual void update_contents();
};

} // namespace frontend
} // namespace lyx

#endif // QURL_H
