// -*- C++ -*-
/**
 * \file QCharacterDialog.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Edwin Leuven
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS.
 */

#ifndef QCHARACTERDIALOG_H
#define QCHARACTERDIALOG_H

#include "QCharacter.h"
#include "ui/QCharacterDialogBase.h"

class LyXFont;

namespace lyx {
namespace frontend {

class QCharacterDialog : public QCharacterDialogBase {
	Q_OBJECT
public:
	QCharacterDialog(QCharacter * form);
protected:
	void closeEvent(QCloseEvent * e);
private:
	QCharacter * form_;
protected slots:
	void change_adaptor();
};

} // namespace frontend
} // namespace lyx

#endif // QCHARACTERDIALOG_H
