#include <syslog.h>
#include "global_vars.h"
#include "../lcp3.h"
#include "srv_def.h"
#include "init.h"

void dbg_check_con_type(int location)
{
    struct line_t *line = (struct line_t*)lstlines.first;
    while ( line )
    {
	switch ( line->con_type )
	{
	    case CT_NETDEV:
	    case CT_ISDN:
	    case CT_FILE:
		break;
	    default:
		syslog(LOG_ERR, "bad con_type %d for '%s', location %d",
			line->con_type, line->linename, location);
		cleanup();
	}
	line = (struct line_t*)line->next;
    }
}
