/***************************************************************************
 *
 *  $Id: main.cpp,v 1.16 2005/06/29 23:34:22 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>
#include <stdlib.h>
#include <string>

#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kglobal.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kmessagebox.h>

#include <qpixmap.h>

#include <libnjb.h>

#include "kzensplashscreen.h"
#include "kzenexplorer.h"

static const char description[] =
  I18N_NOOP("KZenExplorer is a playlist and track manager\n"
	    "application for Creative Nomad type mp3 players");

static const char version[] = "0.6";

static KCmdLineOptions options[] =
{
  { "db <file>", I18N_NOOP("Database file to use"), 0 },  
  KCmdLineLastOption
};

int main(int argc, char **argv)
{
  KAboutData about("kzenexplorer", 
		   I18N_NOOP("KZenExplorer"), 
		   version, 
		   description,
		   KAboutData::License_GPL, 
		   "(C) 2005, Andreas Mussgiller", 
		   0,
		   "http://kzenexplorer.sourceforge.net",
		   "http://sourceforge.net/tracker/?group_id=132837");

  about.addAuthor("Andreas Mussgiller", 0, "muszilla@users.sourceforge.net");
  
  about.addCredit("John Mechalas", 
		  I18N_NOOP("libnjb"),
		  0,"http://libnjb.sourceforge.net");
  about.addCredit("Scott Wheeler", 
		  I18N_NOOP("GUI inspiration"),
		  0,"http://developer.kde.org/~wheeler/juk.html");
  about.addCredit("The amaroK Development Squad", 
		  I18N_NOOP("GUI and feature inspiration"),
		  0,"http://amarok.kde.org/");

  about.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\n"
				"Your names"),
		      I18N_NOOP("_: EMAIL OF TRANSLATORS\n"
				"Your emails"));
  
  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions(options);

  KUniqueApplication::addCmdLineOptions();

  if (!KUniqueApplication::start()) {
    fprintf(stderr, "KZenExplorer is already running!\n");
    exit(0);
  }
  
  KUniqueApplication app;

  bool QuickStart = false;
  KConfig * cfg = KGlobal::config();
  if (cfg->hasGroup("General")) {
    cfg->setGroup("General"); 
    QuickStart = cfg->readBoolEntry("QuickStart", false);
  }
  
  kdDebug() << "QuickStart=" << QuickStart << endl; 
  if (QuickStart) KMessageBox::questionYesNo(0, "test!");
  
  KZenSplashScreen * splash = new KZenSplashScreen(UserIcon("kzenexplorer_splash"));
  splash->show();
  splash->message("startup ...");

  //NJB_Set_Debug(2);
    
  KCmdLineArgs * args = KCmdLineArgs::parsedArgs();
  
  KZenExplorer * mainWin = new KZenExplorer(splash);
  app.setMainWidget(mainWin);
  mainWin->setupActions();
  mainWin->readGlobalProperties(KGlobal::config());
  
  if (!mainWin->connectNJB()) {
    while (!splash->mayClose()) {
      usleep(100);
      qApp->processEvents();
    }
    delete splash;
    exit(0);
  }
  
  mainWin->show();
  splash->finish(mainWin);
  delete splash;
  
  args->clear();
  
  return app.exec();
}
