/***************************************************************************
 *
 *  $Id: kzenconfig.h,v 1.11 2005/07/01 23:25:17 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENCONFIG_H
#define KZENCONFIG_H

#include <kconfig.h>
#include <kurl.h>
#include <qstringlist.h>

/**
@author Andreas Mussgiller
*/
class KZenConfig
{
 public:

  virtual ~KZenConfig();
  static KZenConfig * get();

  void                        saveConfig(KConfig *);
  void                        readConfig(KConfig *);

  void                        setLocalLibrary(const KURL & url) { fLocalLibrary = url; }
  const KURL &                localLibrary() { return fLocalLibrary; }
  
  void                        setSavePath(const QString & path) { fSavePath = path; }
  const QString &             savePath() { return fSavePath; }
  
  void                        setSaveName(const QString & name) { fSaveName = name; }
  const QString &             saveName() { return fSaveName; }

  void                        setShowDetailsArtist(bool s) { fShowDetailsArtist = s; }
  bool                        showDetailsArtist() { return fShowDetailsArtist; }

  void                        setShowDetailsAlbum(bool s) { fShowDetailsAlbum = s; }
  bool                        showDetailsAlbum() { return fShowDetailsAlbum; }

  void                        setShowDetailsGenre(bool s) { fShowDetailsGenre = s; }
  bool                        showDetailsGenre() { return fShowDetailsGenre; }

  void                        setShowDetailsPlayList(bool s) { fShowDetailsPlayList = s; }
  bool                        showDetailsPlayList() { return fShowDetailsPlayList; }

  void                        setSmartImport(bool s) { fSmartImport = s; }
  bool                        smartImport() { return fSmartImport; }

  void                        setQuickStart(bool q) { fQuickStart = q; }
  bool                        quickStart() { return fQuickStart; }

  void                        setSyncLibrary(bool s) { fSyncLibrary = s; }
  bool                        syncLibrary() { return fSyncLibrary; }

  void                        setExcludeFromSync(const QStringList &);
  QStringList &               excludeFromSync() { return fExcludeFromSync; }

  void                        setSyncPlayLists(bool s) { fSyncPlayLists = s; }
  bool                        syncPlayLists() { return fSyncPlayLists; }

  void                        setPlayListOverride(bool o) { fPlayListOverride = o; }
  bool                        playListOverride() { return fPlayListOverride; }

  void                        setCaseSensitiveSearch(bool cs) { fCaseSensitiveSearch = cs; }
  bool                        caseSensitiveSearch() { return fCaseSensitiveSearch; }

  void                        setExactSearch(bool e) { fExactSearch = e; }
  bool                        exactSearch() { return fExactSearch; }
  
 protected:

  KURL                        fLocalLibrary;
  QString                     fSavePath;
  QString                     fSaveName;
  bool                        fShowDetailsArtist;
  bool                        fShowDetailsAlbum;
  bool                        fShowDetailsGenre;
  bool                        fShowDetailsPlayList;
  bool                        fSmartImport;
  bool                        fQuickStart;
  bool                        fSyncLibrary;
  QStringList                 fExcludeFromSync;
  bool                        fSyncPlayLists;
  bool                        fPlayListOverride;
  bool                        fCaseSensitiveSearch;
  bool                        fExactSearch;

  KZenConfig();
  static KZenConfig          *fgConfig;
};

#endif
