#ifndef __LIBKVIXMMS_H_INCLUDED__
#define __LIBKVIXMMS_H_INCLUDED__

//
//   THIS IS A PLUGIN FOR THE KVIrc IRC CLIENT
//   Copyright (C) 1999-2000 Szymon Stefanek (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"

#include <qscrollview.h>
#include <qimage.h>
#include <qtoolbar.h>

class KviImageView : public QScrollView
{
	Q_OBJECT
public:
	KviImageView(QWidget * parent);
	~KviImageView();
protected:
	QPixmap * m_pOriginalPixmap;
	QImage * m_pViewedImage;
	unsigned int m_uZoom;
public:
	bool loadImage(const char *fName);
	unsigned int zoom(){ return m_uZoom; };
	void setZoom(unsigned int zoom);
protected:
	virtual void drawContents(QPainter *p,int clipx,int clipy,int clipw,int cliph);
};

class KviImageWindow : public KviWindow
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviImageWindow(KviFrame *lpFrm);
	~KviImageWindow();
public:		// Fields
	KviImageView * m_pImageView;
	QToolBar * m_pToolBar;
public:
	bool loadImage(const char * fName);
protected slots:
	void zoomIn();
	void zoomIn5();
	void zoomIn10();
	void zoomIn50();
	void zoomIn100();
	void zoomOut();
	void zoomOut5();
	void zoomOut10();
	void zoomOut50();
	void zoomOut100();
	void noZoom();
	void openFile();
protected:	// Protected methods
	virtual QPixmap * myIconPtr();
//	virtual void output(int msg_type,const char *format,...);
//	virtual void outputNoFmt(int msg_type,const char * text);
	virtual void resizeEvent(QResizeEvent *);
};




#endif //!__LIBKVIXMMS_H_INCLUDED__
