//
//   File : kvi_helpwindow.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_helpwindow.cpp)
//   Last major modification : Thu Mar 25 1999 03:17:13 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_helpwindow.h"
#include "kvi_app.h"

#include "kvi_string.h"
#include "kvi_malloc.h"
#include "kvi_locale.h"
#include "kvi_defines.h"
#include "kvi_options.h"
#include "kvi_frame.h"

#include "kvi_process.h"

#include <qmime.h>
#include <qstylesheet.h>
#include <qtextbrowser.h>
#include <qtooltip.h>

//Declared in kvi_app.cpp and managed by KviApp class
//extern QPixmap * g_pWindowIcon[KVI_WND_NUM_ICONS];
extern QPixmap * g_pHelpIcons[KVI_HELP_ICONS_NUM_IMAGES];

//============ KviHelpWindow ============//

KviHelpWindow::KviHelpWindow(KviFrame * pFrm,QWidget *parent,const char *name)
:QWidget(parent,name ? name : "help_window",WStyle_StaysOnTop)
{
	m_pFrame = pFrm;
	setCaption(KVI_HELPWINDOW_WINDOW_NAME);

	createBrowser();

	m_pToolBar = new QToolBar(__tr("Help toolbar"),pFrm,this,"help_toolbar");

	m_pClose = new QToolButton(*g_pHelpIcons[KVI_HELP_ICON_CLOSE],_CHAR_2_QSTRING(__tr("Close")),
			_CHAR_2_QSTRING(__tr("Closes the help window")), this, SLOT(closeWindow()), m_pToolBar, "help_close_btn");
	m_pClose->setFocusPolicy(QWidget::NoFocus);
	m_pClose->setUsesBigPixmap(g_pOptions->m_bUseBigToolbarPixmaps);
	m_pClose->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);

	m_pHome = new QToolButton(*g_pHelpIcons[KVI_HELP_ICON_INDEX],_CHAR_2_QSTRING(__tr("Index")),
						_CHAR_2_QSTRING(__tr("Shows the help index")),this,SLOT(showIndex()),m_pToolBar,"help_home_btn");
	m_pHome->setFocusPolicy(QWidget::NoFocus);
	m_pHome->setUsesBigPixmap(g_pOptions->m_bUseBigToolbarPixmaps);
	m_pHome->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);

	m_pBack = new QToolButton(*g_pHelpIcons[KVI_HELP_ICON_BACK],_CHAR_2_QSTRING(__tr("Back")),
						_CHAR_2_QSTRING(__tr("Shows the previous document")),m_pBrowser,SLOT(backward()),m_pToolBar,"help_back_btn");
	m_pBack->setEnabled(false);
	m_pBack->setFocusPolicy(QWidget::NoFocus);
	m_pBack->setUsesBigPixmap(g_pOptions->m_bUseBigToolbarPixmaps);
	m_pBack->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);

	m_pForward = new QToolButton(*g_pHelpIcons[KVI_HELP_ICON_FORWARD],_CHAR_2_QSTRING(__tr("Forward")),
						_CHAR_2_QSTRING(__tr("Shows the next document")),m_pBrowser,SLOT(forward()),m_pToolBar,"help_forward_btn");
	m_pForward->setEnabled(false);
	m_pForward->setFocusPolicy(QWidget::NoFocus);
	m_pForward->setUsesBigPixmap(g_pOptions->m_bUseBigToolbarPixmaps);
	m_pForward->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);

	m_pExactSearch = new QToolButton(*g_pHelpIcons[KVI_HELP_ICON_SEARCH],_CHAR_2_QSTRING(__tr("Search")),
						_CHAR_2_QSTRING(__tr("Search the documentation")),this,SLOT(doExactSearch()),m_pToolBar,"help_search_btn");
	m_pExactSearch->setFocusPolicy(QWidget::NoFocus);
	m_pExactSearch->setUsesBigPixmap(g_pOptions->m_bUseBigToolbarPixmaps);
	m_pExactSearch->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);

	QToolButton * b = new QToolButton(*g_pHelpIcons[KVI_HELP_ICON_COPY],_CHAR_2_QSTRING(__tr("Copy")),
						_CHAR_2_QSTRING(__tr("Copy to clipboard")),this,SLOT(copyToClipboard()),m_pToolBar,"help_copy_btn");
	b->setFocusPolicy(QWidget::NoFocus);
	b->setUsesBigPixmap(g_pOptions->m_bUseBigToolbarPixmaps);
	b->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);


	m_pSearchString = new QLineEdit(m_pToolBar,"help_search_field");
	m_pSearchString->setFocusPolicy(QWidget::ClickFocus);
	QToolTip::add(m_pSearchString,_CHAR_2_QSTRING(__tr("Search string")));

	m_pToolBar->setStretchableWidget(m_pSearchString);
	m_pToolBar->setBackgroundMode(QWidget::PaletteBackground);

	m_pSearchJob = 0;

//#warning "Icon actually unused! (Make a MDI help window class ?)" 
//	setIcon(*(g_pWindowIcon[KVI_WND_ICON_HELPWINDOW]));

	setDocument(g_pApp->m_szLastHelpDocument.ptr());

	connect(m_pSearchString, SIGNAL(returnPressed()), this, SLOT(doExactSearch()));
}

//============ ~KviHelpWindow ============//

KviHelpWindow::~KviHelpWindow()
{
	if(m_pSearchJob)delete m_pSearchJob;
}

void KviHelpWindow::reloadDocument()
{
	KviStr tmp = g_pApp->m_szLastHelpDocument.ptr();
	showIndex(); //Hack to make it reload the doc
	setDocument(tmp.ptr());
}

void KviHelpWindow::createBrowser()
{
	m_pBrowser = new QTextBrowser(this);
	m_pBrowser->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	m_pBrowser->setFocusPolicy(QWidget::NoFocus);
	connect(m_pBrowser,SIGNAL(backwardAvailable(bool)),this,SLOT(backwardAvailable(bool)));
	connect(m_pBrowser,SIGNAL(forwardAvailable(bool)),this,SLOT(forwardAvailable(bool)));
	m_pBrowser->show();
}

void KviHelpWindow::resetStyleSheet()
{
	KviStr tmp = g_pApp->m_szLastHelpDocument.ptr();
	// HACK HACK HACK HACK HACK HACK HACK
	delete m_pBrowser;
	createBrowser();
	resizeEvent(0);	
	setDocument(tmp.ptr());
	// HACK HACK HACK HACK HACK HACK HACK
}

void KviHelpWindow::copyToClipboard()
{
	m_pBrowser->copy();
}

void KviHelpWindow::setDocument(const char *topic)
{ m_pBrowser->setSource(_CHAR_2_QSTRING(topic)); }

void KviHelpWindow::showIndex()
{ setDocument(KVI_HELP_QML_MAIN_TOPIC_FILE); }

void KviHelpWindow::backwardAvailable(bool bAvailable)
{ m_pBack->setEnabled(bAvailable); }

void KviHelpWindow::forwardAvailable(bool bAvailable)
{ m_pForward->setEnabled(bAvailable); }

void KviHelpWindow::doExactSearch()
{
	setCursor(waitCursor);
	m_pBrowser->viewport()->setCursor(waitCursor);
	m_pSearchString->setCursor(waitCursor);
	KviStr txt = m_pSearchString->text();
	if(txt.hasData())doExactSearchForString(txt.ptr());
}

void KviHelpWindow::doExactSearchForString(const char *str)
{
	if(m_pSearchJob)delete m_pSearchJob;
	m_pSearchJob = new KviProcess();
	connect(m_pSearchJob,SIGNAL(terminated(KviProcess *,int)),this,SLOT(searchJobTerminated(KviProcess *,int)));
	KviStr filesToSearch;
	g_pApp->getGlobalKVircDirectory(filesToSearch,KviApp::Help,"*.kvihelp");
	KviStr fileToProduce;
	g_pApp->getLocalKVircDirectory(fileToProduce,KviApp::Help,"qh_last_search_result.kvihelp");

	KviStr tmp;
//#warning "directory where the script is located...!"
	tmp.sprintf("kvi_search_help.sh %s %s %s",filesToSearch.ptr(),fileToProduce.ptr(),str);
	if(!m_pSearchJob->run(tmp.ptr(),false,true)){
		delete m_pSearchJob;
		m_pSearchJob = 0;
		g_pApp->warningBox(__tr("Could not execute command\n%s"),tmp.ptr());
	} else m_pExactSearch->setEnabled(false);
}

void KviHelpWindow::searchJobTerminated(KviProcess * proc,int)
{
	__range_valid(proc == m_pSearchJob);
	delete m_pSearchJob;
	m_pSearchJob = 0;
	showIndex(); //HACK HACK HACK
	KviStr fileToProduce;
	g_pApp->getLocalKVircDirectory(fileToProduce,KviApp::Help,"qh_last_search_result.kvihelp");
	setDocument(fileToProduce.ptr());
	m_pExactSearch->setEnabled(true);
	setCursor(arrowCursor);
	m_pBrowser->viewport()->setCursor(arrowCursor);
	m_pSearchString->setCursor(arrowCursor);
}

void KviHelpWindow::closeWindow()
{
	delete this;
	m_pFrame->zeroHelpWindowPointer();	// erh.. this lame hack really hurts me :|
}

//================ resizeEvent ===============//

void KviHelpWindow::resizeEvent(QResizeEvent *)
{
//	QString s = m_pBrowser->selectedText();
//	if(!s.isNull())
//	{
//		for(int i=0;i<s.length();i++)
//		{
//			debug("%d,%d (%c)",s[i].cell(),s[i].row(),s[i].latin1());
//		}
//	}
	int hght = m_pToolBar->sizeHint().height();
	m_pToolBar->setGeometry(0,0,width(),hght);
	m_pBrowser->setGeometry(0,hght,width(),height()-hght);
}


#include "m_kvi_helpwindow.moc"
