//
//   File : kvi_app_quickhelp.cpp (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_frame_quickhelp.cpp)
//   Last major modification : Sat Jan 16 1999 18:03:48 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_frame.h"
#include "kvi_fileutils.h"
#include "kvi_app.h"

#include "kvi_xutils.h"
#include <qcursor.h>
#include <qdatetime.h>
#include <qwidget.h>

void KviFrame::slot_whatIsThisRequest()
{
	// Own implementation of the whatsThis idea from Qt.
	g_pApp->setOverrideCursor(Qt::pointingHandCursor);

	XGrabServer(qt_xdisplay());
	if(XGrabPointer(qt_xdisplay(),qt_xrootwin(),true,(ButtonPressMask|ButtonReleaseMask),
		GrabModeAsync,GrabModeAsync,None,None,CurrentTime) != GrabSuccess){
		debug("Could not grab the pointer");
		XUngrabServer(qt_xdisplay());
		return;
	}
	XEvent ev;
	// Allow selecting a widget of our application
	// Keep track of the widget currently under the cursor

	// Highlight the firstwidget (should be the related QToolButton)
	QWidget * last = g_pApp->widgetAt(QCursor::pos(),true);
	QRect lastRect;
	if(last){
		lastRect = QRect(last->mapToGlobal(QPoint(0,0)),last->size());
		kvi_drawDragRectangle(lastRect);
	}

	// Now loop until the user clicks
	// I place also a timeout here because
	// we don't want to block the whole system if the user
	// clicks the KviWhatIsThis Button and then runs to the
	// store down the road completly forgetting about that.

	QTime tm=QTime::currentTime();
	bool bInTime = true;

	while(!XCheckMaskEvent(qt_xdisplay(),(ButtonPressMask|ButtonReleaseMask), &ev)){
		QWidget * w = g_pApp->widgetAt(QCursor::pos(),true);
		if(last != w){
			if(last)kvi_drawDragRectangle(lastRect);
			if(w){
				lastRect = QRect(w->mapToGlobal(QPoint(0,0)),w->size());
				kvi_drawDragRectangle(lastRect);
			}
			last = w;
		}
		if(tm.msecsTo(QTime::currentTime()) > KVI_WHATISTHIS_SELECTION_TIMEOUT){
			bInTime = false;
			break;
		}
	}
	if(last)kvi_drawDragRectangle(lastRect);

	XUngrabPointer(qt_xdisplay(),CurrentTime);
	XUngrabServer(qt_xdisplay());
	// Now find the inquired widget
	QWidget * w = g_pApp->widgetAt(QCursor::pos(),true);
	if(w && bInTime)helpForObject(w);
	g_pApp->restoreOverrideCursor();
}

void KviFrame::helpForObject(QObject * w)
{
	//
	// Look for the file "className()_name().kvihelp"
	// if not found check for "className().kvihelp"
	// if not found check if the widget has a parent and look for
	// "parent->className()_parent->name().kvihelp"
	// if not found check for "parent->className().kvihelp"	
	// if not found say that there is no help about it
	//
	KviStr fname;
	fname="qh_";
	fname+=w->className();
	fname+="_";
	fname+=w->name();
	fname+=".kvihelp";
	fname.toLower();

	KviStr szPath;
	g_pApp->getGlobalKVircDirectory(szPath,KviApp::Help,fname.ptr());
	if(kvi_fileExists(szPath.ptr())){
		requestHelpOn(fname.ptr());
		return;
	}

	fname="qh_";
	fname+=w->className();
	fname+=".kvihelp";
	fname.toLower();

	g_pApp->getGlobalKVircDirectory(szPath,KviApp::Help,fname.ptr());
	if(kvi_fileExists(szPath.ptr())){
		requestHelpOn(fname.ptr());
		return;
	}

	if(w->parent() == 0){
		requestHelpOn("qh_nohelpavailable.kvihelp");
		return;
	}
	// Recursive call on the parent
	helpForObject(w->parent());
}


