#ifndef _KVI_SELECTORS_H_INCLUDED_
#define _KVI_SELECTORS_H_INCLUDED_

//
//   File : kvi_selectors.h (/usr/build/NEW_kvirc/kvirc/kvilib/kvi_selectors.h)
//   Last major modification : Sat Jan 16 1999 14:56:21 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qwidget.h>
#include <qtabdialog.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include <qfont.h>
#include <qpushbutton.h>

#include <qhbox.h>
#include <qlayout.h>
#include <qlabel.h>

class KviLineEdit : public QLineEdit
{
	Q_OBJECT
public:
	KviLineEdit(QWidget * parent,const char *name=0);
	~KviLineEdit();
	QString text() const;
public slots:
	virtual void setText(const char *text);
	void insert(const char *newText);
protected:
	KviStr m_szAltKeyCode;
	virtual void keyPressEvent(QKeyEvent *e);
	virtual void keyReleaseEvent(QKeyEvent *e);
};

class KviIpEditor : public QHBox
{
	Q_OBJECT
public:
	KviIpEditor(QWidget * parent,const QString &ipAddr = QString::null,const char *name = 0);
	~KviIpEditor();
private:
	QLabel      * m_pLabel[3];
	QLineEdit   * m_pEdit[4];
public:
	bool setAddress(const QString &ipAddr);
	QString address();
	virtual void setEnabled(bool bEnabled);
protected:
	virtual bool eventFilter(QObject * o,QEvent *e);
};

class KviNewStringSelector : public QWidget
{
	Q_OBJECT
public:
	KviNewStringSelector(QWidget *parent,const char *description,KviStr *pString,bool bEnabled = true,int fieldWidth = -1,const char *name = 0);
	~KviNewStringSelector();
private:
	KviStr    * m_pString;
	QLabel    * m_pLabel;
	QLineEdit * m_pEdit;
	int         m_iFieldWidth;
public:
	virtual void commitChanges();
	virtual void setEnabled(bool bEnabled);
	static void commitAll(QWidget *w);
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual QSize sizeHint();
};

class KviNewCharSelector : public QWidget
{
	Q_OBJECT
public:
	KviNewCharSelector(QWidget *parent,const char *description,char *pChar,bool bEnabled = true,int fieldWidth = -1,const char *name = 0);
	~KviNewCharSelector();
private:
	char      * m_pChar;
	QLabel    * m_pLabel;
	QLineEdit * m_pEdit;
	int         m_iFieldWidth;
public:
	virtual void commitChanges();
//	virtual bool selectionChanged();
	virtual void setEnabled(bool bEnabled);
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual QSize sizeHint();
};


class KviNewIntegerSelector : public QWidget
{
	Q_OBJECT
public:
	enum IntSelectorType { Int , UInt , UShort , Short };
	KviNewIntegerSelector(QWidget *parent,const char *description,void * pNumber,IntSelectorType type,int lowerBound,int upperBound,
		int defValue,bool bEnabled = true,int fieldWidth = -1,const char *name = 0,int lineStep = 0,const char *suffix = "");
	~KviNewIntegerSelector();
private:
	IntSelectorType m_type;
	void      * m_pNumber;
	QLabel    * m_pLabel;
//	QLineEdit * m_pEdit;
	QSpinBox  * m_pSpinBox;
	int         m_iFieldWidth;
	int         m_iLowBound;
	int         m_iHighBound;
	KviStr      m_szDefault;
public:
	virtual void commitChanges();
	static void commitAll(QWidget * w);
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual QSize sizeHint();
	virtual void setEnabled(bool bEnabled);
public slots:
	void setNotEnabled(bool bNotEnabled){ setEnabled(!bNotEnabled); };
};

class KviNewBoolSelector : public QCheckBox
{
	Q_OBJECT
public:
	KviNewBoolSelector(QWidget *parent,const char *description,bool *pBool,bool bEnabled = true,const char *name = 0);
	~KviNewBoolSelector();
private:
	bool      * m_pBool;
public:
	virtual void commitChanges();
	static void commitAll(QWidget *w);
public slots:
	void setNotEnabled(bool bNotEnabled){ setEnabled(!bNotEnabled); };
};


class KviNewFileSelector : public QWidget
{
	Q_OBJECT
public:
	KviNewFileSelector(QWidget * parent,KviStr *valuePtr,bool bMustBeReadable,bool bEnabled = true);
	~KviNewFileSelector();
private:
	KviStr * m_valuePtr;
	QLabel * m_pValueLabel;
	QPushButton * m_pButton;
	bool     m_bMustBeReadable;
public slots:
	virtual void setEnabled(bool bEnabled);
public:
	virtual void commitChanges();
//	virtual bool selectionChanged();
protected slots:
	void changeFile();
};

class KviNewIpSelector : public QHBox
{
	Q_OBJECT
public:
	KviNewIpSelector(QWidget * parent,const char * description,KviStr *ipPtr,bool bEnabled = true);
	~KviNewIpSelector();
private:
	KviStr * m_ipPtr;
	QLabel * m_pDescription;
	KviIpEditor * m_pIpEditor;
public slots:
	virtual void setEnabled(bool bEnabled);
public:
	virtual void commitChanges();
};

class KviColorButton;

class KviNewColorSelector : public QWidget
{
	Q_OBJECT
public:
	KviNewColorSelector(QWidget *parent,const char * label,QColor *valuePtr,bool bEnabled = true,int defInputWidth = 100);
	~KviNewColorSelector();
private:
	QColor *m_valuePtr;
	QLabel  *m_pLabel;
	KviColorButton *m_pClrButton;
	int     m_iDefInputWidth;
protected:
	virtual void resizeEvent(QResizeEvent *);
public:
	void setColor(const QColor &clr);
	const QColor &getColor();
	virtual QSize sizeHint();
	virtual void setEnabled(bool bEnabled);
public:
	void commitChanges();
};

class KviFontButton;

class KviNewFontSelector : public QWidget
{
	Q_OBJECT
public:
	KviNewFontSelector(QWidget *parent,const char *label,QFont *fnt,
		bool bEnabled = true,int defInputWidth = 100);
	~KviNewFontSelector();
private:
	QFont *m_valuePtr;
	QLabel  *m_pLabel;
	KviFontButton *m_pFntButton;
	int     m_iDefInputWidth;
protected:
	virtual void resizeEvent(QResizeEvent *);
public:
	virtual QSize sizeHint();
	QFont getFont();
	void commitChanges();
};

class KviImageButton;

class KviNewImageSelector : public QWidget
{
	Q_OBJECT
public:
	KviNewImageSelector(QWidget *parent,const char *label,KviStr *valuePtr,QPixmap * cachedPixmap,bool bEnabled = true);
	~KviNewImageSelector();
private:
	KviStr *m_valuePtr;
	QCheckBox *m_pCheckBox;
	KviImageButton *m_pImgButton;
protected:
	virtual void resizeEvent(QResizeEvent *);
public:
	const QPixmap *getImage();
	virtual QSize sizeHint();
	void commitChanges();
};

#endif //!_KVI_SELECTORS_H_INCLUDED_
