\ ipsubnet.4th
\
\ Calculate Subnet for IP Address and Mask
\
\ Copyright (c) 1999 Marty McGowan
\ Provided under the terms of the GNU General Public License
\
\ Required source files:
\     none
\ Revisions:
\
\	1999-12-30 created  MJM
\
\ this program computes the full IP Subnet, given an IP address
\ and the subnet mask expressed as either a dotted quad, or the
\ now more popular /#bits form.
\ i wrote it in response to a 468 K-byte (!!) Windows program
\ which does the same thing.
\ user instructions are below, and printed once gratuitously or
\ at user request:  .help
\
\    -- Marty McGowan  
\          mcgowan@alum.mit.edu 	- home
\ 		 mcfly@workmail.com	- work
\
: dashes
	." ===================================================" cr
;
: separator	cr dashes cr ;
: .HELP	cr
	." Usage Examples ( Note absence of ``.''s in address )" 	
	separator
	."    10   4   1  2 DOTTED.QUAD IP-ADDR " cr	
	."   255 255 192  0 DOTTED.QUAD MASK"     cr
	."     OR    18  #bits  mask"             cr
	."  and then"     cr
	."     SUBNET?"   cr
	."  prints your answer "  cr
	." After both IP-ADDR and MASK are set," cr
	." either may be changed for a new SUBNET? query." cr
	." to repeat this message:    .HELP"   separator
;
: riteByte		dup 255 and swap 8 rshift ;
: print.quad	riteByte riteByte riteByte riteByte drop . . . . ;
: dotted.quad	>r >r >r 256 * r> + 256 * r> + 256 * r> + ;
: #bits		negate 32 + 1 swap lshift 1- invert ;

 variable _ip   1 dup constant _ipset
 variable _mask 2 dup constant _maskset
 variable _set     or constant MUSTSET
 
: toset	_set @  or  _set ! ;
: isset?	_set @ MUSTSET = ;
: ip-addr	_ip !     _ipset toset ;
: mask	_mask ! _maskset toset ;

: subnet?	isset? if _ip @ _mask @
		dup			." MASK:     " print.quad cr
		2dup and 1+		." GATEWAY:  " print.quad cr
		invert dup 1+     ." NET SIZE: " . cr
		       or         ." UPPER:    " print.quad cr
		else separator ." Please follow instructions:" cr .help 
		then
;
 .help
