/***************************************************************************
                          kbeartransferviewpage.h  -  description
                             -------------------
    begin                : Mn Maj 06 2002
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARTRANSFERVIEWPAGE_H
#define KBEARTRANSFERVIEWPAGE_H

//////////////////////////////////////////////////////////////////////
// Qt include files
#include <qwidget.h>
#include <qwhatsthis.h>
#include <qpopupmenu.h>
//////////////////////////////////////////////////////////////////////
// KDE include files
#include <klocale.h>
#include <klistview.h>
#include <kapp.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files

class Transfer;
class KBearTransferViewItem;

/**
	*This class represent the transfer view
  *@author Bjrn Sahlstrm
  */
class KBearTransferViewPage : public KListView {
   Q_OBJECT
public:
	/**  */
	KBearTransferViewPage(QWidget *parent=0, const QString& name=0 );
	/**  */
	~KBearTransferViewPage();
	/** No descriptions */
	int numOfTransfers() const;
	/** No descriptions */
	void addTransfer( Transfer* t );
	/** Check if the name exist, if not return 0 else the number of items with same name */
	int checkNameIntegrity( const QString& name ) const;
	/**  */
	int checkActiveTransfer( const QString& name ) const;
	/**  */
	static QPixmap* folderClosed();
	/**  */
	static QPixmap* folderOpen();
signals:
	/**  */
	void showMenu(QListViewItem*);
	/**  */
	void remove( const QString& );
	/**  */
	void start( Transfer* );
protected slots: // Protected slots
	/**  */
	void slotItemRightPressed( QListViewItem* item, const QPoint&, int );
	/**  */
	void slotTransferFinished( KBearTransferViewItem* );
protected:
	static QPixmap* p_folderClosed;
	static QPixmap* p_folderOpen;
private:
	QString m_name;
};

#endif
