/***************************************************************************
                          kbearconnectionmanager.cpp  -  description
                             -------------------
    begin                : tor apr 18 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <kio/scheduler.h>
#include <kio/slave.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearconnectionmanager.h"
#include "kbeardeletejob.h"
#include "kbearcopyjob.h"
#include "kbeardirlister.h"

//////////////////////////////////////////////////////////////////////
class KBearConnectionManager::ConnectionInfo {
	public:
		ConnectionInfo() : slave(0L),job(0L){}
		Connection connection;
		KIO::Slave* slave;
		KIO::SimpleJob* job;
		bool isDirLister;
};
//////////////////////////////////////////////////////////////////////
KBearConnectionManager* KBearConnectionManager::s_connectionManager = 0L;
//-----------------------------------------------
KBearConnectionManager::KBearConnectionManager( const char* name )
	:	QObject( kapp, name )
{
}
//-----------------------------------------------
KBearConnectionManager::~KBearConnectionManager(){
kdDebug()<<"Destructing KBearConnectionManager..."<<endl;
}
//-----------------------------------------------
KBearConnectionManager* KBearConnectionManager::self() {
	if( ! s_connectionManager )
		s_connectionManager = new KBearConnectionManager();
	return s_connectionManager;
}
//-----------------------------------------------
KIO::Slave* KBearConnectionManager::openNewConnection( unsigned long ID, const Connection& connection, bool isDirLister ){
kdDebug()<<"KBearConnectionManager::openNewConnection ID="<<ID<<endl;
	KIO::Slave* slave = KIO::Scheduler::getConnectedSlave( connection.url(), connection.metaData() );
	if( slave ) {
		ConnectionMap::Iterator it = m_connectionMap.find( ID );
		if( it != m_connectionMap.end() ) {
			delete m_connectionMap[ ID ];
			m_connectionMap.remove( ID );
		}
		ConnectionInfo* info = createConnectionInfo( connection, slave );
		info->isDirLister = isDirLister;
		m_connectionMap.insert( ID, info );
		return slave;
	}
	
	return 0L;
}
//-----------------------------------------------
void KBearConnectionManager::closeConnection( unsigned long ID ){
kdDebug()<<"KBearConnectionManager::closeConnection ID="<<ID<<endl;
	KIO::Slave* slave = getSlave( ID );
	if( ! slave )
		return;
	if( slave->isAlive() ) {
		kdDebug()<<"KBearConnectionManager::closeConnection ID="<<ID<<" got slave="<<slave<<endl;
		slave->kill();
//		KIO::Scheduler::disconnectSlave( slave );
	}
	delete m_connectionMap[ ID ];
	m_connectionMap.remove( ID );
}
//-----------------------------------------------
void KBearConnectionManager::putOnHold( unsigned long ID ) {
kdDebug()<<"KBearConnectionManager::putOnHold ID="<<ID<<endl;
	KIO::SimpleJob* job = m_connectionMap[ ID ]->job;
	KIO::Scheduler::putSlaveOnHold( job, job->url() );
}
//-----------------------------------------------
void KBearConnectionManager::attachJob( unsigned long ID, KIO::SimpleJob* job ) {
	ConnectionMap::Iterator it = m_connectionMap.find( ID );
	if( it == m_connectionMap.end() ) {
		kdDebug()<<"KBearConnectionManager::attachJob no info ID="<<ID<<endl;
		// this is for safety so we don't crash
		// it will break connection management though
		KIO::Scheduler::scheduleJob( job );
		return;
	}
	attachJob( (*it), job );
}
//-----------------------------------------------
void KBearConnectionManager::attachJob( ConnectionInfo* info, KIO::SimpleJob* job ) {
	if( ! info ) {
		kdDebug()<<"KBearConnectionManager::attachJob no info"<<endl;
		// this is for safety so we don't crash
		// it will break connection management though
		KIO::Scheduler::scheduleJob( job ); 
		return;
	}
	KIO::Scheduler::assignJobToSlave( info->slave, job );
	info->job = job;
	job->setMetaData( info->connection.metaData() );
	connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotResetJob( KIO::Job* ) ) );
}
//-----------------------------------------------
void KBearConnectionManager::scheduleJob( unsigned long ID, KIO::SimpleJob* job ) {
	ConnectionMap::Iterator it = m_connectionMap.find( ID );
	if( it == m_connectionMap.end() ) {
		kdDebug()<<"KBearConnectionManager::scheduleJob no info"<<endl;
		// this is for safety so we don't crash
		// it will break connection management though
		KIO::Scheduler::scheduleJob( job );
		return;
	}
	KIO::Scheduler::assignJobToSlave( (*it) ->slave, job );
}
//-----------------------------------------------
KBearCopyJob* KBearConnectionManager::copy( Transfer* transfer ) {
	// now we need to find if we should use a single connection for source or dest
	KBearCopyJob* job = KBearCopyJob::copy( transfer );
	setupCopyMove( transfer, job );
	// Note: the job is started in KBearTransferViewItem
	return job;
}
//-----------------------------------------------
KBearCopyJob* KBearConnectionManager::copy( Transfer* transfer, unsigned long sourceID, unsigned long destID ) {
	KBearCopyJob* job = KBearCopyJob::copy( transfer );
	setupCopyMove( transfer, job, sourceID, destID );
	// Note: the job is started in KBearTransferViewItem
	return job;
}
//-----------------------------------------------
KBearCopyJob* KBearConnectionManager::move( Transfer* transfer ) {
	KBearCopyJob* job = KBearCopyJob::move( transfer );
	setupCopyMove( transfer, job );
	// Note: the job is started in KBearTransferViewItem
	return job;
}
//-----------------------------------------------
KBearCopyJob* KBearConnectionManager::move( Transfer* transfer, unsigned long sourceID, unsigned long destID ) {
	KBearCopyJob* job = KBearCopyJob::move( transfer );
	setupCopyMove( transfer, job, sourceID, destID );
	// Note: the job is started in KBearTransferViewItem
	return job;
}
//-----------------------------------------------
void KBearConnectionManager::setupCopyMove( Transfer* transfer, KIO::Job* job ) {
	if( transfer->sourceConnection().url().hasHost() ) {
		unsigned long ID = getIDForDirListerFromLabel( transfer->sourceConnection().label() );
		Connection* c = getConnection( ID );
		KIO::Slave* slave = getSlave( ID );
		if( c && c->singleConnection() && slave && slave->isAlive() ) {
			Connection conn = *c;
			conn.setMetaData( transfer->sourceConnection().metaData() );
			conn.setRemotePath( transfer->sourceConnection().remotePath() );
			conn.setLocalPath( transfer->sourceConnection().localPath() );
			ConnectionInfo* info = createConnectionInfo( conn, slave );
			m_connectionMap.insert( (unsigned long)(job), info );
			kdDebug()<<"KBearConnectionManager::setupCopyMove source ID="<<(unsigned long)(job)<<endl;
		}
		else
			openNewConnection( (unsigned long)(job), transfer->sourceConnection() );
	}
	if( transfer->destConnection().url().hasHost() ) {
		unsigned long ID = getIDForDirListerFromLabel( transfer->destConnection().label() );
		Connection* c = getConnection( ID );
		KIO::Slave* slave = getSlave( ID );
		if( c && c->singleConnection() && slave && slave->isAlive() ) {
			Connection conn = *c;
			conn.setMetaData( transfer->destConnection().metaData() );
			conn.setRemotePath( transfer->destConnection().remotePath() );
			conn.setLocalPath( transfer->destConnection().localPath() );
			ConnectionInfo* info = createConnectionInfo( conn, slave );
			m_connectionMap.insert( (unsigned long)(job)+1, info );
			kdDebug()<<"KBearConnectionManager::setupCopyMove dest ID="<<(unsigned long)(job)+1<<endl;
		}
		else
			openNewConnection( (unsigned long)(job)+1, transfer->destConnection() );
	}
	connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotCopyResult( KIO::Job* ) ) );
}
//-----------------------------------------------
void KBearConnectionManager::setupCopyMove( Transfer* transfer, KIO::Job* job, unsigned long sourceID, unsigned long destID ) {
	ConnectionInfo* info = 0L;
	KIO::Slave* slave = 0L;
	if( sourceID )
		slave = getSlave( sourceID );
	if( slave && transfer->sourceConnection().url().hasHost() ) {
		kdDebug()<<"KBearConnectionManager::setupCopyMove inserts ID="<<(unsigned long)(job)<<endl;
		info = createConnectionInfo( transfer->sourceConnection(), slave );
		m_connectionMap.insert( (unsigned long)(job), info );
	}
	slave = 0L;
	if( destID )
		slave = getSlave( destID );

	if( slave && transfer->destConnection().url().hasHost() ) {
		kdDebug()<<"KBearConnectionManager::setupCopyMove inserts ID="<<(unsigned long)(job)+1<<endl;
		info = createConnectionInfo( transfer->destConnection(), slave );
		m_connectionMap.insert( (unsigned long)(job)+1, info );
	}
	connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotSingleCopyResult( KIO::Job* ) ) );
}
//-----------------------------------------------
void KBearConnectionManager::jobStarting( unsigned long ID ) {
	Connection* connection = getConnection( ID );
	if( connection && connection->singleConnection() ) {
		emit enableGUI( connection->label(), false );
	}
	else {
		kdDebug()<<"KBearConnectionManager::jobStarting NO Connection ID="<<ID<<endl;
	}
}
//-----------------------------------------------
void KBearConnectionManager::pauseJob( KIO::Job* j ) {
	KBearCopyJob* job = static_cast<KBearCopyJob*>( j );
	bool sourceSuccess = true;
	bool destSuccess = true;
	KIO::Slave* sourceSlave = getSlave( (unsigned long) job );
	KIO::Slave* destSlave = getSlave( (unsigned long) job );
	if( ! job->localSrc() ) {
		if( ! sourceSlave ) {
			kdWarning()<<"KBearConnectionManager::pauseJob could not find source slave!!!!"<<endl;
			sourceSuccess = false;
		}
		else {
			sourceSlave->suspend();
		}
	}
	if( ! job->localDest() ) {
		if( ! destSlave ) {
			kdWarning()<<"KBearConnectionManager::pauseJob could not find destination slave!!!!"<<endl;
			destSuccess = false;
		}
		else {
			destSlave->suspend();
		}
	}
	if( ! job->localSrc() && sourceSlave && ! sourceSlave->suspended() )
		sourceSuccess = false;
	if( ! job->localDest() && destSlave && ! destSlave->suspended() )
		destSuccess = false;
	if( destSuccess && sourceSuccess )
		emit jobPaused( j );
}
//-----------------------------------------------
void KBearConnectionManager::resumeJob( KIO::Job* j ) {
	KBearCopyJob* job = static_cast<KBearCopyJob*>( j );
	bool sourceSuccess = true;
	bool destSuccess = true;
	KIO::Slave* sourceSlave = getSlave( (unsigned long) job );
	KIO::Slave* destSlave = getSlave( (unsigned long) job );
	if( ! job->localSrc() ) {
		if( ! sourceSlave ) {
			kdWarning()<<"KBearConnectionManager::pauseJob could not find source slave!!!!"<<endl;
			sourceSuccess = false;
		}
		else {
			sourceSlave->resume();
		}
	}
	if( ! job->localDest() ) {
		if( ! destSlave ) {
			kdWarning()<<"KBearConnectionManager::pauseJob could not find destination slave!!!!"<<endl;
			destSuccess = false;
		}
		else {
			destSlave->resume();
		}
	}
	if( ! job->localSrc() && sourceSlave->suspended() )
		sourceSuccess = false;
	if( ! job->localDest() && destSlave->suspended() )
		destSuccess = false;
	if( destSuccess && sourceSuccess )
		emit jobResumed( j );
}
//-----------------------------------------------
void KBearConnectionManager::slotSingleCopyResult( KIO::Job* job ) {
	kdDebug()<<"KBearConnectionManager::slotSingleCopyResult"<<endl;
	if( job ) {
		unsigned long ID = (unsigned long)(job);
		kdDebug()<<"KBearConnectionManager::slotSingleCopyResult source ID="<<(unsigned long)(job)<<endl;

		Connection* connection = getConnection( ID );
		if( connection )
			emit enableGUI( connection->label(), true );

		ConnectionMap::Iterator it = m_connectionMap.find( ID );
		if( it != m_connectionMap.end() ) {
			if( job->error() ) {
				emit slaveKilled( (*it)->slave );
			}
			delete m_connectionMap[ ID ];
			m_connectionMap.remove( ID );
		}
		ID = (unsigned long)(job)+1;
		kdDebug()<<"KBearConnectionManager::slotSingleCopyResult dest ID="<<(unsigned long)(job)+1<<endl;

		connection = getConnection( ID );
		if( connection ) 
			emit enableGUI( connection->label(), true );

		it = m_connectionMap.find( ID );
		if( it != m_connectionMap.end() ) {
			if( job->error() ) {
				emit slaveKilled( (*it)->slave );
			}
			delete m_connectionMap[ ID ];
			m_connectionMap.remove( ID );
		}
	}
}
//-----------------------------------------------
void KBearConnectionManager::slotCopyResult( KIO::Job* job ) {
	kdDebug()<<"KBearConnectionManager::slotCopyResult"<<endl;
	if( job ) {
		unsigned long ID = (unsigned long)(job);
		Connection* c = getConnection( ID );
		if( c && ! c->singleConnection() ) {
			KIO::Slave* slave = getSlave( ID );
			if( ! slave )
				return;
			if( slave->isAlive() ) {
				kdDebug()<<"KBearConnectionManager::slotCopyResult ID="<<ID<<" got slave="<<slave<<endl;
				slave->kill();
			}
		}
		ID = (unsigned long)(job+1);
		c = getConnection( ID );
		if( c && ! c->singleConnection() ) {
			KIO::Slave* slave = getSlave( ID );
			if( ! slave )
				return;
			if( slave->isAlive() ) {
				kdDebug()<<"KBearConnectionManager::slotCopyResult ID="<<ID<<" got slave="<<slave<<endl;
				slave->kill();
			}
		}
		slotSingleCopyResult( job );
	}
}
//-----------------------------------------------
KIO::Job* KBearConnectionManager::del( unsigned long ID, const KURL::List& urls, bool shred, bool showProgress ) {
	ConnectionMap::Iterator it = m_connectionMap.find( ID );
	if( it == m_connectionMap.end() ) {
		kdDebug()<<"KBearConnectionManager::del no info"<<endl;
		return 0L;
	}
	kdDebug()<<"KBearConnectionManager::del singleconnection="<<(*it)->connection.singleConnection()<<endl;
	KBearDeleteJob* job = KBearDeleteJob::del( urls, shred, showProgress );
	if( ! (*it)->connection.singleConnection() ) {
		openNewConnection( (unsigned long)job, (*it)->connection );
		ID = (unsigned long)job;
//		connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotDeleteResult( KIO::Job* ) ) );
	}
	job->start( ID );
	return job;
}
//-----------------------------------------------
void KBearConnectionManager::slotDeleteResult( KIO::Job* job ) {
	if( job ) {
		closeConnection( (unsigned long)job );	
	}
}
//-----------------------------------------------
KIO::Slave* KBearConnectionManager::getSlave( unsigned long ID ) {
	kdDebug()<<"KBearConnectionManager::getSlave ID"<<ID<<endl;
	if( m_connectionMap.contains( ID ) ) {
		kdDebug()<<"KBearConnectionManager::getSlave ID"<<ID<<" slave="<<m_connectionMap[ ID ]->slave<<endl;
		return m_connectionMap[ ID ]->slave;
	}
	else {
		kdDebug()<<"KBearConnectionManager::getSlave NO slave found ID"<<ID<<endl;
		return 0L;
	}
}
//-----------------------------------------------
Connection* KBearConnectionManager::getConnection( unsigned long ID ) {
	if( m_connectionMap.contains( ID ) )
		return & m_connectionMap[ ID ]->connection;
	else
		return 0L;
}
//-----------------------------------------------
void KBearConnectionManager::slotResetJob( KIO::Job* job ) {
	ConnectionMap::Iterator it;
	for( it = m_connectionMap.begin(); it != m_connectionMap.end(); ++it ) {
		if( it.data()->job == job ) {
			it.data()->job = 0L;
			return;
		}			
	}
}
//-----------------------------------------------
unsigned long KBearConnectionManager::getIDForDirListerFromLabel( const QString& label ) {
	ConnectionMap::Iterator it;
	for( it = m_connectionMap.begin(); it != m_connectionMap.end(); ++it ) {
		if( it.data()->connection.label() == label && it.data()->isDirLister ) {
			kdDebug()<<"KBearConnectionManager::getIDForDirListerFromLabel found dirlister !!!!"<<endl;
			return it.key();
		}
	}
	return 0;
}
//-----------------------------------------------
KBearConnectionManager::ConnectionInfo* KBearConnectionManager::createConnectionInfo( const Connection& conn, KIO::Slave* slave ) {
	ConnectionInfo* info = new ConnectionInfo;
	info->connection = conn;
	info->slave = slave;
	info->isDirLister = false;
	return info;
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearconnectionmanager.moc"
#endif
