/***************************************************************************
                          kbearsitemanagertreeview.h  -  description
                             -------------------
    begin                : fre mar 15 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGERTREEVIEW_H
#define KBEARSITEMANAGERTREEVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "../../base/kbeartreeview.h"
#include "../../base/site.h"
#include "../../base/group.h"

/**
  *@author Bjrn Sahlstrm
  */

class KBearSiteManagerTreeView : public KBearTreeView  {
   Q_OBJECT
public: 
	/** */
	KBearSiteManagerTreeView(QWidget *parent=0, const char *name=0);
	/** */
	~KBearSiteManagerTreeView();
	/** */
	QListViewItem* addSite( QListViewItem* parent, const QString& site );
	/** */
	QListViewItem* addGroup( QListViewItem* parent, const QString& group );
	/** */
	QString getParentString( QListViewItem* item ) const;
	/** */
	QString getFullPath( QListViewItem* item ) const;

signals:
	/** */
	void moved( const QString& parentPath, const QString& name, QListViewItem* newParent, bool );
protected:
	/**
	*Reimplemented from @ref KListView
	*/
	virtual bool acceptDrag(QDropEvent* e ) const;
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void startDrag();
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void contentsDropEvent( QDropEvent* e );
};

#endif
