/***************************************************************************
                          kbearsitemanagerplugin.h  -  description
                             -------------------
    begin                : sn mar 17 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGERPLUGIN_H
#define KBEARSITEMANAGERPLUGIN_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdom.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/plugin.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsitemanageriface.h"

class KBearSiteManager;
class KActionMenu;
class KAction;
class KSelectAction;
class KActionCollection;
class KActionSeparator;
class QListViewItem;
class KConfig;
/**
  *@author Bjrn Sahlstrm
  */

class KBearSiteManagerPlugin : public KParts::Plugin, virtual public KBearSiteManagerDCOPIface  {
   Q_OBJECT
public: 
	/** */
	KBearSiteManagerPlugin(QObject* parent=0, const char* name=0, const QStringList& args = QStringList());
	/** */
	~KBearSiteManagerPlugin();
public slots:
	/** */
	virtual void slotNewSite( Site site );
	/**	*/
	virtual void slotSiteChanged( Site site, QString oldName );
	/** */
	virtual void slotSiteRemoved( Site site );
	/**	*/
	virtual void slotSiteMoved( Site site, QString oldParent, QString oldName );
	/**	*/
	virtual void slotNewGroup( Group group );
	/**	*/
	virtual void slotGroupChanged( Group group, QString oldName );
	/**	*/
	virtual void slotGroupRemoved( Group group );
	/**	*/
	virtual void slotGroupMoved( Group site, QString oldParent );
	/**	*/
	virtual void slotEncodingChanged( QString encoding );
	/**	*/
	virtual void slotUpdateDatabase( QString domTree );
	/** */
	virtual void slotImportOldSitemanager( QString );
	/** */
	virtual void setShowSystemTray( bool );
	/** */
	virtual void setPlugInKonq( bool );
	/** */
	void slotInit();
private slots:
	void slotUpdate();
	void slotSiteSelected( const Site& );
	void slotSelectionCleared();
	void slotImportSites( const QString&);
	void slotOpenSiteManager();
	void slotOpenConnection( const Site& );
	void slotBookmarkActivated();
	void slotAddGroup();
	void slotAddGroup( const Group& name );
	void slotMoveSite( const Site& site, const QString& oldName );
	void slotMoveGroup( const Group& group, const QString& oldName );
	void slotChangeGroup( const Group&, const QString& );
	void slotChangeSite( const Site&, const QString& );
	void slotAddBookmark();
	void slotSaveSite( const Site& site );
	void slotRemoveSite( const Site& site );
	void slotRemoveGroup( const Group& group );
	void slotNewEncoding( const QString& encoding );
	void slotOpenRecent( const QString& );
	void slotClearRecent();
	void slotAddToRecent( const Site& );
	void slotRecentAboutToShow();
	void slotIdleTimeout();
	void slotShowSystemTray(bool);
	void slotPlugInKonq( bool );
private:
	void setupActions();
	void setupConnections();
	void buildTree( QDomElement, QListViewItem*, KActionMenu* );
	void parseDatabase( const QString& );
	void saveRecent();
	void loadRecent();
private:
	QCString m_DB_DCOP_Name;
	QCString m_DB_DCOP_ID;
	KBearSiteManager* m_siteManager;
	KActionMenu* m_siteManagerMenu;
	KAction* m_siteManagerAction;
	KAction* m_clearRecentAction;
	KSelectAction* m_recentAction;
	KActionSeparator* m_actionSeparator;
	KActionCollection* m_privateActionCollection;
	bool m_kbearMode;
	QTimer m_idleTimer;
	bool m_hasSelectedSite;
	Site* m_pendingSelectedSite;
};

#endif
