/***************************************************************************
                          kbeariconview.h  -  description
                             -------------------
    begin                : lr jan 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARICONVIEW_H
#define KBEARICONVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kfiledndiconview.h"
#include "../../base/connection.h"

class KActionCollection;
class QTextCodec;

/**
  *@author Bjrn Sahlstrm
  */

class KBearIconView : public KFileDnDIconView  {
   Q_OBJECT
public:
	KBearIconView(QWidget *parent, const char *name, const Connection& );
	virtual ~KBearIconView();
	/** */
	virtual void setItemTextPos( QIconView::ItemTextPos pos );
	/** */
	virtual void setArrangement( QIconView::Arrangement am );
	/** */
	virtual void setWordWrapIconText( bool b );
	/** */
	virtual void readConfig( KConfig*, const QString& group = QString::null );
	/** */
	virtual void writeConfig( KConfig*, const QString& group = QString::null );
	/** */
	virtual void insertItem( KFileItem* i );
	/** */
	virtual void updateView( const KFileItem* i );
protected:
	/**
	*Creates a @ref QDragObject containing all urls of the selected @ref KFileItem of the view,
	@returns the @ref QDragObject
	*/
	virtual QDragObject* dragObject();
private slots: // private slots
	void slotTextRight();
	void slotTextBottom();
	void slotFlowSouth();
	void slotFlowEast();
	void slotTextWordWrap( bool );
private: // Private methods
	void setupActions();
private:
	Connection m_connection;
	KActionCollection* m_privateActionCollection;
	QTextCodec* m_codec;
};

#endif
